/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*	V01.3	JRR	17-Jun-1992	Added header.
*	V01.4	JRR	11-Nov-1992	nmap needs types.h
*	V01.5	JRR	23-Feb-1993	Added Boeing enhancment for Mids.
*	V01.6	JRR	03-Mar-1994	Fixed up NMAP.
*/
/*++ fmtmidname.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.6/lib/RCS/fmtmidname.c,v $
 *
 * DESCRIPTION:
 *
 *	Return a pointer to the principal name of the machine
 *	identified by the specified machine-id.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	April 29, 1986.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.6 $ $Date: 1994/03/30 20:32:28 $ $State: Exp $)
 * $Log: fmtmidname.c,v $
 * Revision 1.6  1994/03/30  20:32:28  jrroma
 * Version 3.35.6
 *
 * Revision 1.5  93/07/13  21:31:02  jrroma
 * Version 3.34
 * 
 * Revision 1.4  92/12/22  15:45:59  jrroma
 * Version 3.30
 * 
 * Revision 1.3  92/06/18  13:23:46  jrroma
 * Added gnu header
 * 
 * Revision 1.2  92/01/16  15:41:29  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/16  15:40:36  jrroma
 * Initial revision
 * 
 *
 */

#include <sys/types.h>
#include "nmap.h"			/* Include network mapping definitions */

/*
 *	External functions.
 */
extern char *nmap_get_nam();	/* Get the principal name of a machine */
				/* based upon the machine-id */


/*** fmtmidname
 *
 *
 *	char *fmtmidname():
 *
 *	Return a pointer to the principal name of the machine
 *	identified by the specified machine-id.
 */
char *fmtmidname (Mid_t mid)
{
	static char standinbuf [14];	/* Stand-in buffer */

	register char *name;		/* Pointer to name */

	name = nmap_get_nam (mid);
	if (name == (char *) 0) {
		/*
		 *  No such machine!  Format a "stand-in" name.
		 */
		sprintf (standinbuf, "[%1lu]",  mid);
		name = standinbuf;
	}
	return (name);
}
