
/*
 * log_access	This module handles the logging of nfs accesses.
 *
 * Authors:	Renee Teunissen, <renee@freudsys.iaf.nl>
 *
 *		This software maybe be used for any purpose provided
 *		the above copyright notice is retained.  It is supplied
 *		as is, with no warranty expressed or implied.
 */

#include "nfsd.h"

/* Log an incoming access. */
void log_access(rqstp, cmd, file, arg)
struct svc_req *rqstp;
char *cmd;
char *file;
char *arg;
{
	if (rqstp->rq_cred.oa_flavor == AUTH_UNIX) {
		dprintf(0, "(%d.%d)@%s %s(%d) %s %s\n",
		   ((struct authunix_parms *)rqstp->rq_clntcred)->aup_uid, 
		   ((struct authunix_parms *)rqstp->rq_clntcred)->aup_gid, 
		   ((struct authunix_parms *)rqstp->rq_clntcred)->aup_machname,
		   cmd, rqstp->rq_proc, file, arg);
	} else { 
		dprintf(0, "%s: (flavor=%d) file=%s arg=%s\n", cmd, rqstp->rq_cred.oa_flavor, file, arg); 
	}
}

