#! /usr/local/bin/scotty -inf
##
## A simple clock for tkined. Mainly an example to demonstrate
## the job scheduler.
##
## Copyright (c) 1993, 1994
##
## S. Schoek, J. Schoenwaelder
## TU Braunschweig, Germany
## Institute for Operating Systems and Computer Networks
##
## Permission to use, copy, modify, and distribute this
## software and its documentation for any purpose and without
## fee is hereby granted, provided that this copyright
## notice appears in all copies.  The University of Braunschweig
## makes no representations about the suitability of this
## software for any purpose.  It is provided "as is" without
## express or implied warranty.
##

set clock_job ""
set clock_id ""

proc time_display {id} {

    set time [getclock]
    set sec  [expr {$time%60}]
    set min  [expr {($time%3600)/60}]
    set hour [expr {($time%86400)/3600}]

    ined -noupdate attribute $id time [format "%2d:%02d:%02d" $hour $min $sec]
    ined label $id time
}

proc "create clock" {list} {

    global clock_job clock_id

    if {$clock_job == ""} {
        set clock_id [ined -noupdate create NODE]
        ined -noupdate icon $clock_id clock
        ined -noupdate move $clock_id 100 40
        set clock_job [job create "time_display $clock_id" 1000]
    }
} 

proc "delete clock" {list} {
    
    global clock_job clock_id
    
    if {$clock_id != ""} {
        ined delete $clock_id
        set clock_id ""
    }
    if {$clock_job != ""} {
        job kill $clock_job 
        set clock_job ""
    }
}

proc  "delete Time" {list} {

    global menus
    global clock_job clock_id

    "delete clock" {}
    foreach id $menus { ined delete $id }
    exit
}

set menus [ined create MENU Time \
	  "create clock" "delete clock" "" \
	  "create job" "suspend job" "resume job" "kill job" "modify job" \
	  "job info" "" \
	  "delete Time"]

##
## Below are some generic procs that bring the job scheduler to the
## tkined user interface. They demonstrate how to program periodic 
## control or monitoring jobs.
##

proc "create job" {list} {
    
    static jobname interval count

    if {![info exists jobname]}  { set jobname "" }
    if {![info exists interval]} { set interval 5000 }
    if {![info exists count]}    { set count 0 }

    set result [ined request "Create a new job to execute." \
		 [list [list "Job Command:" $jobname] \
                       [list "Intervaltime \[ms\]:" $interval] \
                       [list "Count:" $count] ] \
                 [list create cancel] ]

    if {[lindex $result 0] == "cancel"}  return

    set jobname  [lindex $result 1]
    set interval [lindex $result 2]
    set count    [lindex $result 3]

    if {$jobname != ""} {
	job create $jobname $interval $count
    }
}

proc "suspend job" {list} {
    
    set jobnr [select_job suspend]
    if {$jobnr == ""} return

    job status $jobnr suspend
}

proc "resume job" {list} {
    
    set jobnr [select_job resume]
    if {$jobnr == ""} return

    job status $jobnr waiting
}

proc "kill job" {list} {
    
    set jobnr [select_job kill]
    if {$jobnr == ""} return
    
    job kill $jobnr
}

proc "modify job" {list} {

    set jobnr [select_job modify]
    if {$jobnr == ""} return 

    set jobname [job command $jobnr]
    set jobtime [job interval $jobnr]

    set result [ined request "Enter new values for job $jobnr ($jobname)." \
		  [list [list "Job Name:" $jobname] \
                     [list "Intervaltime \[ms\]:" $jobtime scale 100 10000] ] \
		  [list "set values" cancel] ]

    if {[lindex $result 0] == "cancel"} return

    set jobname [lindex $result 1]
    set jobtime [lindex $result 2]

    job interval $jobnr $jobtime  
    job command  $jobnr $jobname
}

proc "job info" {list} {

    set jobs [job list]

    if {$jobs == ""} {
	ined acknowledge "Sorry, no jobs available."
	return
    } 

    set result ""
    set len 0
    foreach j $jobs {

	set line \
	    [format "%s %6.1f %6.1f %3d %8s %s" \
	    [lindex $j 0] [lindex $j 2] [lindex $j 3] \
	    [lindex $j 4] [lindex $j 5] [lindex $j 1] ]

	if {[string length $line] > $len} {
            set len [string length $line]
        }

        lappend result $line
    }

    set header " ID    INTV   REM CNT  STATUS      CMD"

    for {set i [string length $header]} {$i < $len} {incr i} {
	append header " "
    }

    ined browse $header $result
}

proc select_job { action } {
    
    set jobs [job list]

    if {$jobs == ""} {
	ined acknowledge "Sorry, no job to $action."
        return
    }

    set res ""
    foreach j $jobs {
	set status [lindex $j 5]
	if {   ($action == "resume"  && $status == "suspend")
            || ($action == "suspend" && $status == "waiting")
            || ($action == "kill") || ($action == "modify")} {
		lappend res [format "%s %s" [lindex $j 0] [lindex $j 1]]
	    }
    }

    if {$res == ""} {
	ined acknowledge "Sorry, no job to $action."
	return ""
    } 

    set res [ined list "Choose a job to $action:" $res [list $action cancel]]
    if {[lindex $res 0] == "cancel"} {
	return ""
    } else {
	return [lindex [lindex $res 1] 0]
    }
}

