/*
 *
 *	netfunc.c
 *
 *	HNMS User Interface
 *	HNMS 2.0
 *
 *	February 1994
 *
 *	Leslie Schlecht
 *	Computer Sciences Corporation
 *	Numerical Aerodynamic Simulation Systems Division
 *	NASA Ames Research Center
 *
 *	Copyright (c) 1994 Leslie Schlecht
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>

#include	"defines.h"
#include	"externs.h"
#include	"object.h"

static char	buf[BUFSIZ];

/*
 *	Create a ping window.
 */
void
PingObject(o)
OBJECT	*o;
	{
	char	*s, ipaddr[BUFSIZ];
	unsigned long	ip;

	if (!o) return;
	if (!((o->class == OBJ_ipaddr) || (o->class == OBJ_processor))) return;
#ifdef sgi
	strcpy(buf, "/usr/sbin/xwsh -title Ping -e /usr/etc/ping ");
#endif
#ifdef sun
	strcpy(buf, "/usr/bin/X11/xterm -e /usr/etc/ping -s ");
#endif
	strcpy(ipaddr, o->name);
	if (o->class == OBJ_ipaddr) {
		s = NULL;
		if (s=strchr(ipaddr, '_')) *s = '\0';
		}
	strcat(buf, ipaddr);
	strcat(buf, " &");
	system(buf);
	}

/*
 *	Create a telnet window.
 */
void
TelnetObject(o)
OBJECT	*o;
	{
	char *s, ipaddr[BUFSIZ];

	if (!o) return;
	if (!((o->class == OBJ_ipaddr) || (o->class == OBJ_processor))) return;
#ifdef sgi
	strcpy(buf, "/usr/sbin/xwsh -title Telnet -e /usr/bsd/telnet ");
#endif
#ifdef sun
	strcpy(buf, "/usr/bin/X11/xterm -e /usr/ucb/telnet ");
#endif
	strcpy(ipaddr, o->name);
	if (o->class == OBJ_ipaddr) {
		s = NULL;
		if (s=strchr(ipaddr, '_')) *s = '\0';
		}
	strcat(buf, ipaddr);
	strcat(buf, " &");
	system(buf);
	}

/*
 *	Create a traceroute window.
 */
void
TracerouteObject(o)
OBJECT	*o;
	{
	char	*s, ipaddr[BUFSIZ];

	if (!o) return;
	if (!((o->class == OBJ_ipaddr) || (o->class == OBJ_processor))) return;
#ifdef sgi
	strcpy(buf, "/usr/sbin/xwsh -hold -title Traceroute -e /usr/etc/traceroute ");
#endif
#ifdef sun
	strcpy(buf, "/usr/bin/X11/xterm -e /usr/local/bin/traceroute ");
#endif
	strcpy(ipaddr, o->name);
	if (o->class == OBJ_ipaddr) {
		s = NULL;
		if (s=strchr(ipaddr, '_')) *s = '\0';
		}
	strcat(buf, ipaddr);
	strcat(buf, " &");
	system(buf);
	}
