/*
 *	help.h
 *
 *	HNMS User Interface
 *	HNMS 2.0
 *
 *	February 1994
 *
 *	Leslie Schlecht
 *	Computer Sciences Corporation
 *	Numerical Aerodynamic Simulation Systems Division
 *	NASA Ames Research Center
 *
 *	Copyright (c) 1994 Leslie Schlecht
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

typedef		struct helpentry	{
		int		pixmap;
		char		*label;
		char		*text;
		} HELPENTRY;

static HELPENTRY	help_text[] =
		{
		{
		0, 0, 0,
		},
		{
		0, "HNMS Main Panel",
		"The main panel offers access to all of the HNMS features.\n"
		"It also shows the currently selected object and status\n"
		"indicators.",
		},
		{
		0, "UI Defaults",
		"The UI defaults include a mask and a list of variables for\n"
		"each type of object, an update interval, and a background.\n"
		"All objects known by the server are announced to the UI, and\n"
		"the mask restricts the number of objects which are kept.\n"
		"The default variables are automatically subscribed-to at the\n"
		"at the default interval when an object is announced.\n",
		},
		{
		0, "H N M S",
		"This is the HNMS main menu.\n"
		"\n"
		"ITEM           FUNCTION\n"
		"\n"
		"About          Shows the version number of HNMS.\n"
		"\n"
		"New            Allows the user to select a new view.\n"
		"\n"
		"Edit Defaults  Allows the user to edit the UI defaults.\n"
		"\n"
		"Hide/Show      Hides/shows all views.\n"
		"\n"
		"Bell Off/On    Turns off/on the bell sound.\n"
		"\n"
		"Save           Saves the current UI configuration to a file.\n"
		"\n"
		"Exit           Exits the HNMS UI.\n",
		},
		{
		0, "Time-Of-Day Clock",
		"This clock shows the time of day on the UI host machine.\n",
		},
		{
		SERVBLK_PIXMAP, NULL,
		"The server icon opens the server panel and indicates the\n"
		"status of the connection to the server.  If UI receives\n"
		"nothing from the server for 10 minutes it will disconnect.\n"
		"At this point the server icon will become red and start\n"
		"flashing.  The flashing will cease when the server panel is\n"
		"opened.\n",
		},
		{
		0, "Time-Of-Last-Message Clock",
		"This clock shows the time of the last message from the\n"
		"server.\n",
		},
		{
		VIEWS_PIXMAP, NULL,
		"This button invokes the list of currently available views.\n",
		},
		{
		OBJECT_PIXMAP, NULL,
		"This button opens the list of network objects.\n",
		},
		{
		STATBLK_PIXMAP, NULL,
		"This button opens the object reachability status log and\n"
		"indicates when an object changes to unreachable.\n",
		},
		{
		HELP_PIXMAP, NULL,
		"This button opens the help panel and is found in all panels\n"
		"that offer help.\n",
		},
		{
		CLOSE_PIXMAP, NULL,
		"This button closes its panel and in the case of the main\n"
		"panel, iconifies the HNMS User Interface.\n",
		},
		{
		0, "Current Object",
		"The object and class fields of the main panel display the\n"
		"name and class of the last object selected with the mouse.\n"
		"The buttons below provide a view of the object's default\n"
		"variables, a dump of the current contents of the object,\n"
		"and access to several network functions.\n",
		},
		{
		0, "Message Log",
		"This window displays informational and error messages.\n"
		"These messages are also written to a file called\n"
		"HNMS_MessageLog in the current directory.\n",
		},
		{
		CLEAR_PIXMAP, NULL,
		"Clear the log window.\n",
		},
		{
		0, "Edit UI Defaults",
		"The UI defaults include an mask and a list of variables for\n"
		"each type of object, an update interval, and a background.\n",
				},
		{
		0, "Object Class",
		"Select the object class to edit.\n",
				},
		{
		0, "Update Interval",
		"This is the default interval value used by the UI when\n"
		"subscribing to variables.  Its units are in seconds.\n",
				},
		{
		0, "Object Mask",
		"All objects known by the server are announced to the UI, and\n"
		"the mask restricts the number of objects which are kept.\n"
		"The metacharacter '*' may be used to designate zero or more\n"
		"of any character.  For example, the string '129.99.*' as the\n"
		"object mask for subnets will restrict the UI to keep only\n"
		"those subnets whose names begin with '129.99.'.  Several\n"
		"masks may be entered for any object.",
		},
		{
		0, "Default Variables",
		"The default variables are automatically added to each object\n"
		"as it is announced to the UI.  These variables may be\n"
		"selected from the MIB List or typed in.  Interface\n"
		"identifiers and indexes must be added by the user.\n",
		},
		{
		0, "Default Background",
		"The default background is used in the WAN Status view.\n",
		},
		{
		OK_PIXMAP, NULL,
		"Save changes to the UI defaults.\n",
		},
		{
		CLOSE_PIXMAP, NULL,
		"Cancel changes to the UI defaults.\n",
		},
		{
		0, "New WAN Status View",
		"This view displays reachability status and routing\n"
		"destination for a WideArea Network on a physical background.\n"
		"The WAN Status View is defined by a background and a set of\n"
		"object masks for its processors and ipaddresses.\n",
		},
		{
		0, "Update Interval",
		"This is the interval value which is used by the view when\n"
		"subscribing to status.  Its units are in seconds.\n",
		},
		{
		0, "Object Mask",
		"Add one or more object mask strings.  The metacharacter '*'\n"
		"may be used to designate zero or more of any character.\n"
		"For example, the string 'NAS_*' as a processor mask matches\n"
		"any processor name beginning with 'NAS_'.\n",
		},
		{
		0, "Background",
		"Select the background to be used in the view.\n",
		},
		{
		OK_PIXMAP, NULL,
		"Save changes to the view.\n",
		},
		{
		CLOSE_PIXMAP, NULL,
		"Cancel changes to the view.\n",
		},
		{
		0, "New Custom Status View",
		"This view displays reachability status and routing\n"
		"destination for a set of objects in a cartesian form.\n"
		"The Custom Status View is defined by a set of object masks\n"
		"for networks, subnets, sites, processors, and ipaddresses.\n",
		},
		{
		0, "New Site Status View",
		"This view displays reachability status for a site in radial\n"
		"form.  The Site Status View is defined by one site name and\n"
		"and one or more ipaddress masks.\n",
		},
		{
		0, "Site List",
		"This is a list of the currently available sites.  The user\n"
		"may select from the list or type in a site name.\n",
		},
		{
		0, "New Object Data View",
		"This view displays a list of variables for a specific object\n"		"in text form.  The Object Data View is defined by one object\n"
		"name and one or more variables.\n",
		},
		{
		0, "Object List",
		"This is a list of the currently available objects.  The user\n"
		"may select from the list or type in an object name.\n",
		},
		{
		0, "Variable List",
		"These variables are displayed in the View. They may be\n"
		"selected from the MIB List or typed in.  Interface\n"
		"identifiers and indexes must be added by the user.\n",
		},
		{
		OBJECT_PIXMAP, NULL,
		"This panel displays all of the objects known to the UI.\n"
		"The total count appears in the title bar and the count of\n"
		"each type appears to the right of its subtitle.  Each object\n"
		"window may be sized by moving the slider below it.\n",
		},
		{
		SERVBLK_PIXMAP, NULL,
		"This panel allows the user to connect the UI to a server\n"
		"module.  It also displays information about the current\n"
		"connection.\n",
		},
		{
		0, "Server Connection",
		"A server host may be selected from the list or typed into\n"
		"the selection field.  A community name must be provided\n"
		"for connection.  Press the connect button to start the\n"
		"connect procedure.  Pressing disconnect will cancel the\n"
		"connection attempt.  NOTE: If the server disconnects from\n"
		"the UI it will initiate a reconnect and will continue until\n"
		"a connection is made or the procedure is cancelled.\n",
		},
		{
		0, "Connection Status Information",
		"FIELD          CONTENTS\n"
		"\n"
		"Last Msg       The last HNMS message type.\n"
		"\n"
		"...            Print the count of each message type since\n"
		"               connection in the log.\n"
		"\n"
		"Process Queue	The number of object requests waiting to be\n"
		"               processed.  Requests include announcements,\n"
		"               updates, relation messages, and searches.\n"
		"\n"
		"Host           The current server host.\n"
		"\n"
		"Status		The status of the current server host.\n"
		"\n"
		"Since          The time of the current server host status.\n"
		"\n"
		"UI Module Id   The id number the server assigned to the UI.\n",
		},
		{
		0, "Server Log Window",
		"This window displays the informational and error messages\n"
		"concerning the connection to the server and HNMP protocol.\n",
		},
		{
		STATBLK_PIXMAP, NULL,
		"This panel provides a log of the reachability status for\n"
		"objects currently in WAN Status, Site Status, and Custom\n"
		"Status views. If the object becomes unreachable, the bell\n"
		"will sound and the log icon will flash red until the log is\n"
		"opened.\n",
		},
		{
		MORE_PIXMAP, NULL,
		"Show: Turn off/on logging for an object type.\n"
		"Edit: Open the status log edit panel to change logging for a\n"
		"      specific object.\n",
		},
		{
		0, "Edit Status Logging",
		"Select an object and turn on/off logging and/or the bell\n"
		"sound\n",
		},
		{
		0, "WAN Status View",
		"The WAN Status View displays the reachability status and\n"
		"routing destination for a Wide Area Network.  Its contents\n"
		"are determined by a set of processors specified at creation.\n"
		"The processors and their parent sites are added to the view\n"
		"as dots within circles, the site providing location.\n"
		"Additionally, the ipaddress children of the processors and\n"
		"their parent subnets are drawn as lines.  Routes are shown\n"
		"as arrows on the subnet lines.\n",
		},
		{
		0, "Color",
		"Current status is represented by color.\n"
		"\n"
		"GREEN    =    responsive\n"
		"YELLOW   =    unresponsive\n"
		"RED      =    unreachable\n"
		"MAGENTA  =    unknown\n"
		"\n"
		"ORANGE is reserved for route arrows.\n"
		"WHITE is used for text and objects with no status such as\n"
		"GREY is used to draw backgrounds and reference lines.\n"
		"sites.\n",
		},
		{
		0, "View Title",
		"The title of the view can be edited directly.  Press enter\n"
		"to register the change.\n",
		},
		{
		MORE_PIXMAP, NULL,
		"The option menu provides access to view options:\n"
		"\n"
		"Panel:    Opens/closes  the option panel at the bottom of\n"
		"          the view.\n"
		"\n"
		"Remove:   Removes the view from the UI.\n",
		},
		{
		0, "Option Panel",
		"This panel contains information and options for the view.\n"
		"\n"
		"Route Dest:   Shows the current view route destination.\n"
		"              Route Dest may be edited directly.  Press\n"
		"              enter to register the change.  The toggle\n"
		"              button to the right turns the route display\n"
		"              on/off.\n"
		"\n"
		"Objects:      The count of the objects showing in the view\n"
		"              with the number which are unreachable.\n",
		},
		{
		0, "Custom Status View",
		"The Custom Status View displays the reachability status and\n"
		"routing destination for a set of objects.  Its contents\n"
		"are determined by a set of networks, sites, subnets, and\n"
		"processors specified at creation.  The children of the sites\n"
		"and networks are added to the view.  The processors and\n"
		"subnets and their child ipaddresses are also added. Finally,\n"
		"the missing parent processors and subnets of the ipaddresses\n"
		"are added. Processors are represented as blocks, subnets as\n"
		"lines, and ipaddresses as dots. Routes are shown as arrows.\n",
		},
		{
		0, "Site Status View",
		"The Site Status View displays the reachability status of\n"
		"the objects in a specific site.  All child processors and\n"
		"and their child ipaddresses are added to the view as blocks\n"
		"and dots respectively.  Additionally, the subnet parents of\n"
		"the ipaddresses are shown as concentric circles.\n"
		},
		{
		MORE_PIXMAP, NULL,
		"The option menu provides access to view options:\n"
		"\n"
		"Remove:   Removes the view from the UI.\n",
		},
		{
		0, "Object Data View",
		"This view provides a method to monitor specific variables\n"
		"one object.  Each variable is listed with its value and\n"
		"time of last update.\n",
		},
		{
		0, "Object Dump",
		"The object dump is a snapshot of the object.  Unlike the\n"
		"other views, the dump is not kept updated as values change.\n"
		"This panel displays a list of views that are interested in\n"
		"the object, its variables, and its relations.\n",
		},
		{
		0, "Variable List",
		"The variable list shows the value, update interval and the\n"
		"time of last change for each variable currently in the\n"
		"object's subscription.  If there is no time present the\n"
		"UI has not received an update from the server.\n",
		},
		{
		0, "View List",
		"This is a list of all views that have requested variables\n"
		"from the object and whether their request is active or\n"
		"passive.  Active requests will initiate a subscription to\n"
		"for the variable to the server. Passive views are only\n"
		"interested in receiving the variable if some other view is\n"
		"getting it (e.g. the status log) and will not activate a\n"
		"subscription.  The default view is always present whether or\n"
		"not there are default variables.\n",
		},
		{
		0, "Relations List",
		"This is a list of all the parents and children of the object\n"
		"known by the UI.\n",
		},
		};
