/*
 *
 *	flash.c
 *
 *	Support for flashing buttons.
 *
 *	HNMS User Interface
 *	HNMS 2.0
 *
 *	February 1994
 *
 *	Leslie Schlecht
 *	Computer Sciences Corporation
 *	Numerical Aerodynamic Simulation Systems Division
 *	NASA Ames Research Center
 *
 *	Copyright (c) 1994 Leslie Schlecht
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 1, or (at your option)
 *	any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include	<stdio.h>

#include	<X11/Intrinsic.h>

#include	"defines.h"
#include	"externs.h"

typedef		struct fentry {
			void	(*f)();
			Widget	widg;
			caddr_t	val1, val2;
			int	on;
			struct fentry *n;
			} FENTRY;

static FENTRY	*flash_root=NULL;


void	AddFlash();
void	DestroyFlashes();
void	FlashColor();
void	RemoveFlash();
void	StartFlash();
void	StopFlash();
int	UpdateFlash();


/*
 *	Add a flash entry.
 */
void
AddFlash(func, widg, val1, val2)
void (*func)();
Widget	widg;
caddr_t	val1, val2;
	{
	FENTRY	*f;

	if (!flash_root) {
		flash_root = (FENTRY*)myalloc(NULL, 1, sizeof(FENTRY));
		flash_root->f = func;
		flash_root->widg = widg;
		flash_root->val1 = val1;
		flash_root->val2 = val2;
		flash_root->on = 1;
		FlashIt(widg, 0);
		}
	else {
		for (f=flash_root; f; f=f->n) {
			if ((f->widg == widg)) {
				f->f = func;
				f->val1 = val1;
				f->val2 = val2;
				return;
				}
			}
		f->n = (FENTRY*)myalloc(NULL, 1, sizeof(FENTRY));
		f = f->n;
		f->f = func;
		f->widg = widg;
		f->val1 = val1;
		f->val2 = val2;
		}
	}


/*
 *	Destroy all flash entries.
 */
void
DestroyFlashes()
	{
	FENTRY	*f;

	while (flash_root) {
		f = flash_root;
		f->f(f->widg, f->val1, f->val2, 1);
		flash_root = flash_root->n;
		free(f);
		}
	}


/*
 *	Set the color of a flashing widget.
 */
void
FlashColor(w, color1, color2, on)
Widget	w;
int	color1, color2, on;
	{
	if (on)
		WidgetColor(w, color2);
	else
		WidgetColor(w, color1);
	}


/*
 *	Set the color of a flashing widget.
 */
void
FlashPixmap(w, pix1, pix2, on)
Widget	w;
int	pix1, pix2, on;
	{
	if (on)
		WidgetPixmap(w, pix2);
	else
		WidgetPixmap(w, pix1);
	}


/*
 *	Remove a flash entry.
 */
void
RemoveFlash(widg)
Widget	widg;
	{
	FENTRY	*f1, *f2;

	if (!flash_root) return;
	if (flash_root->widg == widg) {
		f2 = flash_root;
		flash_root = flash_root->n;
		free(f2);
		}
	else {
		f1 = flash_root;
		f2 = flash_root->n;
		while (f2) {
			if (f2->widg == widg) {
				f1 = f2->n;
				free(f2);
				}
			f1 = f2;
			f2 = f2->n;
			}
		}
	}


/*
 *	Start a widget flashing.
 */
void
StartFlash(w, val1, val2, pixmap)
Widget	w;
int	val1, val2;
int	pixmap;
	{
	if (pixmap) {
		WidgetPixmap(w, val2);
		AddFlash(FlashPixmap, w, val1, val2);
		}
	else {
		WidgetColor(w, val2);
		AddFlash(FlashColor, w, val1, val2);
		}
	}


/*
 *	Stop a widget from flashing.
 */
void
StopFlash(w, color, pixmap)
Widget	w;
int	color;
int	pixmap;
	{
	RemoveFlash(w);
	if (pixmap)
		WidgetPixmap(w, pixmap);
	else
		WidgetColor(w, color);
	}


/*
 *	Call the function that colors the widget.
 */
int
UpdateFlash()
	{
	FENTRY	*f;

	if (!flash_root) return(0);
	for (f=flash_root; f; f=f->n) {
		f->f(f->widg, f->val1, f->val2, f->on);
		if (f->on)
			f->on = 0;
		else
			f->on = 1;
		}
	return(1);
	}
