// Program     : x10-amh
// Version     : 1.01
// Description : X10 Model CP-290 control program (available at Radio Shack)
//               (computer control for X10 modules)
//               This application allows you to control lights and appliances
//               in your home either directly, or through a crontab
// Author      : Copyright (C) 1995 Aaron Hightower (aaron@paradigmsim.com)
//               1217 Shirley Way
//               Bedford, TX  76022 (817)267-6001
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

class x10 {

  private:

    int verbose;
    int hc_char;
    int hc;
    int fd;

  public:

     x10( int _fd );
    ~x10();

  public:

    int    wack           ( );
    int    wreport        ( );
    void   dump           ( );
    void   send_housecode ( );
    void   config_serial  ( );
    void   selftest       ( );
    void   settime        ( );
    void   gettime        ( );
    void   getevents      ( );
    void   verbose_on     ( );

    void   msg            ( u_char *msg, int len      );
    u_char checksum       ( u_char *bytes, int len    );
    void   direct         ( u_char command, char *str );
    void   fd             ( int _fd                   );
    void   housecode      ( int _hc                   );

};
