#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <linux/fd.h>
#include <linux/fdreg.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <linux/fs.h>
#include <linux/major.h>
#include "enh_options.h"


int eioctl(int fd, int command,void * param, char *emsg)
{
  int r;
  if ((r=ioctl(fd,command,param))<0 )
    {
      perror(emsg);
      exit(1);
    }
  return r;
}


void main(int argc, char **argv)
{

#ifdef FD_RAW_NO_MOTOR
	int mask=0;
	int fd=-2;
	char *command=0;
	int interval=10;
	char ch;
	struct timeval timval;
	struct floppy_raw_cmd raw_cmd;
	struct stat buf;
	int drive;

	struct enh_options optable[] = {
	{ 'd', "drive", 1, EO_TYPE_FILE_OR_FD, 3, 0,
		  (void *) &fd,
		  "drive to be polled"},
		
	{ 'e', "exec", 1, EO_TYPE_STRING, 0, 0,
		  (void *) &command,
		  "shell command to be executed after disk insertion" },
		
	{ 'i', "interval", 1, EO_TYPE_LONG, 0, 0, 
		  (void *) &interval,
		  "set polling interval (in tenth of seconds)" },
	{ '\0', 0 }
	};

	while((ch=getopt_enh(argc, argv, optable, 
			     0, &mask, "drive") ) != EOF ){
		if ( ch== '?' ){
			fprintf(stderr,"exiting\n");
			exit(1);
		}
		printf("unhandled option %d\n", ch);
		exit(1);
	}

	if ( fd == -2 )
		fd = open("/dev/fd0", 3 | O_NDELAY | O_EXCL);
	if ( fd < 0 ){
		perror("can't open floppy drive");
		print_usage(argv[0],optable,"");
	}

	if (fstat (fd, &buf) < 0) {
		perror("fstat");
		exit(1);
	}
	if (MAJOR(buf.st_rdev) != FLOPPY_MAJOR) {
		fprintf(stderr,"Not a floppy drive\n");
		exit(1);
	}
	drive = MINOR( buf.st_rdev );
	drive = (drive & 3) + ((drive & 0x80) >> 5);

	/* reset the fdc, if needed */
	eioctl(fd, FDRESET, FD_RESET_IF_NEEDED, "reset");

	/* then recalibrate the disk */
	raw_cmd.flags = FD_RAW_INTR;
	raw_cmd.cmd_count = 2;
	raw_cmd.cmd[0] = FD_RECALIBRATE;
	raw_cmd.cmd[1] = drive;
	eioctl(fd, FDRAWCMD, (void *)&raw_cmd, "recalibrate");
	if ( !( raw_cmd.flags & FD_RAW_DISK_CHANGE)){
		close(fd);
		if ( command)
			system(command);
		exit(0);
	}

	while(1){
		/* Interestingly enough, rseek doesn't seem to work... */
		raw_cmd.flags = FD_RAW_INTR | FD_RAW_NO_MOTOR;
		raw_cmd.cmd_count = 3;
		raw_cmd.cmd[0] = FD_SEEK;
		raw_cmd.cmd[1] = drive & 3;
		raw_cmd.cmd[2] = 1;
		eioctl(fd, FDRAWCMD, (void *)&raw_cmd, "blind seek");

		raw_cmd.flags = FD_RAW_INTR | FD_RAW_NO_MOTOR_AFTER;
		raw_cmd.cmd_count = 3;
		raw_cmd.cmd[0] = FD_SEEK;
		raw_cmd.cmd[1] = drive & 3;
		raw_cmd.cmd[2] = 0;
		eioctl(fd, FDRAWCMD, (void *)&raw_cmd, "real seek");
			
		if ( !( raw_cmd.flags & FD_RAW_DISK_CHANGE)){
			close(fd);
			if ( command)
				system(command);
			exit(0);
		}
		
		timval.tv_sec = interval / 10;
		timval.tv_usec = (interval % 10) * 100000;
		if(select(0, 0, 0, 0, &timval) < 0 ){
			perror("select");
			exit(1);
		}
	}
#else
	fprintf(stderr,"This program needs FD_RAW_NO_MOTOR support\n");
	exit(1);
#endif
}

       
