/*
 * Do full cylinder buffered writes to slow devices.  Uses a simple
 * buffered read/delayed write algorithm
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <stdlib.h>
#include "msdos.h"

/*static int read_cyl();*/
extern int lastwhere;

void
disk_write(start, buf, len)
long start;
unsigned char *buf;
int len;
{
	register long i;
	unsigned char *buf_ptr, *disk_ptr;
	long where, tail;

					/* don't use cache? */
	if (disk_size == 1) {
		where = (start * msector_size) + disk_offset;
		if (where != lastwhere &&
		    lseek(fd, where, 0) < 0) {
			perror("disk_write: lseek");
			exit(1);
		}
					/* write it! */
		if (write(fd, (char *) buf, (unsigned int) len) != len) {
			perror("disk_write: write");
			exit(1);
		}
		lastwhere = where + len;
		return;
	}

	tail = start + (len / msector_size) - 1;
	for (i = start; i <= tail; i++) {
					/* a cache miss... */
		if (i < disk_current ||
		    i >= disk_current + disk_size ||
		    i > disk_current + disk_cur_size ||
		    ( i != disk_current && i % disk_size == 0 )) {
			if (disk_dirty)
				disk_flush();

			disk_current = i;
			disk_cur_size = 0;
		}
		/* a cache hit ... */
		buf_ptr = buf + ((i - start) * msector_size);
		disk_ptr = disk_buf + ((i - disk_current) * msector_size);
		memcpy((char *) disk_ptr, (char *) buf_ptr, msector_size);
		disk_dirty = 1;
		if ( i == disk_current + disk_cur_size )
			disk_cur_size++;
	}
	return;
}

/*
 * Flush a dirty buffer to disk.  Resets disk_dirty to zero.
 * All errors are fatal.
 */

void
disk_flush()
{
	int len;
	long where;

	if (fd < 0 || disk_current < 0L || !disk_dirty)
		return;
	where = (disk_current * msector_size) + disk_offset;
	if (where != lastwhere &&
	    lseek(fd, where, 0) < 0) {
		perror("disk_flush: lseek");
		exit(1);
	}
					/* write it! */
	len = disk_cur_size * msector_size;
	if (write(fd, (char *) disk_buf, (unsigned int) len) != len) {
		perror("disk_flush: write");
		exit(1);
	}
#if 0
	printf("disk pos=%d contents=0x%x len=%d\n",
	       where + 512 * 254, disk_buf[512*254], len);
#endif
	lastwhere  = where + len;
	disk_dirty = 0;
	return;
}

/*
 * Determine if the cylinder has some useful information on it.  Returns a 1
 * if it needs to be read.
 */
#if 0
static int
read_cyl(sector)
long sector;
{
	register unsigned int i;
	unsigned int start, end;

	if (!sector)
		return(1);

	start = ((sector - dir_start - dir_len) / clus_size) + 2;
	end = ((sector + disk_size - dir_start - dir_len) / clus_size) + 2;

	for (i = start; i < end; i++) {
					/* if fat_decode returns non-zero */
		if (fat_decode(i))
			return(1);
	}
	return(0);
}
#endif


