/* stats.c -- Read and parse one line of Stats
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,92,93  Lele Gaifax (lele@nautilus.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include    "tua_4_taylor.h"

#ifdef TAYLOR_UUCP

#include    <time.h>

/*
 * Standard Taylor Uucp Stats format
 * USER SYSTEM (1992-11-07 00:29:53.89) received BYTES bytes in TIME seconds (213 bytes/sec)
 * USER SYSTEM (1992-11-07 00:29:53.89) failed after received BYTES bytes in TIME seconds (213 bytes/sec)
 *
 * As modified by me:
 * USER SYSTEM (1992-11-07 00:29:53.89) received BYTES bytes in TIME seconds (213 bytes/sec) on port PORTNAME 
 * USER SYSTEM (1992-11-07 00:29:53.89) failed after received BYTES bytes in TIME seconds (213 bytes/sec) on port PORTNAME
 */
int
DEFUN (GetStats, (fp, sentry),
       FILE * fp AND struct stats * sentry)

{
  char line[LINE_BUFFER_SIZE], * datebuffer;
  extern int atoi ();
  extern double EXFUN(atof, (CONST char *));
  Julian_t timestamp;
  CONST char * current_token;

  debug_newline();
  if (fgets (line, LINE_BUFFER_SIZE, fp) == NULL)
    return (EOF);

  xfree (sentry->User);
  xfree (sentry->System);
#ifdef TAYLOR_LOGS_PATCH  
  xfree (sentry->PortName);
  sentry->PortName = 0;
#endif
  
  sentry->User = savestring (strtok (line, " "));
  sentry->System = savestring (strtok (NULL, " "));

  datebuffer = strtok (NULL, ")") + 1;
  sentry->TimeStamp = timestamp = parse_date (datebuffer);

  if (fstrcmp (current_token = strtok (NULL, " "), "failed") == 0)
    {
      /* this is an entry of this type:
       * lele nautilus (1992-11-07 00:15:31.19) failed after...
       */
      strtok (NULL, " ");	/* skip "after" */
      current_token = strtok (NULL, " "); /* take the direction string  */
      sentry->failed = TRUE;
    }
  else
    sentry->failed = FALSE;
  
  if (fstrcmp (current_token, "sent") == 0)
    sentry->Direction = SENT;
  else
    sentry->Direction = RECEIVED;

  sentry->Bytes = atof (strtok (NULL, " "));
  strtok (NULL, " ");		/* skip "bytes" */
  strtok (NULL, " ");		/* skip "in" */
  sentry->Time = atof (strtok (NULL, " "));

#ifdef DEBUG
  if (sentry->Time > 2*60*60)
    debug_printf ("Strange time: %f", sentry->Time);
#endif
      
#ifdef TAYLOR_LOGS_PATCH
  if (strtok (NULL, ")")==NULL || /* skip (xxx bytes/sec) */
      strtok (NULL, " ")==NULL || /* skip "on" */
      strtok (NULL, " ")==NULL)	/* skip "port" */
    sentry->PortName = 0;
  else
    sentry->PortName = savestring (strtok (NULL, ""));
#endif
  
  return OK;
}

#endif /* TAYLOR_UUCP */

