/* readl_supp.c -- GNU Readline Support Functions
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,92,93  Lele Gaifax (lele@nautilus.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "tua.h"
#include <readline/readline.h>
#include <readline/history.h>

static char *line_read = NULL;

char *
DEFUN (readline_gets, (prompt),
       char *prompt)

{
  xfree (line_read);
  line_read = NULL;

  line_read = readline (prompt);

  if (line_read && *line_read)
    add_history (line_read);

  return line_read;
}

void
DEFUN (initialize_readline, (progname),
       CONST char *progname)
{
  rl_readline_name = (char *) progname;
}
