/* xferentry.c -- Process .Admin/xferstat: reads each line, parses it
 *                and returns the values in it.
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,92,93  Lele Gaifax (lele@nautilus.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include    "tua_4_hdb.h"

#ifdef HDB_UUCP

#ifdef HDB_ERR_FACT
double ERRFACT = HDB_ERR_FACT;
#endif

int
DEFUN (GetXferEntry, (fp, entry),
       FILE * fp AND struct xferentry *entry)

{
  char line[LINE_BUFFER_SIZE], * datebuffer;
  extern int atoi ();
  extern double EXFUN(atof, (CONST char *));

  xfree (entry->System);
  xfree (entry->User);
  xfree (entry->PortName);
  entry->System = entry->User = entry->PortName = 0;
  
  if (fgets (line, LINE_BUFFER_SIZE, fp) == NULL)
    return (EOF);

  entry->System = savestring (strtok (line, "!"));
  entry->User = savestring (strtok (NULL, " "));
  strtok (NULL, "(");
  datebuffer = strtok (NULL, ")");
  entry->TimeStamp = parse_date (datebuffer);

  (void) strtok (NULL, "[");
  entry->PortName = savestring (strtok (NULL, "]"));
  if (fstrcmp ("<-", strtok (NULL, " ")))
    entry->Direction = SENT;
  else
    entry->Direction = RECEIVED;

  entry->Bytes = atof (strtok (NULL, " "));

#ifdef HDB_ERR_FACT
  entry->Time = atof (strtok (NULL, " /")) / ERRFACT;
#else
  entry->Time = atof (strtok (NULL, " /"));
#endif

  return OK;
}

#endif /* HDB_UUCP */
