/* procuucp.c -- Read and process .Log/uucp/
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,92,93  Lele Gaifax (lele@nautilus.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include    "tua_4_hdb.h"

#ifdef HDB_UUCP

#if defined(DIRENT) || defined(_POSIX_VERSION)
#include <dirent.h>
#define NLENGTH(dirent) (strlen((dirent)->d_name))
#else /* not (DIRENT or _POSIX_VERSION) */
#define dirent direct
#define NLENGTH(dirent) ((dirent)->d_namlen)
#ifdef USG
#ifdef SYSNDIR
#include <sys/ndir.h>
#else /* not SYSNDIR */
#include <ndir.h>
#endif /* not SYSNDIR */
#else /* not USG */
#include <sys/dir.h>		/* Assume SYSDIR, or not if you want. */
#endif /* not USG */
#endif /* not (DIRENT or _POSIX_VERSION) */

static void
DEFUN (ProcUucpEntry, (fp, sys),
       FILE * fp AND
       char *sys)
{
  char line[LINE_BUFFER_SIZE];
  system_rec_t *sr = insert_system (sys);

  if (!sr->Killed)
    {
#ifdef DEBUG
      if (be_verbose)
	fprintf (stderr, "%s:\n", sys);
#endif
      
      while (fgets (line, LINE_BUFFER_SIZE, fp) != NULL)
	{
	  command_rec_t *cr;
	  user_rec_t *ur;
	  char *User;
	  char commandline[128];
	  char *file1, *file2;

	  debug_newline();

	  User = strtok (line, " ");
	  ur = insert_user (User);
	  (void) strtok (NULL, ")");
	  (void) strtok (NULL, "(");
	  file1 = strtok (NULL, " ");
	  (void) strtok (NULL, " ");
	  file2 = strtok (NULL, ")");
	  sprintf (commandline, "uucp %s %s", file1, file2);
	  if (!ur->Killed)
	    {
	      cr = insert_command (&ur->Commands, commandline);
	      cr->Number++;
	    }
	  cr = insert_command (&sr->Commands, commandline);
	  cr->Number++;
	}
    }
}

int
DEFUN_VOID (read_uucp_log)
{
  DIR *dirfp;
  struct dirent *direntry;
  char dirname[LPNMAX];
  int ret_value = OK;

  sprintf (dirname, "%s/%s", logs_prefix_path_opt, UUCP_DIR);
  if ((dirfp = opendir (dirname)) == NULL)
    {
      LOG ("cannot read %s", dirname);
      ret_value = ERROR;
    }
  else
    {
#ifdef DEBUG
      if (be_verbose)
	fputs ("\nProcessing uucp logs:", stderr);
#endif
      
      while ((direntry = readdir (dirfp)) != NULL)
	{
	  FILE *UucpFp;
	  char PathName[LPNMAX];
	  char System[15];

	  if (*direntry->d_name == '.')
	    continue;

	  sprintf (System, "%.*s", (int) NLENGTH (direntry), direntry->d_name);

	  if (just_some_system_opt &&
	      (search_system (System) == (system_rec_t *) NULL))
	    continue;
	  sprintf (PathName, "%s/%s/%s", logs_prefix_path_opt, UUCP_DIR, System);
	  debug_filename (PathName);
	  if ((UucpFp = fopen (PathName, "r")) == (FILE *) NULL)
	    {
	      LOG ("cannot open %s", PathName);
	      ret_value = ERROR;
	      break;
	    }

	  ProcUucpEntry (UucpFp, System);
	  debug_end();
	  
	  fclose (UucpFp);
	}
    }

  if (dirfp)
    closedir (dirfp);

  return ret_value;
}

#endif /* HDB_UUCP */
