/* globalias.h - GlobAlias Queues Building Functions Header.
 *
 * This file is part of TUA.
 *
 *   Copyright (C) 1991,92,93  Lele Gaifax (lele@nautilus.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

typedef struct glob_aliases_queue
{
  CONST char * Name;
  CONST char * Alias;
  struct glob_aliases_queue * Next;
} glob_aliases_queue_t;

#define	QNULL	(glob_aliases_queue_t *) NULL

/* Insert a new globalias in the list. */
extern void EXFUN (globalias_insert, (glob_aliases_queue_t **, CONST char *, CONST char *));

/*
 Search for an alias for a name. Returns the alias if it was there,
 otherwise the name itself.  
*/     
extern CONST char * EXFUN (globalias_search, (CONST glob_aliases_queue_t *, CONST char *));
