/* debug.h 
 * Debugging declarations
 *
 * This file is part of TUA.
 * 
 *   Copyright (C) 1991,92,93  Lele Gaifax (lele@nautilus.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

extern void EXFUN(dbg_set_current_file_name, (CONST char * filename));
extern void EXFUN(dbg_message, (CONST char * messg));
extern void EXFUN(dbg_print_new_line_number, (void));
extern void EXFUN(dbg_printf, (CONST char * fmt DOTS));
extern void EXFUN(dbg_end, (void));
     
#ifdef DEBUG
#define debug_filename(filename) dbg_set_current_file_name(filename)
#define debug_message(msg)	dbg_message(msg)
#define debug_newline() 	dbg_print_new_line_number()
#define debug_end()		dbg_end()

/*
 * Here I use a gcc 2.x feature: varargs macros. In Standard C I merely
 * #define a name, not a macro. Unfortunately this means that a function
 * call will occur also if the code is compiled without -DDEBUG, since in
 * no way a Standard C precompiler will skip this statement... Use gcc!
 *
 * NeXTstep 3.0 uses GCC 1.93, that do not support variable arguments to
 * macros. Too bad that it defines __GNUC__=2!. Fortunately, I can
 * isolate this by checking for __NeXT that is defined only by the FSF
 * GCC 2.x (at least 2.4.3).
 *
 */
#if defined(__GNUC__) && (__GNUC__ >= 2) && (!defined(__NeXT__) || defined(__NeXT))
     
#define debug_printf(msg, args...) dbg_printf(msg, ## args)
     
#else

#define debug_printf dbg_printf
     
#endif
     
#else /* NO DEBUG */
     
#define debug_message(msg)
#define debug_filename(filename)
#define debug_newline()
#define debug_end()

#if defined(__GNUC__) && (__GNUC__ >= 2) && (!defined(__NeXT__) || defined(__NeXT))

#define debug_printf(msg, args...)

#else

#define debug_printf dbg_printf
     
#endif

#endif

