/* Customizations of the TUA package
 * Follow the comments to adjust the configuration.
 *
 * This file is part of TUA.
 *
 *   Copyright (C) 1991,92,93  Lele Gaifax (lele@nautilus.sublink.org)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the license, or (at
 *   your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * MAX PATHNAME LENGTH:
 * Do not define anything for Xenix boxes
 * This is a constant to specify the maximum length of a pathname.
 */
#define LPNMAX 128	/* For all the other but Xenix */

/*
 * HDB-Uucp CORRECTION FACTOR:
 * HDB-Uucp, as implemented by SCO, has a bug: it fails calculating the
 * connection and tranfer time. Experimentally, I found in 2.5 the right
 * factor to correct these values.
 * If your HDB is ok, do not define anything. Otherwise uncomment the next
 * line; I hope 2.5 is ok for you. However, if you define this constant, there
 * will be an option ('+hdb-factor') that lets you modify the value at 
 * runtime.
 * PS: For the xenix 386 boxes, there is a SLS that corrects this bug.
 * It was told me that ODT 1.1 and SCO Unix 3.2.2 are ok... at least in
 * this!
 */
/* #define HDB_ERR_FACT 2.5 */	/* For broken hdb */

/*
 * NET_DOMAIN:
 * Write here your exact domain. If your gethostname(2) returns your
 * FQDN (Fully Qualified Domain Name) then define it will be ignored.
 */
#define NET_DOMAIN	".sublink.org"

/*
 * PCD  Pathname:
 * This is the pathname of the file containing the settings needed to subdivide
 * the phone costs.
 * LIBDIR is defined in the Makefile.
 */
#define PCD_FILENAME LIBDIR "/tua.pcd"

/*
 * UUCP SUPPORT:
 * Define TAYLOR_UUCP if you are using Taylor Uucp on your
 * machine.
 * Define HDB_UUCP if you are using HDB (aka BNU) Uucp on
 * your machine.
 * You can define 'em both, so you will choose the mode
 * with a command line option (--taylor-uucp || --hdb-uucp)
 */
#define TAYLOR_UUCP
#define HDB_UUCP

#if !defined (TAYLOR_UUCP) && !defined (HDB_UUCP)
#error At least one of these must be defined!
#endif

#if defined(TAYLOR_UUCP) && defined(HDB_UUCP)
#define BOTH_OF_THEM

/* Set this to FALSE if you want HDB Uucp be the default choice. */
#define DEFAULT_MODE_IS_TAYLOR TRUE
#endif

/*
 * DEFAULT SPOOL DIR
 * Default path for the uucp spool directory
 *
 */
#ifdef TAYLOR_UUCP
#define DEFAULT_TAYLOR_SPOOL_DIR	"/usr/local/spool/uucp"
#endif

#ifdef HDB_UUCP
#define DEFAULT_HDB_SPOOL_DIR	"/usr/spool/uucp"
#endif

/*
 * HDB-UUCP LOGS FILENAMES:
 * These are the pathname of the various logs TUA reads.
 * They are no absolute, because tua has a flag, for debugging, that
 * sets the root dir for them. If you do not specify that flag,
 * DEFAULT_HDB_SPOOL_DIR is used as a prefix path.
 */
#define	XFER_NAME   ".Admin/xferstats"
#define UUCICO_DIR  ".Log/uucico"
#define UUXQT_DIR   ".Log/uuxqt"
#define UUX_DIR	    ".Log/uux"
#define UUCP_DIR    ".Log/uucp"

/*
 * TAYLOR UUCP LOGS FILENAMES:
 * They are in DEFAULT_TAYLOR_SPOOL_DIR
 */
#define STATS_NAME  "Stats"
#define LOG_NAME    "Log"

/*
 * HISTORY FILENAME
 * The pathname of the history file.
 * It will be placed under DEFAULT_SPOOL_DIR, unless it
 * begins with a '/'
 */
#define TAYLOR_HISTORY     "tua.history"
#define HDB_HISTORY	   ".Admin/tua.history"

/*
 * SYSTEM NAME DETERMINATION:
 * Specify in SYSTEMID the file that contain the name of your system if
 * your os uses this way to get it; Xenix can use both /etc/systemid and
 * uname(), but in the latter manner you have to relink the kernel to 
 * put it in.
 * Leave it undefined if you want use uname() instead of a filename.
 */
/* #define SYSTEMID	"/etc/systemid"	*/ /* For xenix box (if you want!) */

/*
 * TUA INITIALIZATION SCRIPT:
 * This is the pathname of a TCL script that TUA tries to load once the
 * command line options are evaluated.
 * If you didn't define USE_TCL (See Makefile), it will be completely
 * ignored.
 */
#define TUA_INIT_SCRIPT "/usr/local/gnulib/TUA_init.tcl"

/*
 * TCL INIT COMMAND:
 * This is the TCL command to load and execute the Initialization Script
 * %s will be replaced with TUA_INIT_SCRIPT on startup.
 */  
#define TCL_CMD    "if [file exists %s] {source %s}"

/*
 * LINE BUFFER SIZE:
 * This is the size for the buffers when TUA reads a single line from the
 * logs.
 */
#define LINE_BUFFER_SIZE 512

/* TAYLOR LOGS PATCH APPLIED:
 * Define this if you want TUA be able to extract port info from the Stats
 * file. In order to do to this, you must first apply the patch contained
 * in the file taylor/TaylorLogsPatch.diff to Taylor Uucp sources, and
 * recompile it. I sent this patch to Ian on 93/7/20, but I do not know 
 * what Ian will do of it.
 * You can let this defined, since TUA is smart enough to recognize
 * non-patched logs. */
#define TAYLOR_LOGS_PATCH
