/*:ts=8*/
/*****************************************************************************
 * FIDOGATE --- Gateway UNIX Mail/News <-> FTN NetMail/EchoMail
 *
 * $Id: prototypes.h,v 3.9.2.0 1995/06/12 17:14:03 mj Exp $
 *
 * Prototypes for functions in libfidogate.a
 *
 *****************************************************************************
 * Copyright (C) 1990-1995
 *  _____ _____
 * |     |___  |   Martin Junius             FIDO:      2:2452/110.1
 * | | | |   | |   Republikplatz 3           Internet:  mj@sungate.fido.de
 * |_|_|_|@home|   D-52072 Aachen, Germany   Phone:     ++49-241-86931 (voice)
 *
 * This file is part of FIDOGATE.
 *
 * FIDOGATE is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FIDOGATE is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with FIDOGATE; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

/* address.c */
extern int i_flag;
extern char address_error[];

int	parse_address		P((char *, char *, Node *));
int	isfido			P((void));
char   *ftn_to_inet		P((Node *, int));
Node   *inet_to_ftn		P((char *));
int	addr_is_local		P((char *));

/* aliases.c */
void	alias_init		P((void));
Alias  *alias_lookup		P((Node *, char *, char *));

/* areas.c */
void    areas_init		P((void));
Area   *areas_lookup		P((char *, char *));

/* areasbbs.c */
int	areasbbs_init		P((char *));
int	areasbbs_print		P((FILE *));
AreasBBS *areasbbs_first	P((void));
AreasBBS *areasbbs_lookup	P((char *));

/* binkley.c */
#define NOWAIT		0
#define WAIT		1

#define CHECK_FILE	0
#define CHECK_DIR	1


int	bink_bsy_create_all	P((int));
int	bink_bsy_delete_all	P((void));
char   *bink_out_name		P((Node *));
char   *bink_bsy_name		P((Node *));
int	bink_bsy_test		P((Node *));
int	bink_bsy_create		P((Node *, int));
int	bink_bsy_delete		P((Node *));
char   *bink_find_flo		P((Node *, char *));
char   *bink_find_out		P((Node *, char *));
int	bink_attach		P((Node *, int, char *, char *, int));
int	check_access		P((char *, int));
int	bink_mkdir		P((Node *));
long	check_size		P((char *));
int	check_old		P((char *, time_t dt));

/* bounce.c */
int	print_file_subst	P((FILE *, FILE*, Message*, char*, Textlist*));
int	bounce_header		P((char *, char *));
int	bounce_mail		P((char *, RFCAddr *, Message *,
				   char *, Textlist *));

/* bufstring.c */
char   *buf_sprintf		P((char *, ...));
char   *buf_copy		P((char *));

/* charset.c */
void	charset_reset		P((void));
void	charset_set		P((char *));
char   *charset_xlate		P((int));

/* config.c */
void	cf_debug		P((void));
Node   *cf_main_addr		P((void));
Node    cf_n_main_addr		P((void));
Node   *cf_addr			P((void));
Node   *cf_uplink		P((void));
Node	cf_n_addr		P((void));
Node	cf_n_uplink		P((void));
void	cf_set_curr		P((Node *));
void	cf_set_zone		P((int));
int	cf_zone			P(());
int	cf_defzone		P(());
char   *cf_getline		P((char *, int, FILE *));
void	cf_read_config_file	P((char *));
void	cf_initialize		P((void));
void	cf_set_addr		P((char *));
void	cf_set_uplink		P((char *));
void	cf_set_libdir		P((char *));
void	cf_set_spooldir		P((char *));
void	cf_set_logdir		P((char *));
char   *cf_libdir		P((void));
char   *cf_spooldir		P((void));
char   *cf_logdir		P((void));
char   *cf_hostname		P((void));
char   *cf_domainname		P((void));
char   *cf_hostsdomain		P((void));
char   *cf_fqdn			P((void));
char   *cf_origin		P((void));
char   *cf_organization		P((void));
void	cf_set_outbound		P((char *));
char   *cf_outbound		P((void));
char   *cf_zones_inet_domain	P((int));
int	cf_zones_check		P((int));
char   *cf_zones_trav		P((int));
char   *cf_zones_out		P((int));
char   *cf_zones_ftn_domain	P((int));
Node   *cf_addr_trav		P((int));
int	cf_dos			P((void));
char   *cf_dos_xlate		P((char *));
void	cf_set_inbound		P((char *));
char   *cf_inbound		P((void));
Node    cf_gateway		P((void));
char   *cf_get_string		P((char *, int));

/* crc16.c */
void	crc16_init		P((void));
void	crc16_update		P((int));
void	crc16_update_ccitt	P((int));
unsigned int crc16_value	P((void));
unsigned int crc16_value_ccitt	P((void));

/* crc32.c */
unsigned long compute_crc32	P((unsigned char *, int));
void	crc32_init		P((void));
void	crc32_compute		P((unsigned char *, int));
void	crc32_update		P((int));
unsigned long crc32_value	P((void));

/* date.c */
char   *date			P((char *, time_t *));

/* dir.c */
#define DIR_SORTNAME	'n'
#define DIR_SORTNAMEI	'i'
#define DIR_SORTSIZE	's'
#define DIR_SORTMTIME	'm'
#define DIR_SORTNONE	'-'

int	dir_open		P((char *, char *));
void	dir_close		P((void));
void	dir_sortmode		P((int));
char   *dir_get			P((int));

/* exit.c */
void	fidogate_exit		P((int));

/* fopen.c */
FILE   *xfopen			P((char *, char *));
FILE   *libfopen		P((char *, char *));
FILE   *spoolfopen		P((char *, char *));

/* getdate.y */
time_t	get_date		P((char *, void *));

/* gettime.c / parsedate.y */
extern time_t	parsedate	P((char *, TIMEINFO *));
extern int	GetTimeInfo	P((TIMEINFO *));

/* hosts.c */
void	hosts_init		P((void));
Host   *hosts_lookup		P((Node *, char *));

/* kludge.c */
char   *kludge_get		P((Textlist *, char *, Textline **));
void    kludge_pt_intl		P((MsgBody *, Message *));

/* lock.c */
int	lock_fd			P((int));
int	unlock_fd		P((int));
int	lock_file		P((FILE *));
int	unlock_file		P((FILE *));
int	lock_lockfile		P((char *, int));
int	unlock_lockfile		P((char *));
int	lock_program		P((char *, int));
int	unlock_program		P((char *));

/* log.c */
extern int verbose;

char   *strerror		P((int));
void	log			P((const char *, ...));
void	debug			P((int, const char *, ...));
void	log_file		P((char *));
void	log_program		P((char *));
void	logx			P((char *, char *, char *, ...));

/* mail.c */
extern char mail_dir[MAXPATH];

int	mail_open		P((void));
char   *mail_name		P((void));
FILE   *mail_file		P((void));
int	mail_kill		P((void));
int	mail_close		P((void));

/* maus.c */
void	maus_init		P((void));
Maus   *maus_default		P((void));
Maus   *maus_lookup		P((char *));

/* message.c */
int	pkt_get_line		P((FILE *, char *, int));
int	pkt_get_body		P((FILE *, Textlist *));
void	msg_body_init		P((MsgBody *));
void	msg_body_clear		P((MsgBody *));
int	msg_body_parse		P((Textlist *, MsgBody *));
void	msg_body_debug		P((FILE *, MsgBody *));
int	msg_put_msgbody		P((FILE *, MsgBody *, int));
int	msg_put_line		P((FILE *, char *));
char   *msg_xlate_line		P((char *, int, char *));
int	msg_format_buffer	P((char *, Textlist *));

/* mime.c */
#define MIME_QP 1		/* quoted printable */
#define MIME_US 2		/* underscore `_' */

char   *mime_dequote		P((char *, size_t, char *, int));

/* misc.c */
char   *str_copy		P((char *, size_t, char *));
char   *str_append		P((char *, size_t, char *));
char   *str_copy2		P((char *, size_t, char *, char *));
char   *str_copy3		P((char *, size_t, char *, char *, char *));
char   *str_copy4		P((char *, size_t, char *, char *, char *,
				   char *));
char   *str_copy5		P((char *, size_t, char *, char *, char *,
				   char *, char *));

#define BUF_COPY(d,s)			str_copy  (d,sizeof(d),s)
#define BUF_APPEND(d,s)			str_append(d,sizeof(d),s)
#define BUF_COPY2(d,s1,s2)		str_copy2 (d,sizeof(d),s1,s2)
#define BUF_COPY3(d,s1,s2,s3)		str_copy3 (d,sizeof(d),s1,s2,s3)
#define BUF_COPY4(d,s1,s2,s3,s4)	str_copy4 (d,sizeof(d),s1,s2,s3,s4)
#define BUF_COPY5(d,s1,s2,s3,s4,s5)	str_copy5 (d,sizeof(d),s1,s2,s3,s4,s5)

char   *strncpy0		P((char *, char *, int));
char   *strncat0		P((char *, char *, int));
#ifdef DO_HAVE_STRCASECMP
# define stricmp  strcasecmp
# define strnicmp strncasecmp
#endif
#if !defined(DO_HAVE_STRCASECMP) && !defined(DO_HAVE_STRICMP)
int	strnicmp		P((char *, char *, int));
int	stricmp			P((char *, char *));
#endif
long	xtol			P((char *));
void	strip_crlf		P((char *));
void	strip_space		P((char *));
int	is_space		P((int));
int	is_blank		P((int));
char   *str_expand_name		P((char *, size_t, char *));

/* msgid.c */
char   *msgid_fido_to_rfc	P((char *));
char   *msgid_default		P((Node *, char *, char *, char *, time_t));
char   *msgid_rfc_to_fido	P((int *, char *, int, int, char *));
char   *msgid_rfc_to_origid	P((char *, int, int));
char   *msgid_convert_origid	P((char *, int));

/* node.c */
int	pfnz_to_node	        P((char *, Node *, int));
int	asc_to_node	        P((char *, Node *, int));
char   *node_to_asc	        P((Node *, int));
char   *node_to_pfnz	        P((Node *, int));
int	node_eq			P((Node *, Node *));
void	node_clear		P((Node *));
void	node_invalid		P((Node *));
int	asc_to_node_partial	P((char *, Node *));
int	asc_to_node_diff	P((char *, Node *, Node *));
char   *node_to_asc_diff	P((Node *, Node *));
int	node_cmp		P((Node *, Node *));

void	lon_init		P((LON *));
void	lon_delete		P((LON *));
void	lon_add			P((LON *, Node *));
int	lon_remove		P((LON *, Node *));
int	lon_search		P((LON *, Node *));
int	lon_add_string		P((LON *, char *));
int	lon_print		P((LON *, FILE *, int));
void	lon_sort		P((LON *, int));
int	lon_print_sorted	P((LON *, FILE *, int));
void	lon_debug		P((int, char *, LON *, int));

/* outpkt.c */
void	outpkt_set_maxopen	P((int));
FILE   *outpkt_open		P((Node *, int, int, int));
int	outpkt_close		P((void));

/* packet.c */
void	pkt_outdir		P((char *, char *));
char   *pkt_get_outdir		P((void));
FILE   *pkt_open		P((char *, Node *, char *, int));
int	pkt_close		P(());
char   *pkt_name		P((void));
char   *pkt_tmpname		P((void));
int	pkt_isopen		P((void));

int	pkt_get_string		P((FILE *, char *, int));
time_t	pkt_get_date		P((FILE *));
int	pkt_get_msg_hdr		P((FILE *, Message *));
void	pkt_debug_msg_hdr	P((FILE *, Message *, char *));
int	pkt_put_string		P((FILE *, char *));
int	pkt_put_line		P((FILE *, char *));
int	pkt_put_int16		P((FILE *, int));
int	pkt_put_date		P((FILE *, time_t));
int	pkt_put_msg_hdr		P((FILE *, Message *, int));
long	pkt_get_int16		P((FILE *));
int	pkt_get_nbytes		P((FILE *, char *, int));
int 	pkt_get_hdr		P((FILE *, Packet *));
void	pkt_debug_hdr		P((FILE *, Packet *, char *));
int	pkt_put_string_padded	P((FILE *, char *, int));
int	pkt_put_hdr		P((FILE *, Packet *));

/* passwd.c */
void	passwd_init		P((void));
Passwd *passwd_lookup		P((char *, Node *));

/* read.c */
char *read_line			P((char *, int, FILE *));
long  read_rnews_size		P((FILE *));

/* rfcaddr.c */
void	rfcaddr_dot_names	P((int));
RFCAddr	rfcaddr_from_ftn	P((char *, Node *));
RFCAddr	rfcaddr_from_rfc	P((char *));
char   *rfcaddr_to_asc		P((RFCAddr *, int));

/* rfcheader.c */
void	header_delete		P((void));
void	header_read		P((FILE *));
int	header_hops		P((void));
char   *rfcheader_get		P((Textlist *, char *));
char   *header_get		P((char *));
char   *header_getnext		P((void));
char   *header_getcomplete	P((char *));
char   *name_from_rfcaddr	P((char *, char *));
char   *addr_from_rfcaddr	P((char *, char *));
char   *username_from_rfcaddr	P((char *, char *));
char   *addr_token		P((char *));

/* routing.c */
extern Routing *routing_first;
extern Routing *routing_last;
extern Remap   *remap_first;
extern Remap   *remap_last;
extern Rewrite *rewrite_first;
extern Rewrite *rewrite_last;

int	get_rnumber		P((char **));
int	asc_to_rnode_partial	P((char *, Node *));
int	asc_to_rnode_diff	P((char *, Node *, Node *));
int	parse_cmd		P((char *));
int	parse_flav		P((char *));
void	routing_init		P((char *));
int	node_match		P((Node *, Node *));
PktDesc*parse_pkt_name		P((char *, Node *));

/* sequencer.c */
long	sequencer		P((char *));
long	sequencer_nx		P((char *));

/* textlist.c */
int	tl_fput			P((FILE *, Textlist *));
void	tl_add			P((Textlist *, Textline *));
void	tl_remove		P((Textlist *, Textline *));
void	tl_delete		P((Textlist *, Textline *));
void	tl_init			P((Textlist *));
void	tl_append		P((Textlist *, char *));
void	tl_appendf		P((Textlist *, char *, ...));
void	tl_print		P((Textlist *, FILE *));
void	tl_clear		P((Textlist *));
long	tl_size			P((Textlist *));
void	tl_addtl		P((Textlist *, Textlist *));

/* tick.c */

/* version.c */
char   *version_global		P((void));
char   *version_local		P((char *));
int	version_major		P((void));
int	version_minor		P((void));

/* wildmat */
int	wildmat			P((char *, char *));
int	wildmatch		P((char *, char *, int));

/* xalloc.c */
#define BUFFERSIZE		(16*1024)	/* Global buffer */
extern char buffer[BUFFERSIZE];

void   *xmalloc			P((int));
void   *xrealloc		P((void *, int));
void	xfree			P((void *));
char   *strsave			P((char *));

/* xstrtok.c --- module by Wolfram Roesler */
char   *xstrtok			P((char *,char *));
char   *strsaveline		P((char *));
