/*:ts=8*/
/*****************************************************************************
 * FIDOGATE --- Gateway UNIX Mail/News <-> FIDO NetMail/EchoMail
 *
 * $Id: ftnlock.c,v 3.9.2.0 1995/06/12 17:14:03 mj Exp $
 *
 * Command line interface to lock files in SPOOLDIR/locks
 *
 *****************************************************************************
 * Copyright (C) 1990-1995
 *  _____ _____
 * |     |___  |   Martin Junius             FIDO:      2:2452/110.1
 * | | | |   | |   Republikplatz 3           Internet:  mj@sungate.fido.de
 * |_|_|_|@home|   D-52072 Aachen, Germany   Phone:     ++49-241-86931 (voice)
 *
 * This file is part of FIDOGATE.
 *
 * FIDOGATE is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FIDOGATE is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with FIDOGATE; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

#include "fidogate.h"
#include "getopt.h"



#define PROGRAM "ftnlock"
#define VERSION "$Revision: 3.9.2.0 $"

#define MY_CONFIG "%L/config.toss"



/*
 * Usage messages
 */
void short_usage()
{
    fprintf(stderr, "usage: %s [-options] [name]\n", PROGRAM);
    fprintf(stderr, "       %s --help  for more information\n", PROGRAM);
}


void usage()
{
    fprintf(stderr, "FIDOGATE %s  %s %s\n\n",
	    version_global(), PROGRAM, version_local(VERSION) );
    
    fprintf(stderr, "usage:   %s [-options] [name]\n\n", PROGRAM);
    fprintf(stderr, "\
options: -l --lock                    create lock file\n\
         -u --unlock                  remove lock file\n\
\n\
	 -v --verbose                 more verbose\n\
	 -h --help                    this help\n\
         -c --config NAME             read config file (\"\" = none)\n\
	 -L --lib-dir NAME            set lib directory\n\
	 -S --spool-dir NAME          set spool directory\n"           );
}



/***** main() ****************************************************************/

int main(argc, argv)
    int argc;
    char *argv[];
{
    int c, ret;
    int l_flag=TRUE, u_flag=FALSE;
    char *c_flag=NULL, *S_flag=NULL, *L_flag=NULL;
    char *name;
    
    int option_index;
    static struct option long_options[] =
    {
	{ "lock",         0, 0, 'l'},	/* Create lock file*/
	{ "unlock",       0, 0, 'u'},	/* Remove lock file*/

	{ "verbose",      0, 0, 'v'},	/* More verbose */
	{ "help",         0, 0, 'h'},	/* Help */
	{ "config",       1, 0, 'c'},	/* Config file */
	{ "spool-dir",    1, 0, 'S'},	/* Set FIDOGATE spool directory */
	{ "lib-dir",      1, 0, 'L'},	/* Set FIDOGATE lib directory */
	{ 0,              0, 0, 0  }
    };

    log_program(PROGRAM);
    log_file("stderr");
    
    /* Init configuration */
    cf_initialize();


    while ((c = getopt_long(argc, argv, "luvhc:S:L:",
			    long_options, &option_index     )) != EOF)
	switch (c) {
	/***** ftnpack options *****/
        case 'l':
            l_flag = TRUE;
            u_flag = FALSE;
            break;
        case 'u':
            l_flag = FALSE;
            u_flag = TRUE;
            break;
	    
	/***** Common options *****/
	case 'v':
	    verbose++;
	    break;
	case 'h':
	    usage();
	    exit(0);
	    break;
	case 'c':
	    c_flag = optarg;
	    break;
	case 'S':
	    S_flag = optarg;
	    break;
	case 'L':
	    L_flag = optarg;
	    break;
	default:
	    short_usage();
	    exit(EX_USAGE);
	    break;
	}

    /*
     * Read config file
     */
    if(L_flag)				/* Must set libdir beforehand */
	cf_set_libdir(L_flag);
    cf_read_config_file(c_flag ? c_flag : MY_CONFIG);

    /*
     * Process config options
     */
    if(L_flag)
	cf_set_libdir(L_flag);
    if(S_flag)
	cf_set_spooldir(S_flag);

    cf_debug();


    ret = EXIT_OK;

    name = optind>=argc ? PROGRAM : argv[optind];
    
    /* Lock file */
    if(l_flag)
	if(lock_program(name, FALSE) == ERROR)
	    /* Already busy */
	    ret = EXIT_BUSY;
	
    /* Unlock file */
    if(u_flag)
	if(unlock_program(name) == ERROR)
	    /* Error */
	    ret = EXIT_ERROR;
    
    exit(ret);

    /**NOT REACHED**/
    return 1;
}
