/*:ts=8*/
/*****************************************************************************
 * FIDOGATE --- Gateway software UNIX <-> FIDO
 *
 * $Id: config.h,v 3.9.2.0 1995/06/12 17:11:12 mj Exp $
 *
 * Configuration header file
 *
 *****************************************************************************
 * Copyright (C) 1990-1995
 *  _____ _____
 * |     |___  |   Martin Junius             FIDO:      2:2452/110.1
 * | | | |   | |   Republikplatz 3           Internet:  mj@sungate.fido.de
 * |_|_|_|@home|   D-52072 Aachen, Germany   Phone:     ++49-241-86931 (voice)
 *
 * This file is part of FIDOGATE.
 *
 * FIDOGATE is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * FIDOGATE is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with FIDOGATE; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *****************************************************************************/

/***** General configuration *************************************************/

/** Postmaster name **/
#define POSTMASTER	"postmaster"

/*
 * Enable conversion of the addresses generated by the MAUS <-> FIDO
 * gateway to their Internet form, e.g.
 *     `User Name % MAUS AC'  -->  `user_name@ac.maus.de'
 * and vice versa.
 *
 * This requires the MAUS config file in LIBDIR.
 */
#define MAUS_DE

#ifdef MAUS_DE
# define MAUS_DE_FROM			/* MAUS handling in ftn2rfc */
# define MAUS_DE_TO			/* MAUS handling in rfc2ftn */
# define MAUS_STRING	"_%_MAUS_"	/* For addressing gateway */
#endif

/*
 * Only allow mail from/to nodes registered in HOSTS
 */
#define HOSTS_RESTRICTED

/*
 * Generate local FTN addresses, e.g.
 *     user_name%p.f.n.z@host.domain
 * instead of
 *     user_name@p.f.n.z.domain
 */
/* #define LOCAL_FTN_ADDRESSES */

/*
 * Create Binkley-style BSY files for all outbound operations
 */
#define DO_BSY_FILES

/*
 * Secure permissions
 */
/* #define SECURE */

/*
 * Max. message size for FIDO. Due to some more brain damage in FIDONET
 * programs we have to split larger messages into several smaller ones.
 */
/* < 16 K */
#define MAXMSGSIZE	14000
/* < 32 K */
/* #define MAXMSGSIZE	30000 */



/***** ftn2rfc configuration ************************************************/

/** Junk newsgroup for areas with unknown area<->newsgroup conversion **/
#define FTN_JUNK	"fido.junk"

/** Errors-To: return address for bounced mail **/
/* #define ERRORS_TO	    "postmaster@sungate.fido.de" */

/** Add `@host.domain' to local addresses **/
#define ADD_DOMAIN

/*
 * Rewrite addresses found in ALIASES so that the sender's address is the
 * gateway address. The reverse direction requires suitable MTA aliases.
 */
/* #define ALIASES_ARE_LOCAL */

/*
 * Make the IBMPC char set the default (no ^ACHRS kludge)
 */
#define CHARSET_DEFAULT_IBMPC



/***** rfc2ftn configuration ************************************************/

/** Passthru operation for NetMail: FIDO->Internet->FIDO **/
#define PASSTHRU_NETMAIL
/** Passthru operation for EchoMail: FIDO->Internet->FIDO **/
#define PASSTHRU_ECHOMAIL /* Not yet implemented */

/*
 * Type of 4D EchoMail control lines.
 *
 * With this enabled FIDOGATE generates SEEN-BY and ^APATH like:
 *     SEEN-BY: 242/6.1
 *     ^APATH: 242/6.1
 * Else (undef'ed) only the boss node's address is used:
 *     SEEN-BY: 242/6
 *     ^APATH: 242/6
 * There seems to be no standard for 4D EchoMail addressing. If you run
 * into problems with this kind of EchoMail message, please change the
 * code in rfc2ftn.c:print_origin().
 */
/* #define FTN_4D_ECHOMAIL_WITH_POINTS */

/*
 * Enable support for FSC-0035 ^AREPLYADDR and ^AREPLYTO
 */
#define FSC_0035

/*
 * Enable support for FSC-0047 ^ASPLIT
 */
#define FSC_0047

/*
 * Always generate a ^AINTL kludge for NetMails. (undef: only for mails
 * to other zones)
 */
#define FTN_FORCE_INTL

/*
 * Don't pass news control messages to FTN
 */
#define NO_CONTROL



/***** ftn2ftn configuration ************************************************/

/*
 * None yet.
 */

/***** System dependend configuration ***************************************
 *
 *   DO_HAVE_GETTIMEOFDAY	Do you have gettimeofday()?
 *
 *   DO_HAVE_TM_GMTOFF		Does your (struct tm) have a tm_gmtoff field?
 *
 *
 * Define only one of DO_HAVE_TM_ZONE, DO_HAVE_STRFTIME, DO_HAVE_TZNAME!!!
 *
 *   DO_HAVE_TM_ZONE		Does your (struct tm) have a tm_zone field?
 *
 *   DO_HAVE_STRFTIME		Do you have strftime()?
 *
 *   DO_HAVE_TZNAME		Do you have extern char *tzname[2]?
 *
 *
 * Define only one of DO_HAVE_STRCASECMP, DO_HAVE_STRICMP!!!
 *
 *   DO_HAVE_STRCASECMP		Do you have strcasecmp(), strncasecmp()?
 *
 *   DO_HAVE_STRICMP		Do you have stricmp(), strnicmp()?
 *
 *
 *   DO_BINARY			Open files in binary mode
 */

#ifdef __sun__				/* SUNOS 4.1.x, GNU gcc */
# define DO_HAVE_GETTIMEOFDAY
# define DO_HAVE_TM_GMTOFF
# undef  DO_HAVE_TM_ZONE
# define DO_HAVE_STRFTIME
# undef  DO_HAVE_TZNAME
# define DO_HAVE_STRCASECMP
# undef  DO_HAVE_STRICMP
# undef  DO_BINARY
#endif

#ifdef __linux__			/* LINUX 1.x, GNU gcc */
# define DO_HAVE_GETTIMEOFDAY
# undef  DO_HAVE_TM_GMTOFF
# undef  DO_HAVE_TM_ZONE
# define DO_HAVE_STRFTIME
# undef  DO_HAVE_TZNAME
# define DO_HAVE_STRCASECMP
# undef  DO_HAVE_STRICMP
# undef  DO_BINARY
#endif

#ifdef ISC				/* ISC 3.x, GNU gcc, -DISC necessary */
# define DO_HAVE_GETTIMEOFDAY
# undef  DO_HAVE_TM_GMTOFF
# undef  DO_HAVE_TM_ZONE
# undef  DO_HAVE_STRFTIME
# define DO_HAVE_TZNAME
# undef  DO_HAVE_STRCASECMP		/* ? */
# undef  DO_HAVE_STRICMP
# undef  DO_BINARY
#endif

#ifdef MSDOS				/* MSDOS, DJGPP GCC */
# define DO_HAVE_TM_GMTOFF
# undef  DO_HAVE_TM_ZONE
# define DO_HAVE_GETTIMEOFDAY
# define DO_HAVE_STRFTIME
# undef  DO_HAVE_STRCASECMP
# define DO_HAVE_STRICMP
# define DO_BINARY
#endif

#ifdef __EMX__				/* OS/2 EMX GCC */
# ifndef OS2
#  define OS2
# endif
#endif

#ifdef OS2				/* OS/2, EMX GNU gcc */
# define DO_HAVE_GETTIMEOFDAY
# define DO_HAVE_STRFTIME
# undef  DO_HAVE_STRCASECMP
# define DO_HAVE_STRICMP
# define DO_BINARY
#endif


#ifdef DO_HAVE_TM_GMTOFF
# undef  DONT_HAVE_TM_GMTOFF
#else
# define DONT_HAVE_TM_GMTOFF
#endif


/***** End of configuration *************************************************/



/***** ^AMSGID/Message-ID configuration *************************************/
/*
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 * !!! DON'T TOUCH THIS, IF YOU'RE NOT ABSOLUTELY SURE WHAT YOU'RE DOING !!!
 * !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 */

/*
 * Standard FIDO domain
 */
#define FIDODOMAIN	".fidonet.org"

/*
 * Create Gatebau '93 ^AORIGID and ^AORIGREF:
 *     ^AORIGID: <id@do.main> [i/n]
 *     ^AORIGREF: <id@do.main>
 */
#define MSGID_ORIGID

/*
 * Create new FIDO-Gatebau '94 ^AMSGID:
 *     ^AMSGID: <id@do.main> abcd1234
 * Old (undef'ed):
 *     ^AMSGID: do.main abcd1234
 */
#define MSGID_NEW_MSGID

/*
 * Create new FIDO-Gatebau '94 Message-IDs for FTN ^AMSGIDs:
 *     Message-ID: <MSGID_mimeanything_abcd1234@ftn.domain>
 *     Message-ID: <NOMSGID_mimeftnaddr_YYMMDD_HHMMSS_abcd1234@ftn.domain>
 * Old (undef'ed):
 *     Message-ID: <abcd1234%domain@p.f.n.z.fidonet.org>
 *     Message-ID: <NOMSGID-YYMMDD-HHMMSS-abcd1234@p.f.n.z.fidonet.org>
 */
#define MSGID_NEW_FTNID



/****************************************************************************
 *                                                                          *
 *              Think twice before changing anything below!!!               *
 *                                                                          *
 ****************************************************************************/

/*
 * Files in LIBDIR
 */
#define CONFIG		"config"	/* Main FIDOGATE config file */
#define HOSTS		"hosts"		/* Host file (Fido.DE) */
#define ALIASES		"aliases"	/* User aliases file */
#define AREAS		"areas"		/* Areas <-> Newsgroups */
#define MAUS		"maus"		/* MAUSNET domain list */
#define PASSWD		"passwd"	/* Password file */

#define LOG		"log"		/* Default log file */

#define SEQ_MAIL	"seq.mail"	/* ftn2rfc: mail files */
#define SEQ_NEWS	"seq.news"	/* ftn2rfc: news files */
#define SEQ_MSGID	"seq.msgid"	/* local ^AMSGID */
#define SEQ_PKT		"seq.pkt"	/* rfc2ftn: outgoing packets */
#define SEQ_SPLIT	"seq.split"	/* rfc2ftn: msg # of split msgs */
#define SEQ_FF		"seq.ff"	/* ffx: control/data files */
#define SEQ_TOSS	"seq.toss"	/* ftntoss/ftnroute: output packets */
#define SEQ_PACK	"seq.pack"	/* ftnpack: archived .pkts */
#define SEQ_MQ		"seq.mq"	/* queuemail: messages */
#define SEQ_TICK	"seq.tick"	/* ftnhatch/ftntick: .tic file ids */

/*
 * Directories in SPOOLDIR
 */
#define INDIR		"in"		/* ftn2rfc: input .pkt's */
#define INSECUREDIR	"insecure"	/* ftn2rfc: insecure input */
#define INDIR_MAIL	"mail"		/* ftn2rfc: mail output, rel. INDIR */
#define INDIR_NEWS	"news"		/* ftn2rfc: news output, rel. INDIR */
#define OUTDIR		"out"		/* rfc2ftn: output .pkt's */

#define SEQ		"seq"		/* Dir for sequencer files */
#define LOCKS		"locks"		/* Dir for lock files */
#define TOSS		"toss"		/* Dir for ftntoss/ftnroute/ftnpack */
#define TOSS_IN		"toss/in"	/* ftntoss in */
#define TOSS_TMP	"toss/tmp"	/* ftntoss out, ftnroute in */
#define TOSS_OUT	"toss/out"	/* ftnroute out, ftnpack in */
#define TOSS_PACK	"toss/pack"	/* ftnpack .pkts */
#define QUEUE		"queue"		/* queuemail: queued messages */

/*
 * Permissions
 */
#ifdef SECURE		/* Secure permissions */
# define PACKET_MODE	0600		/* Mode for outbound packets */
# define BSY_MODE	0644		/* Mode for BSY files */
# define FLO_MODE	0644		/* Mode for FLO files */
# define DATA_MODE	0600		/* Mode for ffx data files */
# define DIR_MODE	0755		/* Mode for directories */
# define CONF_MODE	0644		/* Mode for written config files */
#else			/* Open permissions */
# define PACKET_MODE	0666		/* Mode for outbound packets */
# define BSY_MODE	0666		/* Mode for BSY files */
# define FLO_MODE	0666		/* Mode for FLO files */
# define DATA_MODE	0666		/* Mode for ffx data files */
# define DIR_MODE	0777		/* Mode for directories */
# define CONF_MODE	0666		/* Mode for written config files */
#endif

/*
 * RFC headers recognized at beginning of FTN message body
 */
#define FTN_RFC_HEADERS \
	"From:",        \
	"Reply-To:",    \
	"UUCPFROM:",    \
	"To:",          \
	"Cc:"           \
	"Bcc:"

/*
 * Open modes for fopen(), binary for system requiring this.
 */
#ifdef DO_BINARY
# define R_MODE		"rb"
# define W_MODE		"wb"
# define A_MODE		"ab"
# define RP_MODE	"r+b"
# define WP_MODE	"w+b"
# define AP_MODE	"a+b"
#else
# define R_MODE		"r"
# define W_MODE		"w"
# define A_MODE		"a"
# define RP_MODE	"r+"
# define WP_MODE	"w+"
# define AP_MODE	"a+"
#endif /**DO_BINARY**/

/*
 * Format strings for RFC dates
 */
#define DATE_DEFAULT	"%a, %d %b %Y %H:%M:%S %O"
#define DATE_NEWS	"%a, %d %b %Y %H:%M:%S %O"
#define DATE_MAIL	"%a, %d %b %Y %H:%M:%S %O (%Z)"

/*
 * Product code for packets generated by FIDOGATE, 0xfe is used because
 * this code is reserved for new products, when the code numbers ran out.
 */
#define PRODUCT_CODE	0xfe

/*
 * Line width for formatted messages.
 */
#define MAX_LINELEN	80

/*
 * Program limits
 */
#define MAXADDRESS	32		/* Max. # of FTN address in CONFIG */

#define MAXDOSDRIVE	16		/* Max. # of DOS drives in CONFIG */

#ifndef MSDOS				/* Already defined by DJGPP */
# define MAXPATH	128		/* Max. size of path names */
#endif

#define MAXINETADDR	128		/* Max. size of an Internet address */

#define MAXUSERNAME	128		/* Max. size of an user name */

#define MAXOPENFILES	10		/* Max. # of open packet files used
					 * by ftntoss/ftnroute, this value
					 * should work on all supported
					 * systems, it can be incremented with
					 * ftntoss/ftnroute's -M option */
