/*
 * This file is part of the FEddi package
 *
 * Personal use allowed under the terms of the
 *
 *              GNU GENERAL PUBLIC LICENSE Version 2
 *              (see LICENSE for the complete text)
 *
 *-------------------------------------------------------------------
 *
 *    ENTER AT YOUR OWN RISK !!
 *
 * This source is without any documentation and can drive you mad.
 * In case of sudden epileptic seizures please call your doctor.
 *
 */

#include <ncurses.h>
#include <string.h>
#include "proc.h"

#define MAXCOLORS 31

typedef struct
{
	int FG;
	int BG;
	int AB;
	int BW;
} ColorType;

const char ColorName[MAXCOLORS][20]=
{
	"NormalText",
	"QuoteText",
	"Header",
	"HeaderText",
	"ReceivedDT",
	"MarkedFlag",
	"PrivateFlag",
	"ProtectedFlag",
	"StatusLine",
	"StatusLineHigh",
	"Menu",
	"MenuHigh",
	"MenuKey",
	"MenuKeyHigh",
	"Link",
	"Warning",
	"InputText",
	"FoundText",
	"LocalMessage",
	"PrivateMsgList",
	"PrivateMsgListHigh",
	"ImportArea",
	"ImportAreaHigh",
	"NormalTextHigh",
	"QuoteTextHigh",
	"WarningBox",
	"HelpBox",
	"FirstQuoteText",
	"CutOriginText",
	"FirstQuoteTextHigh",
	"CutOriginTextHigh"
};

const char validColor[8][8]=
{
	"BLACK",
	"RED",
	"GREEN",
	"YELLOW",
	"BLUE",
	"MAGENTA",
	"CYAN",
	"WHITE"
};

const char validAttribute[7][10]=
{
	"NORMAL",
	"STANDOUT",
	"UNDERLINE",
	"REVERSE",
	"BLINK",
	"DIM",
	"BOLD"
};

ColorType FEddiColor[MAXCOLORS]=
{
	{COLOR_WHITE,		COLOR_BLACK,		0,			0},
	{COLOR_GREEN,		COLOR_BLACK,		0,			A_BOLD},
	{COLOR_CYAN,		COLOR_BLACK,		0,			0},
	{COLOR_WHITE,		COLOR_BLACK,		0,			A_BOLD},
	{COLOR_YELLOW,	COLOR_BLACK,		A_BOLD,	0},
	{COLOR_CYAN,		COLOR_BLACK,		A_BOLD,	0},
	{COLOR_YELLOW,	COLOR_BLACK,		A_BOLD,	A_BOLD},
	{COLOR_RED,			COLOR_BLACK,		A_BOLD,	0},
	{COLOR_WHITE,		COLOR_BLUE,			0,			A_REVERSE},
	{COLOR_CYAN,		COLOR_BLUE,			0,			A_REVERSE|A_BOLD},
	{COLOR_BLUE,		COLOR_CYAN,			0,			0},
	{COLOR_CYAN,		COLOR_BLUE,			0,			A_REVERSE},
	{COLOR_BLACK,		COLOR_CYAN,			0,			A_BOLD},
	{COLOR_WHITE,		COLOR_BLUE,			A_BOLD,	A_REVERSE|A_BOLD},
	{COLOR_YELLOW,	COLOR_BLACK,		A_BOLD,	A_BOLD},
	{COLOR_YELLOW,	COLOR_BLACK,		0,			A_BOLD},
	{COLOR_GREEN,		COLOR_BLACK,		0,			0},
	{COLOR_BLACK,		COLOR_RED,			0,			A_REVERSE},
	{COLOR_YELLOW,	COLOR_BLACK,		0,			0},
	{COLOR_YELLOW,	COLOR_CYAN,			A_BOLD,	A_BOLD},
	{COLOR_YELLOW,	COLOR_BLUE,			A_BOLD,	A_REVERSE|A_BOLD},
	{COLOR_BLACK,		COLOR_CYAN,			0,			A_BOLD},
	{COLOR_BLACK,		COLOR_BLUE,			0,			A_REVERSE|A_BOLD},
	{COLOR_WHITE,		COLOR_MAGENTA,	0,			A_REVERSE},
	{COLOR_GREEN,		COLOR_MAGENTA,	0,			A_REVERSE|A_BOLD},
	{COLOR_RED,			COLOR_BLUE,			A_BOLD,	A_REVERSE},
	{COLOR_BLUE,		COLOR_WHITE,		0,			A_BOLD},
	{COLOR_GREEN,		COLOR_BLACK,		A_BOLD,	A_REVERSE},
	{COLOR_BLUE,		COLOR_BLACK,		A_BOLD,	0},
	{COLOR_GREEN,		COLOR_MAGENTA,	A_BOLD,	A_REVERSE|A_BOLD},
	{COLOR_BLUE,		COLOR_MAGENTA,	A_BOLD,	A_REVERSE},
};

int strtocolor(char *s)
{
	int i;
	for (i=0; i<8; i++)
		if (strncasecmp(s,validColor[i],strlen(validColor[i]))==0)
			return i;
	return -1;
}

void setFEddiColor(char *s)
{
	int i;
	char *d1,*d2,*d3;
	d1=strchr(s,32);
	if (d1) *d1++=0;
	for (i=0; i<MAXCOLORS; i++)
		if (strcasecmp(s,ColorName[i])==0)
		{
			FEddiColor[i].BG=0;
			FEddiColor[i].FG=1;
			FEddiColor[i].AB=0;
			if (d1)
			{
				while (*d1==32) d1++;
				d2=strstr(d1,"on");
				if (d2==NULL) d2=strchr(d1,',');
				if (d2)
				{
					*d2++=0;
					d3=strchr(d2,32);
					if (d3)
					{
						while (*d3==32) d3++;
						FEddiColor[i].BG=strtocolor(d3);
						if (FEddiColor[i].BG==-1)
							FEddiColor[i].BG=0;
					}
				}
				FEddiColor[i].FG=strtocolor(d1);
				if (FEddiColor[i].FG==-1)
					FEddiColor[i].FG=1;
				if (strchr(d1,'+')!=NULL)
					FEddiColor[i].AB=A_BOLD;
				if (strchr(d1,'!')!=NULL)
					FEddiColor[i].AB|=A_BLINK;
			}
			return;
		}
}

int strtoattribute(char *s)
{
	int i;
	for (i=0; i<7; i++)
		if (strncasecmp(s,validAttribute[i],strlen(validAttribute[i]))==0)
			return (1<<(i+16));
	return 0;
}

void setFEddiColorBW(char *s)
{
	int i;
	char *d1,*d2;
	d1=strchr(s,32);
	if (d1) *d1++=0;
	for (i=0; i<MAXCOLORS; i++)
		if (strcasecmp(s,ColorName[i])==0)
		{
			FEddiColor[i].BW=0;
			if (d1)
			{
				while (*d1==32) d1++;
				for (; d1; d1=d2)
				{
					if ((d2=strchr(d1,','))) *d2=0;
					FEddiColor[i].BW|=strtoattribute(d1);
				}
			}
			return;
		}
}

void initFEddiColors()
{
	int i;
	init_pair(0,COLOR_WHITE,COLOR_BLACK);
	for (i=0; i<MAXCOLORS; i++)
		init_pair(i+1,FEddiColor[i].FG,FEddiColor[i].BG);
}

void wcolon(WINDOW *win,int col)
{
	if (COLON)
		wattrset(win,COLOR_PAIR((col+1))|FEddiColor[col].AB);
	else
		wattrset(win,FEddiColor[col].BW);
}

void wcoloff(WINDOW *win)
{
	wattrset(win,0);
}

void spezExt(char *line)
{
	char *d1;
	if (strncasecmp(line,"color",5)==0)
	{
		d1=strchr(line,32);
		while (*d1==32) d1++;
		setFEddiColor(d1);
	}
	if (strncasecmp(line,"attribute",9)==0)
	{
		d1=strchr(line,32);
		while (*d1==32) d1++;
		setFEddiColorBW(d1);
	}
}
