//	$Id: parse822.g,v 3.2 1994/11/10 10:23:53 agl Exp agl $
//	AGL(C)	1994
//
#include <string.h>
#include <ctype.h>
#include "localize.h"
#include "a_mua.h"

#define	astrcmp(a,b)	strncmp(a,b,strlen(b))

inline	char	*astrstr(char	*&msg,	char	*substr, 
			size_t	&size,	uint	&newlines,
			uint	&actualsubstrsize, int casesens=0)
{	register int i=0;	actualsubstrsize=0; char cmpstr[64];
	if(casesens) strncpy(cmpstr,substr,64); else
	for(;substr[i]!='\0';++i) cmpstr[i]=tolower(substr[i]);
	for(i=0;size>0;) {
		if(*msg=='\n')	++newlines;
		if((casesens?*msg:tolower(*msg))==cmpstr[i]) { ++i;
suits_us:		++msg; ++actualsubstrsize; --size;
			if(substr[i]=='\0') { msg-=i; size+=i; return msg; }
		}else{	// The check for whitespace before ':' is necessary
			// to accept fields in form "Subject  : rfc822 A.3.3."
			if(substr[i]==':' && (*msg==' ' || *msg=='\t'))
				goto suits_us;
			++msg; actualsubstrsize=0; --size;
			if(i>0) { msg-=i; size+=i; i=0; }
		}
	}	return 0;
}
//	Side-effects free version of asstrstr
//
inline	char	*asstrstr(char	*msg,	char	*substr,
					size_t	size,	uint	&actualssize)
{	uint	_; astrstr(msg, substr, size, _, actualssize); }

Rfc822Msg::Rfc822Msg(char *&msg, size_t &size)	
{	
	if(astrcmp(msg,"From "))	a_fatal(grc.get(1,21),1009);
	header=msg;
	s_header = size; n_lines=0;
#define	FIXTWONEWLINES(sz) 	{	sz+=2; size-=2; msg+=2; n_lines+=2; }
	uint	dummy;
	if(astrstr(msg, "\n\n", size, n_lines, dummy)) {
		s_header -= size;	
		FIXTWONEWLINES(s_header)
	}else	a_fatal(grc.get(1,6),1010);
	// Now try to make use of Content-Length is presnt _and_ valid
#define	actual dummy
	body=msg;
	char *contlen;// The field is set to the body size without terminating\n
	if((contlen = asstrstr(header, "\nContent-Length:", s_header, actual)))
	{	contlen+=actual; ulong cont_len=astrtoul(contlen,0,10)+1;
		if(cont_len==size ||strncmp(msg+cont_len-2, "\n\nFrom ",7)==0) {
			fputc('.',stdout);fflush(stdout);
			if((contlen = asstrstr(header, "\nLines:", s_header, actual)))
			{	contlen+=actual; n_lines=astrtoul(contlen,0,10);}
			else n_lines=0;
			size-=cont_len;msg+=s_body=cont_len; goto parse_header;
		}
		else{	fputc('m',stdout);fflush(stdout);}
	}
	else	{	fputc('o',stdout);fflush(stdout);}
// ---------------------------- body till "\n\nFrom "
	s_body = size;
retry:	if(astrstr(msg, "From ", size, n_lines, dummy, 1))
	{	if(msg[-1]=='\n' && msg[-2]=='\n') s_body -= size;	
		else if(size>0) { size-=5; msg+=5; goto retry; }
//		FIXTWONEWLINES(s_body)
	}
parse_header:
//	fprintf(stderr,"Header %d Body %d bytes long\n", s_header, s_body);
	if((cc = asstrstr(header, "\nCc:", s_header, actual))) cc+=actual;
	if((reply_to = asstrstr(header,"\nReturn-Path:", s_header, actual))==0)
		reply_to = asstrstr(header,"\nReply-To:",s_header, actual); 
	if(reply_to) reply_to+=actual;
	if((from = asstrstr(header, "\nFrom:",s_header, actual))) {
	//	removing leading whitespace
		for(from+=actual;*from==' '||*from=='\t';++from);
	}
	if((to = asstrstr(header, "\nTo:",s_header, actual)))
		to+=actual;
	if((date = asstrstr(header, "\nDate:", s_header, actual)))
		date+=actual;
	if((subject = asstrstr(header, "\nSubject:", s_header, actual)))
		subject+=actual;
	if((message_id = asstrstr(header, "\nMessage-Id:", s_header, actual)))
		message_id+=actual;
	status=0;	char	*_;
// ---------------------------- checking for pgp armored messages
	if((_= asstrstr(body-1, "\n-----BEGIN PGP MESSAGE-----\n",
		s_body,	actual)))	status|=m_pgped;
	else
	if((_= asstrstr(body-1, "\n-----BEGIN PGP SIGNED MESSAGE-----\n",
		s_body,	actual)))	status|=m_clearsigned;
// ---------------------------- parsing Status: and setting read/old flags

	if((_status=asstrstr(header, "\nStatus:", s_header, dummy))) 
	{	_status+=actual;
		for(_=_status;;++_)
			switch(*_) {
				case '\n': if(status==0) 
						a_fatal(grc.get(1,15),1018);
					return;
				//	removing leading whitespace
				case ' ': ++_status; continue;
				case 'R': status|=m_read;
				case 'O': status|=m_old;	break;
				default: printf("'%c' char ",*_status);
					a_print(grc.get(1,8));
			}
	}	changed=1;
}
void	Rfc822Msg::get(char *i, char *_)
{
	if(i!=0) {	for(;*i==' '||*i=='\t';++i);
		for(;;) {
			if((*_++=*i++)=='\n'&&*i!=' '&&*i!='\t') break;
		}
	}
	*_='\0';
}

void	Rfc822Msg::headersummary(uint nmsg,char	*summary, uint	len)
{	sprintf(summary,"%4u",nmsg);
	if(nmsg==cur_msg) summary[0]='>';
	memset(summary+4,' ',len-4);	uint	actual;	char	*tmp;
	if(from!=0) {
		int	pos=9,	cnt=0;
	//	parsing	address(name) form
		for(actual=0,tmp=from;*tmp != '\n';++tmp,++cnt) {
			if(*tmp=='(') { if(tmp[1]==' ') goto fail;
						actual|=1;	continue; }
			if(*tmp==')')	goto	p_date;
			if(*tmp=='"')	if(actual & 2)	goto	p_date;
					else	{ actual|=2; continue; }
	//	to handle	name <address> form
			if(*tmp=='<')	{fail:	strncpy(summary+pos,from,cnt);
						goto	p_date;	
			}
			if(actual)	{	summary[pos++]=*tmp;
				if(pos>(len-2))	goto	p_date;
			}
		}
	//	give up otherwise
		for(tmp=from;pos<len-1;++pos) if(*tmp=='"') ++tmp; else
		if((summary[pos]=*tmp++)=='\n') { summary[pos]=' ';break; }
	}
p_date:	if(date!=0) {
		if((tmp = asstrstr(date, ",", s_header, actual))==0)
			tmp=date;
		for (;!isdigit(*tmp);++tmp) //just added ++tmp 
			if(*tmp=='\n')
nonrfcdate:		//	Not rfc822 compliant date: let them live...
				for(int pos=25;pos<len-1;++pos)
					if((summary[pos]=*tmp++)=='\n') 
					{ summary[pos]=' ';goto subj; }
		char	firstdigit=*tmp,
			seconddigit,month1,month2,month3;
		if(!isdigit(*++tmp)) { seconddigit=firstdigit;
			firstdigit=' ';	}	
		else	seconddigit=*tmp;
		for (;!isalpha(*tmp);++tmp) 
			if(*tmp=='\n') goto nonrfcdate;
		month1=*tmp++; month2=*tmp++; month3=*tmp;
#define	DATEPOS	33
		summary[DATEPOS-1]=' ';
		summary[DATEPOS  ]=month1;
		summary[DATEPOS+1]=month2;
		summary[DATEPOS+2]=month3;
		summary[DATEPOS+4]=firstdigit;
		summary[DATEPOS+5]=seconddigit;
	}
subj:	sprintf(summary+DATEPOS+7,"%3d ",n_lines);
	int _=DATEPOS+8; for(;summary[_]!='\0';++_);
	if(subject!=0) {
		tmp=subject; summary[len-2]='-';
		for(;_<len-1;++_)
			if((summary[_]=*tmp++)=='\n')	
			{
				summary[_]='\0'; goto skipnl; 
			}
	}
	summary[len-1]='\0';
skipnl:
	if(!(status&m_read))	if(!(status&m_old))	summary[6]='N';
				else			summary[6]='U';
	if(status&m_deleted)	summary[6]='D';
	if(status&m_clearsigned)summary[5]='c';
	if(status&m_pgped)	summary[5]='i';
	if(status&m_checked)
		if(status&m_authen)	summary[7]='A';
		else			summary[7]='F';
}
#include <unistd.h>
static	inline
char	*atmpnam(char *_) { // a bug in linux lib makes us to use it
	static	char	internal[64];
	if(_==0)	_=internal;
	tmpnam(_); strcat(_,"_");
	return	_;
}
int	Rfc822Msg::save(char *filename)
{
	char	*_,src[64],head[64];	uint	actual;	FILE *_tmpfil_;
	if((_=asstrstr(body-1,"\nbegin ",s_body,actual))) { _+=actual;
		if(isdigit(_[0]) && isdigit(_[1]) && isdigit(_[2])) {
			for(;*_!='\n';++_);
			strcpy(head,"begin 700 ");
			strcat(head,filename);
			if((_tmpfil_=fopen(atmpnam(src),"w"))==0) return 0;
			if(fputs(head,_tmpfil_)==EOF) return 0;
			a_print(grc.get(2,9));
			for(actual=s_body;actual>0;++_,--actual)
			{
				if(fputc(*_,_tmpfil_)==EOF)	return 0;
				if(*_=='d' && *(_-1)=='n'&& *(_-2)=='e'
						&& *(_-3)=='\n') {
				if(fputc('\n',_tmpfil_)==EOF)	return 0;
	 			if(fclose(_tmpfil_)) return 0;
				char	*argv[]={ grc.get(0,9), src, 0 };
				if(a_spawn(argv)==0) return 0;
				unlink(src); return 1;
				}
			}
			return 0;
		}else	goto	nextcheck;
	}else			nextcheck:
	if((_=asstrstr(body-1,"\nxbtoa Begin\n",s_body,actual))) {
		if((_tmpfil_=fopen(atmpnam(src),"w"))==0) return 0;
		a_print(grc.get(2,10));
		for(actual=s_body,_=body;actual>0;++_,--actual)
			if(fputc(*_,_tmpfil_)==EOF)	return 0;
		if(fclose(_tmpfil_)) return 0;
		char	*argv[]={ grc.get(0,8), 0 };
		if(a_spawn(argv,src,filename)==0) return 0;
		unlink(src); return 1;
	}
	FILE *fp;
	if( (fp=fopen(filename,"w"))==0)	return 0;
		for(int i=0;i<s_body;++i) {
			if(body[i]=='\n' && body[i-1]!='\r')
			if(fputc('\r',fp)==EOF)    { fclose(fp); return 0; }
			if(aputc(body[i],fp)==EOF) { fclose(fp); return 0; }
		}
	return	!fclose(fp);
}

//	EOF $Id: parse822.g,v 3.2 1994/11/10 10:23:53 agl Exp agl $
