//	AGL(C)	1994
//	$Id: localize.g,v 1.2 1994/01/16 19:54:00 agl Exp agl $
//	C++ frontend to X/Open like localization functions
//
#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "localize.h"

int	cmpindices(const void *c1_, const void *c2_)
{
#define	c1 ((LocalMsgsIndexes*)c1_)
#define	c2 ((LocalMsgsIndexes*)c2_)
	if( c1->set_id < c2->set_id) return -1;
	if( c1->set_id > c2->set_id) return  1;
	if( c1->msg_id < c2->msg_id) return -1;
	if( c1->msg_id > c2->msg_id) return  1; return 0;
}

char	*LocalMsgsC::get(int set_id, int msg_id) {
	LocalMsgsIndexes	i(set_id,msg_id), 
			*f=(LocalMsgsIndexes*)bsearch(&i, 
			rheap+sizeof(RcHeader),
			((RcHeader*)rheap)->nmessages,
			sizeof(LocalMsgsIndexes),
			cmpindices);
	if(f==0) {
		fprintf(stderr,"fatal 1004: Message #(%d,%d) is not existent\n"
			"Call the network support stuff\n",set_id,msg_id); 
		exit(-1);
	}
	return		rheap+f->offset;
}

void	LocalMsgsC::read(char *rcname)
{
	FILE *rc;	RcHeader rh;
	if((rc=fopen(rcname,"r"))==0) {
		fprintf(stderr,"ERROR 1002: Can't open resource file\n");
		goto blow;
	}
	if(fread(&rh,sizeof(rh),1,rc)!=1) {
		fprintf(stderr,"ERROR 1000: Can't read resource header\n");
		goto blow;
	}
	{int	rcsize=rh.rc_size;
	if(rheap!=0)	delete [] rheap;
	if((rheap=new char[rcsize])==0)	{
		fprintf(stderr,
	"ERROR 1001: Virtual memory exhausted in resource file reading");
		goto blow;
	}
	*(RcHeader*)rheap=rh;
	if(fread(rheap+sizeof(rh),rcsize-sizeof(rh),1,rc)!=1) {
		fprintf(stderr, "ERROR 1003: Can't read resource"); goto blow;
	}
	fclose(rc);
	return;
	}
blow:	exit(-1);
}
LocalMsgsC	grc;

//	EOF $Id: localize.g,v 1.2 1994/01/16 19:54:00 agl Exp agl $
