/*========================================================================*
 * TITLE:	Qwik Mail Reader for Unix
 * MODULE:	unpack.c
 * BY:		Ross C LINDER	(c) 1994 All rights reserved
 *
 * X11-QMR is Copyright (c) 1994 of Ross C Linder. X11-QMR is not public
 * domain. Permission is granted to use and distribute X11-QMR freely.
 * 
 * The only restriction is that you do not attempt to prevent others from
 *  having free access to the source.
 *========================================================================*/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/errno.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <Xm/SelectioB.h>
#include <Xm/List.h>
#include "util.h"
#include "qwk.h"

static char id[]=

"@(#)unpack.c	$Revision: 1.6 $	$Date: 1995/05/19 12:28:47 $";

/*========================================================================*/

Widget		conf_sel = NULL, conf_list;
Widget		msg_sel = NULL, msg_list;

extern Widget	fmsg_pb ;
extern Widget	bmsg_pb ;
extern Widget	fconf_pb;
extern Widget	bconf_pb;
extern Widget	toplevel, econtrol_box;

char		*xmsstr ();

int	conf_skip_flg = 0;	/* 1 = Dont Skip Empty confs */

char	bbs_tagfile[256] = "~/QMR/taglines";
char	bbs_printcmd[256] = "lp";
char	bbs_spellcmd[256] = "xterm -e ispell";
char	bbs_xeditcmd[256] = "xterm -e vi";
char	bbs_ansicmd[256] = "color_xterm -e aview";
char	bbs_zipcmd[256] = "zip -k -q -j";
char	bbs_unzipcmd[256] = "unzip -qq -o";
char	bbs_path[256];
char	bbs_user[26];
char	bbs_name[26];
char	bbs_news[10][20];	/* News flash files */
QWKHDR	extr_hdr;

struct {
	char	name[30];
	short	num;
	int	nmsg;
	int	npermsg;
	} qwk_areas[9999];	/* Max is 8191 */


int	cur_conf = 0;
static	max_conf = 0;
int	cur_msg = 0;

/*========================================================================*
 * MAKE_BBS_PATH -- set the bbs_path string to ~/QMR/xxxx
 *========================================================================*/

make_bbs_path (char *fname)
{
int	a;

    a = strlen (fname);
    while (fname[a] != '/' && a)
	a--;

    if (a)
	a++;

    strcpy (bbs_name, &fname[a]);

    for (a = 0; a < strlen (bbs_name); a++)
	if (bbs_name[a] == '.')
	    break;

    bbs_name[a] = 0;

    sprintf (bbs_path, "%s/QMR/%s", getenv ("HOME"), bbs_name);

    cur_conf = -1;
    cur_msg = 0;
}

/*========================================================================*
 * UNPACK_QWK -- Unpack the terrible QWK mail packet
 *
 * NOTE: This now uses the unzip environment cmd
 *========================================================================*/

unpack_qwk (char *fname, int do_data) 
{
FILE	*fpi;
char	ebuf[256];
int	a;
Widget	work_wid;

    if ((fpi = fopen (fname, "r")) == NULL) {
	sprintf (ebuf, "Error: %s\n       %s", fname, strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	return -1;
	}

    fclose (fpi);

    mkdir (bbs_path, 0776);
    chdir (bbs_path);

    work_wid = working_dialog ("Uncompressing qwk packet", "", "", "", NULL);

    if (do_data) {
	system ("rm -f *.cnf *.qmr *.dat");	/* Incase of a fuckup */

	sprintf (ebuf, "%s %s", bbs_unzipcmd, fname);
	system (ebuf);
	XtUnmanageChild (work_wid);
	}

    chdir (getenv ("HOME"));

    if (read_control () == -1)
	return -1;

    process_data (do_data);

    if (conf_sel != NULL) {
	if (XtIsManaged (conf_sel))
	    view_conf_sel ();
	}

    if (msg_sel != NULL) {
	if (XtIsManaged (msg_sel))
	    view_msg_sel ();
	}
    return 0;
}

/*========================================================================*
 * READ_CONTROL -- Read the qwk control file 
 *========================================================================*/

read_control ()
{
char	fname[256];
FILE	*fp;
char	tbuf[80];
int	a, b;
int	area_count;
int	num_areas;

    strcpy (fname, bbs_path);
    strcat (fname, "/control.dat");

    if ((fp = fopen (fname, "r")) == NULL) {
	sprintf (tbuf, "Error: %s\n       %s", fname, strerror (errno));
	error_dialog (tbuf, "OK", "", "", NULL);
	return -1;
	}

    for (a = 0; a < 5; a++)
	fgets (tbuf, 80, fp);

    b = strlen (tbuf) -  2;			/* Wipe out CRLF */
    tbuf[b] = 0;

    while (--b)
	if (tbuf[b] == ',') {
	    b++;
	    break;
	    }

    strcpy (bbs_name, &tbuf[b]);

    for (; a < 7; a++)
	fgets (tbuf, 80, fp);

    strcpy (bbs_user, tbuf);
    bbs_user[strlen (bbs_user) - 2] = 0;	/* Wipe out CRLF */
    strip_espace (bbs_user);
    

    for (; a < 10; a++)
	fgets (tbuf, 80, fp);

    fgets (tbuf, 80, fp);
    num_areas = atoi(tbuf) + 1;

    area_count = 0;
    for (area_count = 0; area_count < num_areas; area_count++) {
	if (!fgets (tbuf, 80, fp))
	    break;
	qwk_areas[area_count].num = atoi(tbuf);

	if (!fgets (tbuf, 80, fp))
	    break;
	a = strlen (tbuf) - 2;
	tbuf[a] = 0;		/* Kill CR LF */
	while (a) {
	    if (isspace (tbuf[a]))
		tbuf[a] = 0;
	    else
		break;
	    a--;
	    }
	tbuf[30] = 0;
	strcpy (qwk_areas[area_count].name, tbuf);
	}
	
    if (area_count != num_areas) {
	error_dialog ("Error: Control file is corrupt", "", "", "", NULL);
	return -1;
	}

    b = 1;
    strcpy (bbs_news[0], "stats");
    while (fgets (tbuf, 80, fp)) {
	if (tbuf[0] == '0' || tbuf[0] == 26 /* ^Z */)
	    break;

	for (a = 0; a < strlen (tbuf) - 2; a++)
	    tbuf[a] = tolower (tbuf[a]);
	tbuf[a] = 0;

	if (a > 20)		/* Must be dos compat filename */
	    continue;
		
	strcpy (bbs_news[b++], tbuf);
	}

    while (b < 10)
	bbs_news[b++][0] = 0;

    fclose (fp);

    strcpy (fname, bbs_path);
    strcat (fname, "/index.qmr");

    if ((fp = fopen (fname, "w")) == NULL) {
	sprintf (tbuf, "Error: %s\n       %s", fname, strerror (errno));
	error_dialog (tbuf, "OK", "", "", NULL);
	return -1;
	}

    fwrite ("\0", 1, 4 * num_areas, fp);	/* Sim Short of 0 */

    fclose (fp);

    max_conf = num_areas;

    qwk_areas[9000].num = 9000;
    strcpy (qwk_areas[9000].name, "Replies");
    qwk_areas[9000].nmsg = 0;
    qwk_areas[9000].npermsg = 0;

    return 0;
}

/*========================================================================*
 * PROCESS_DATA -- Make conference data files
 *
 * I have received some really corrupt mail packets from Qmail door, so
 * I have tried to do "error recovery" if I get junk :-)
 *========================================================================*/

process_data (int do_data)
{
char		fname[256];
FILE		*fp, *fpc[9999];
int		cnf_msg_cnt[9999];
int		per_msg_cnt[9999];
char		tbuf[QWK_BLK+1];	/* To null terminate */
int		a, b, c, d;
long		area_count;
QWKHDR		hdr;
int		last_area = -1;
Widget		work_wid;
long		hpos;
int		errcnt = 0;
int		errf = 0;
FILE		*fpi, *fpo;
long		thmno;
struct  {				/* Real after thought YUK */
	char	*sub;
	int	offset;
	int	len;
	} thread[32768];		/* Max 32768 msg per conf */



    for (a = 0; a < 9999; a++) {
	cnf_msg_cnt[a] = 0;
	per_msg_cnt[a] = 0;
	fpc[a] = NULL;
	qwk_areas[a].nmsg = 0;
	qwk_areas[a].npermsg = 0;
	}

    for (a = 0; a < 32768; a++) {
	thread[a].sub = NULL;
	thread[a].offset = 0;
	thread[a].len = 0;
	}

    strcpy (fname, bbs_path);
    strcat (fname, "/messages.dat");

    if ((fp = fopen (fname, "r+")) == NULL) {
	sprintf (tbuf, "Error: %s\n       %s", fname, strerror (errno));
	error_dialog (tbuf, "OK", "", "", NULL);
	return;
	}

    read_qwk_hdr (fp, &hdr, 0, 0);	/* waste Sparks (c) */

    hpos = 1;		/* Just in case we are fed shit */

    for (;;) {
	if (!read_qwk_hdr (fp, &hdr, 0, errf))
	    break;

	if ((hdr.status != ' ' && hdr.status != '-' && hdr.status != '+' &&
	    hdr.status != '*' && hdr.status != '~' &&
	    hdr.status != '`' && hdr.status != '%' &&
	    hdr.status != '^' && hdr.status != '!' &&
	    hdr.status != '#' && hdr.status != '$') ||

	    hdr.numchunks < 1 || hdr.msgnum < 0 || hdr.confnum > 9000) {
		errcnt++;
		if (errcnt == 2) {
		     warn_dialog ("Warning: QWK packet corrupt, trying "
		     "error recovery ...", "OK", "", "", NULL);
		     }

	    fseek (fp, hpos, SEEK_SET);
	    hpos++;
	    if (hpos == 0xA5F1)
		printf ("Ahha\n");

	    errf = 1;
	    continue;
	    }

	errf = 0;
	hpos = ftell (fp);		/* For Error recovery */

	if (last_area != hdr.confnum) {
	    sprintf (tbuf, "Processing Conference %d", hdr.confnum);
	    work_wid = working_dialog (tbuf, "", "", "", NULL);
	    last_area = hdr.confnum;
	    }

	cnf_msg_cnt[hdr.confnum]++;
	hdr.cmsgno = cnf_msg_cnt[hdr.confnum];

	if (strcmp (hdr.to, bbs_user) == 0)
	    per_msg_cnt[hdr.confnum]++;

	if (fpc[hdr.confnum] == NULL && do_data) {
	    sprintf (fname, "%s/%d.cnf", bbs_path, hdr.confnum);
	    fpc[hdr.confnum] = fopen (fname, "w");
	    }

	if (fpc[hdr.confnum] != NULL)
	    fwrite (&hdr, sizeof (hdr), 1, fpc[hdr.confnum]);

	for (a = 0; a < hdr.numchunks; a++) {
	    read_qwk_blk (fp, tbuf);

	    if (do_data) {
		if (a+1 == hdr.numchunks)	/* Clean up last block */
		    strip_espace (tbuf);
		fwrite (tbuf, QWK_BLK, 1, fpc[hdr.confnum]);
		}
	    }
	}

    if (errcnt > 1) {
	sprintf (tbuf, "Warning, the QWK packet was corrupt,"
	" some data was lost !\n"
	"It took %d error recovery tries to get back in sync", errcnt);
	
	warn_dialog (tbuf, "OK", "", "", NULL);
	}

    fclose (fp);

    for (a = 0; a < 9999; a++)
	if (fpc[a] != NULL) {
	    fclose (fpc[a]);
	    }

    work_wid = working_dialog ("Threading Articles", "", "", "", NULL);

    /*==== Okay here we will "thread" the confs ====*/

    for (a = 0; a < 9999; a++) {
	if (fpc[a] != NULL) {
	    sprintf (fname, "%s/%d.cnf", bbs_path, a);
	    sprintf (tbuf, "%s/thread.%d", bbs_path, getpid ());
	    rename (fname, tbuf);
	    fpi = fopen (tbuf, "r");
	    fpo = fopen (fname, "w");

	    /* Okay now we build the thread table */

	    thmno = 1;
	    b = 0;
	    thread[b].offset = 0;

	    while (fread (&hdr, sizeof (hdr), 1, fpi) == 1) {
		thread[b].sub = strdup (hdr.subj);
		thread[b].len = hdr.numchunks;
		while (hdr.numchunks) {
		    fread (tbuf, QWK_BLK, 1, fpi);
		    hdr.numchunks--;
		    }
		thread[++b].offset = ftell (fpi);
		}

	    fseek (fpi, 0, SEEK_SET);

	    for (b = 0; thread[b].sub != NULL; b++) {
		if (thread[b].len == 0)
		    continue;			/* Already done */

		fseek (fpi, thread[b].offset, SEEK_SET);

		fread (&hdr, sizeof (hdr), 1, fpi);
		hdr.msgnum = thmno++;
		fwrite (&hdr, sizeof (hdr), 1, fpo);
		while (thread[b].len) {
		    fread (tbuf, QWK_BLK, 1, fpi);
		    fwrite (tbuf, QWK_BLK, 1, fpo);
		    thread[b].len--;
		    }

		for (d = b + 1; thread[d].sub != NULL; d++) {
		    if (thread[d].len == 0)
			continue;		/* Already done */
		    if (strcmp (thread[b].sub, thread[d].sub) != 0)
			continue;

		    fseek (fpi, thread[d].offset, SEEK_SET);

		    fread (&hdr, sizeof (hdr), 1, fpi);
		    hdr.msgnum = thmno++;
		    fwrite (&hdr, sizeof (hdr), 1, fpo);
		    while (thread[d].len) {
			fread (tbuf, QWK_BLK, 1, fpi);
			fwrite (tbuf, QWK_BLK, 1, fpo);
			thread[d].len--;
			}
		    }

		/*==== Here I will try find the Re: ====*/

		strcpy (fname, "Re: ");
		strcat (fname, thread[b].sub);
		fname[25] = 0;

		for (d = b + 1; thread[d].sub != NULL; d++) {
		    if (thread[d].len == 0)
			continue;		/* Already done */
		    if (strcmp (fname, thread[d].sub) != 0)
			continue;

		    fseek (fpi, thread[d].offset, SEEK_SET);

		    fread (&hdr, sizeof (hdr), 1, fpi);
		    hdr.msgnum = thmno++;
		    fwrite (&hdr, sizeof (hdr), 1, fpo);
		    while (thread[d].len) {
			fread (tbuf, QWK_BLK, 1, fpi);
			fwrite (tbuf, QWK_BLK, 1, fpo);
			thread[d].len--;
			}
		    }
		}
	    fclose (fpi);
	    fclose (fpo);

	    sprintf (tbuf, "%s/thread.%d", bbs_path, getpid ());
	    unlink (tbuf);

	    for (b = 0; thread[b].sub != NULL; b++) {
		free (thread[b].sub);
		thread[b].sub = NULL;
		thread[b].len = 0;
		}
	    }
	}

    XtUnmanageChild (work_wid);

    sprintf (fname, "%s/%s", bbs_path, bbs_news[0]);

    fp = fopen (fname, "w");	/* Stats file */

    fprintf (fp, " Conf   Description                  Messages  Personal\n");


    for (a = 0; a < 9999; a++) {
	if (!cnf_msg_cnt[a])
	    continue;

	for (b = 0; b < 9999; b++)
	    if (qwk_areas[b].num == a) {
		qwk_areas[b].nmsg = cnf_msg_cnt[a];
		qwk_areas[b].npermsg = per_msg_cnt[a];
		break;
		}

	fprintf (fp, "%4d     %-30.30s %4d      %4d\n", qwk_areas[b].num,
		qwk_areas[b].name, qwk_areas[b].nmsg, qwk_areas[b].npermsg);
	}

    fclose (fp);

    set_header_display (bbs_user, "X11-QMR", "Message Stats",
			time (0), "", 1, 1, 1, 1);

    if (do_data) {
	strcpy (fname, bbs_path);
	strcat (fname, "/");
	strcat (fname, bbs_name);
	strcat (fname, ".MSG");

	if ((fp = fopen (fname, "w")) == NULL) {
	    sprintf (tbuf, "Error: %s\n       %s", fname, strerror (errno));
	    error_dialog (tbuf, "OK", "", "", NULL);
	    return;
	    }
	memset (tbuf, ' ', QWK_BLK);
	memcpy (tbuf, bbs_name, strlen (bbs_name));
	fwrite (tbuf, QWK_BLK, 1, fp);
	fclose (fp);
	}
}


/*========================================================================*
 * EXTRACT_MSG -- Extract a message from the conf file
 *========================================================================*/

extract_msg (int msg)
{
int		a, rdf;
char		fname[256], wname[256], pname[256];
FILE		*fpi, *fpo, *fpp;
char		ebuf[256], tbuf[256];
long		hpos;
int		spos, sposn;
struct tm	*tm;
struct stat	st;

    strcpy (wname, bbs_path);
    strcat (wname, "/work");

    strcpy (pname, bbs_path);
    strcat (pname, "/print");

    sprintf (fname, "%s/%d.cnf", bbs_path, qwk_areas[cur_conf].num);

    if ((fpo = fopen (wname, "w")) == NULL) {
	sprintf (ebuf, "Error: %s\n       %s", wname, strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	return - 1;
	}

    if ((fpp = fopen (pname, "w")) == NULL) {
	sprintf (ebuf, "Error: %s\n       %s", pname, strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	fclose (fpo);
	return - 1;
	}

    if (stat (fname, &st) == -1)
	return;

    fpi = NULL;

    if (st.st_size >= QWK_BLK)
	fpi = fopen (fname, "r+");

    if (fpi == NULL) {
	fprintf (fpo, "No messages in conference\n");
	fclose (fpo);
	fclose (fpp);
	}
    else {
	for (a = 0; a < msg; a++) {
	    fread (&extr_hdr, sizeof (extr_hdr), 1, fpi);
	    while (extr_hdr.numchunks) {
		fread (tbuf, QWK_BLK, 1, fpi);
		extr_hdr.numchunks--;
		}
	    }

	hpos = ftell (fpi);

	if (fread (&extr_hdr, sizeof (extr_hdr), 1, fpi) <= 0) {
	    fclose (fpi);
	    fclose (fpo);
	    return -1;
	    }

	rdf = extr_hdr.live == '-';

    tm = localtime (&extr_hdr.date);
    sprintf (tbuf, "%d  %s", extr_hdr.confnum, qwk_areas[cur_conf].name);

    fprintf (fpp, "TO: %-25s      DATE: %s\n", extr_hdr.to, asctime (tm));
    fprintf (fpp, "FROM: %-25s    CONF: %s\n", extr_hdr.from, tbuf);
    fprintf (fpp, "SUBJECT: %-25s MSG#: %d\n", extr_hdr.subj, extr_hdr.msgnum);
    fprintf (fpp, "_______________________________________"
		  "_______________________________________\n");


	if (!rdf && cur_conf != 9000) {
	    fseek (fpi, hpos, SEEK_SET);
	    extr_hdr.live = '-';
	    fwrite (&extr_hdr, sizeof (extr_hdr), 1, fpi);
	    fseek (fpi, hpos + sizeof (extr_hdr), SEEK_SET);
	    }

	for (a = 0; a < extr_hdr.numchunks; a++) {
	    fread (tbuf, QWK_BLK, 1, fpi);
	    if (a+1 == extr_hdr.numchunks)	/* Clean up last block */
		strip_espace (tbuf);
	    fwrite (tbuf, QWK_BLK, 1, fpo);
	    fwrite (tbuf, QWK_BLK, 1, fpp);
	    }

	fclose (fpo);
	fclose (fpp);
	fclose (fpi);
	}

    file_to_msg (wname, 1);

    if (qwk_areas[cur_conf].nmsg == 0) {
	strcpy (extr_hdr.to, bbs_user);
	strcpy (extr_hdr.from, "X11-QMR");
	strcpy (extr_hdr.subj, "Mail packet empty");
	extr_hdr.date = time (0);
	extr_hdr.confnum = qwk_areas[cur_conf].num;
	extr_hdr.msgnum = 0;
	}

    display_header (&extr_hdr);

    if (msg_sel != NULL) {
	if (XtIsManaged (msg_sel)) {
	    if (qwk_areas[cur_conf].nmsg) {
		XmListSelectPos (msg_list, msg+1, 0);	/* Dont notify */
		XmListSetBottomPos (msg_list, msg+1);
		}
	    }
	}

    return qwk_areas[cur_conf].nmsg ? 0 : -1;
}


/*========================================================================*
 * DISPLAY_HEADER -- Display a message header with conf name and Read flag
 *========================================================================*/

display_header (QWKHDR *hdr)
{
int	a, rdf;
char	tbuf[256];

    rdf = hdr->live == '-';

    if (cur_conf != 9000) {
	for (a = 0; a < 9999; a++)
	    if (hdr->confnum == qwk_areas[a].num)
		break;

	if (a == 9999) {
	    error_dialog ("QWK Packet is corrupt", "OK", "", "", NULL);
	    printf ("hdr conf is %d\n", hdr->confnum);
	    a = 0;
	    }
	}
    else
	a = 9000;

    sprintf (tbuf, "%d  %s", hdr->confnum, qwk_areas[a].name);

    set_header_display (hdr->to, hdr->from, hdr->subj, hdr->date,
	tbuf, hdr->msgnum, hdr->cmsgno, qwk_areas[a].nmsg, rdf);
}

/*========================================================================*
 * NEXT_MESSAGE -- Advance to the next message if posible, else beep
 *========================================================================*/

next_message ()
{
FILE	*fpid;
char	fname[256], ebuf[256];
short	cpos;

    if (extract_msg (cur_msg+1) != -1) {
	cur_msg++;
	strcpy (fname, bbs_path);
	strcat (fname, "/index.qmr");
	if ((fpid = fopen (fname, "r+")) == NULL) {
	    sprintf (ebuf, "Error: %s\n       %s", fname, strerror (errno));
	    error_dialog (ebuf, "OK", "", "", NULL);
	    return 0;
	    }

	fseek (fpid, qwk_areas[cur_conf].num * 4, SEEK_SET);
	fread (&cpos, 4, 1, fpid);
	if (cpos < cur_msg) {
	    fseek (fpid, qwk_areas[cur_conf].num * 4, SEEK_SET);
	    fwrite (&cur_msg, 4, 1, fpid);
	    }
	fclose (fpid);
	}
    else {
	fputc (7, stderr);
	return 0;
	}

    if (cur_msg+1 ==  qwk_areas[cur_conf].nmsg)
	return 0;

    return 1;
}

/*========================================================================*
 * PREV_MESSAGE -- Backtrack to the prev message if posible, else beep
 *========================================================================*/

prev_message ()
{
    if (cur_msg == 0) {		/* At first msg */
	fputc (7, stderr);
	return 0;
	}

    if (extract_msg (cur_msg-1) != -1)
	cur_msg--;

    if (cur_msg ==  0)
	return 0;

    return 1;
}

/*========================================================================*
 * NEXT_CONF -- Advance to the next conference. Skip empty confs,
 *              unless user requested otherwise. Beep if at END.
 *========================================================================*/

next_conf ()
{
int	a, b, c, cc;
char	fname[256];
char	tbuf[256];
FILE	*fpi, *fpo;
QWKHDR	hdr;

    if (cur_conf == 9000)
	return 0;

    if (conf_skip_flg == 0) {
	b = cur_conf;
	while (cur_conf++ <= max_conf) {
	    if (qwk_areas[cur_conf].nmsg)
		break;
	    }
	if (cur_conf > max_conf) {
	    cur_conf = 9000;
	    }
	}
    else if (cur_conf != 9000)
	cur_conf++;

    if (cur_conf == 9000) {
	strcpy (fname, bbs_path);
	strcat (fname, "/");
	strcat (fname, bbs_name);
	strcat (fname, ".MSG");

	if ((fpi = fopen (fname, "r")) == NULL) {
	    sprintf (tbuf, "Error: %s\n       %s", fname, strerror (errno));
	    error_dialog (tbuf, "OK", "", "", NULL);
	    return;
	    }

	strcpy (fname, bbs_path);
	strcat (fname, "/9000.cnf");

	if ((fpo = fopen (fname, "w")) == NULL) {
	    sprintf (tbuf, "Error: %s\n       %s", fname, strerror (errno));
	    error_dialog (tbuf, "OK", "", "", NULL);
	    fclose (fpi);
	    return;
	    }

	fseek (fpi, 0x80, SEEK_SET);

	qwk_areas[9000].nmsg = 0;

	cc = 1;
	for (;;) {
	    if (!read_qwk_hdr (fpi, &hdr, 1, 0))
		break;

	    qwk_areas[9000].nmsg++;

	    hdr.msgnum = hdr.repnum;
	    hdr.cmsgno = cc++;

	    fwrite (&hdr, sizeof (hdr), 1, fpo);

	    for (a = 0; a < hdr.numchunks; a++) {
		read_qwk_blk (fpi, tbuf);
		fwrite (tbuf, QWK_BLK, 1, fpo);
		}
	    }

	fclose (fpi);
	fclose (fpo);

	info_dialog ("Now Viewing your Replies", "OK", "", "", NULL);
	}

    cur_msg = 0;

    if (msg_sel != NULL) {
	if (XtIsManaged (msg_sel))
	    view_msg_sel ();
	}

    if (conf_sel != NULL) {
	b = 0;
	for (a = 0; a < max_conf; a++) {
	    if (qwk_areas[a].nmsg)
		b++;

	    if (qwk_areas[a].num == cur_conf)
		break;
	    }

	if (cur_conf == 9000)
	    b++;

	XmListSelectPos (conf_list, b, 0);	/* Dont notify */
	XmListSetBottomPos (conf_list, b);
	}

    extract_msg (0);

    if (cur_conf == 9000)
	return 0;

    return 1;
}

/*========================================================================*
 * PREV_CONF -- Backtrack to the prev conference. Skip empty confs,
 *              unless user requested otherwise. Beep if at START.
 *========================================================================*/

prev_conf ()
{
int	a, b;

    if (cur_conf == 9000)
	cur_conf = max_conf + 1;

    if (cur_conf == 0) {
	fputc (7, stderr);
	return 0;
	}

    if (conf_skip_flg == 0) {
	a = cur_conf;
	while (cur_conf-- >= 0)
	    if (qwk_areas[cur_conf].nmsg)
		break;

	if (cur_conf < 0) {
	    cur_conf = a;
	    return 0;
	    }
	}
    else 
	cur_conf--;

    cur_msg = 0;

    if (msg_sel != NULL) {
	if (XtIsManaged (msg_sel))
	    view_msg_sel ();
	}

    if (conf_sel != NULL) {
	b = 0;
	for (a = 0; a < max_conf; a++) {
	    if (qwk_areas[a].nmsg)
		b++;

	    if (qwk_areas[a].num == cur_conf)
		break;
	    }

	XmListSelectPos (conf_list, b, 0);	/* Dont notify */
	XmListSetBottomPos (conf_list, b);
	}

    extract_msg (0);

    if (cur_conf == 0)
	return 0;

    return 1;
}

/*========================================================================*
 * PACK_REPLIES -- Zip the reply message packet.
 *
 * NOTE: This uses the zip environment cmd !
 *========================================================================*/

pack_replies ()
{
char		fname[256];
char		zname[256];
char		cmd[256];
struct stat	st;
int		a;
Widget		w;

    strcpy (fname, bbs_path);
    strcat (fname, "/");
    strcat (fname, bbs_name);
    strcat (fname, ".MSG");

    if (stat (fname, &st) == -1)
	return;

    if (st.st_size <= QWK_BLK)
	return;

    for (a = 0; bbs_name[a]; a++)
	cmd[a] = tolower (bbs_name[a]);
    cmd[a] = 0;

    sprintf (zname, "%s/QMR/UP/%s.rep", getenv ("HOME"), cmd);

    w = working_dialog ("Compressing Replies", "", "", "", NULL);

    unlink (zname);

    sprintf (cmd, "%s %s %s", bbs_zipcmd, zname, fname);
    system (cmd);

    XtUnmanageChild (w);
}

/*========================================================================*
 * EBUSY_ERROR -- Error Dialog when busy editing
 *========================================================================*/

ebusy_error ()
{
    if (XtIsManaged (econtrol_box)) {
	error_dialog ("Finish your edit first !" , "OK", "", "", NULL);
	return 1;
	}

    return 0;
}

/*========================================================================*
 * CONF_PRESS -- Selection from conference selection list
 *
 * Here we check txt due to possibly empty conf's
 *========================================================================*/

void conf_press (Widget w, int ud, XmSelectionBoxCallbackStruct *cbd)
{
int	a, cnum;
char	*s, ebuf[256];

    if (!cbd->value)
	return;

   if (ebusy_error ())
	return;

    s = xmsstr (cbd->value);

    cnum = atoi (s);

    for (a = 0; a <= max_conf; a++) {
	if (qwk_areas[a].num == cnum)
	    break;
	}

    if (a == max_conf + 1) {
	error_dialog ("Invalid conference", "OK", "", "", NULL);
	a = cur_conf;
	}

    XtFree (s);

    if (a != cur_conf) {
	cur_conf = a;
	cur_msg = 0;
	if (msg_sel != NULL) {
	    if (XtIsManaged (msg_sel))
		view_msg_sel ();
	    }
	extract_msg (0);
	}
}

/*========================================================================*
 * MSG_PRESS -- Selection from message selection list
 *========================================================================*/

void msg_press (Widget w, int ud, XmSelectionBoxCallbackStruct *cbd)
{
int	a;
char	ebuf[256];

    if (!cbd->value)
	return;

   if (ebusy_error ())
	return;

    if (!XmListItemExists (msg_list, cbd->value)) {	/* A smart, arse */
	error_dialog ("Invalid message", "OK", "", "", NULL);
	a = cur_msg;
	}
    else
	a = XmListItemPos (msg_list, cbd->value) - 1;

    if (a != cur_msg) {
	cur_msg = a;
	extract_msg (a);
	}
}


/*========================================================================*
 * CONF_SEL_SEL -- Selection from message selection list with OK
 *========================================================================*/

void conf_sel_sel (Widget w, int ud, XmListCallbackStruct *cbd)
{
Arg	args[2];
int	a, b;

   if (ebusy_error ())
	return;

   if (fconf_pb != NULL) {
	XtSetArg (args[0], XmNsensitive, 1);
	XtSetValues (fconf_pb, args, 1);
	fconf_pb = NULL;
	}
   if (bconf_pb != NULL) {
	XtSetArg (args[0], XmNsensitive, 1);
	XtSetValues (bconf_pb, args, 1);
	bconf_pb = NULL;
	}

    a = cur_conf;

    if (conf_skip_flg == 0) {
	b = 0;
	cur_conf = -1;
	while (b < cbd->item_position) {
	    cur_conf++;
	    if (qwk_areas[cur_conf].nmsg)
		b++;
	    }
	}
    else
	cur_conf = cbd->item_position - 1;

    if (msg_sel != NULL) {
	if (XtIsManaged (msg_sel))
	    view_msg_sel ();
	}

    cur_msg = 0;
    extract_msg (0);
}

/*========================================================================*
 * MSG_SEL_SEL -- Selection from conference selection list with OK
 *========================================================================*/

void msg_sel_sel (Widget w, int ud, XmListCallbackStruct *cbd)
{
Arg	args[2];

   if (ebusy_error ())
	return;

   if (fmsg_pb != NULL) {
	XtSetArg (args[0], XmNsensitive, 1);
	XtSetValues (fmsg_pb, args, 1);
	fconf_pb = NULL;
	}
   if (bmsg_pb != NULL) {
	XtSetArg (args[0], XmNsensitive, 1);
	XtSetValues (bmsg_pb, args, 1);
	bconf_pb = NULL;
	}

    cur_msg = cbd->item_position - 1;
    extract_msg (cur_msg);
}

/*========================================================================*
 * VIEW_CONF_SEL -- Create/Manage the view conferences dialog
 *========================================================================*/

view_conf_sel ()
{
Arg		args[5];
int		a;
char		tbuf[256];
Widget		twid;
XmString	xms;

    if (conf_sel == NULL) {	/* Not yet created */
	xms = XmStringCreateLtoR ("Conference Selection",
				XmFONTLIST_DEFAULT_TAG);
	XtSetArg (args[0], XmNdialogTitle, xms);
	XtSetArg (args[1], XmNresizePolicy, XmRESIZE_NONE);
	conf_sel = XmCreateSelectionDialog (toplevel, "Sel", args, 2);
	XmStringFree (xms);

	conf_list = XmSelectionBoxGetChild (conf_sel, XmDIALOG_LIST);
	XtAddCallback (conf_sel, XmNokCallback,
			(XtCallbackProc)conf_press, 0);
	XtAddCallback (conf_sel, XmNapplyCallback,
			(XtCallbackProc)conf_press, 0);
	XtAddCallback (conf_list, XmNsingleSelectionCallback,
			(XtCallbackProc)conf_sel_sel, 0);
	XtAddCallback (conf_list, XmNbrowseSelectionCallback,
			(XtCallbackProc)conf_sel_sel, 0);
	
	twid = XmSelectionBoxGetChild (conf_sel, XmDIALOG_HELP_BUTTON);
	XtUnmanageChild (twid);

	xms = XmStringCreateLtoR ("Conference", XmFONTLIST_DEFAULT_TAG);
	twid = XmSelectionBoxGetChild (conf_sel, XmDIALOG_SELECTION_LABEL);
	XtSetArg (args[0], XmNlabelString, xms);
	XtSetValues (twid, args, 1);
	XmStringFree (xms);
	}

    XmListDeleteAllItems (conf_list);

    for (a = 0; a < max_conf; a++) {
	if (conf_skip_flg == 0) {
	    if (qwk_areas[a].nmsg == 0)
		continue;
	    }
	
	sprintf (tbuf, "%d %s", qwk_areas[a].num, qwk_areas[a].name);
	xms = XmStringCreateLtoR (tbuf, XmFONTLIST_DEFAULT_TAG);
	XmListAddItem (conf_list, xms, 0);
	XmStringFree (xms);
	}

    xms = XmStringCreateLtoR ("9000 Replies", XmFONTLIST_DEFAULT_TAG);
    XmListAddItem (conf_list, xms, 0);
    XmStringFree (xms);

    XtManageChild (conf_sel);
}

/*========================================================================*
 * VIEW_MSG_SEL -- Create/Manage the message selection dialog
 *========================================================================*/

view_msg_sel ()
{
Arg		args[5];
Widget		twid;
XmString	xms;
XmString	item;

    if (msg_sel == NULL) {
	xms = XmStringCreateLtoR ("Message Selection",
				XmFONTLIST_DEFAULT_TAG);

	item = XmStringCreateLtoR ("From                      To"
	"                        Subject                       ",
	XmFONTLIST_DEFAULT_TAG);

	XtSetArg (args[0], XmNdialogTitle, xms);
	XtSetArg (args[1], XmNlistLabelString, item);
	XtSetArg (args[2], XmNresizePolicy, XmRESIZE_NONE);
	msg_sel = XmCreateSelectionDialog (toplevel, "Sel", args, 3);
	XmStringFree (xms);
	XmStringFree (item);

	msg_list = XmSelectionBoxGetChild (msg_sel, XmDIALOG_LIST);
	XtAddCallback (msg_sel, XmNokCallback,
			(XtCallbackProc)msg_press, 0);
	XtAddCallback (msg_list, XmNsingleSelectionCallback,
			(XtCallbackProc)msg_sel_sel, 0);
	XtAddCallback (msg_list, XmNbrowseSelectionCallback,
			(XtCallbackProc)msg_sel_sel, 0);
	
	twid = XmSelectionBoxGetChild (msg_sel, XmDIALOG_HELP_BUTTON);
	XtUnmanageChild (twid);
	twid = XmSelectionBoxGetChild (msg_sel, XmDIALOG_APPLY_BUTTON);
	XtUnmanageChild (twid);

	xms = XmStringCreateLtoR ("Message", XmFONTLIST_DEFAULT_TAG);
	twid = XmSelectionBoxGetChild (msg_sel, XmDIALOG_SELECTION_LABEL);
	XtSetArg (args[0], XmNlabelString, xms);
	XtSetValues (twid, args, 1);
	XmStringFree (xms);
	}

    XmListDeleteAllItems (msg_list);

    build_new_msg_list ();

    XtManageChild (msg_sel);

    if (qwk_areas[cur_conf].nmsg) {
	XmListSelectPos (msg_list, cur_msg+1, 0);	/* Dont notify */
	XmListSetBottomPos (msg_list, cur_msg+1);
	}
}

/*========================================================================*
 * BUILD_NEW_MSG_LIST -- Build message list for new conference
 *========================================================================*/

build_new_msg_list ()
{
FILE		*fpi;
int		a;
char		tbuf[256];
QWKHDR		hdr;
XmString	xms;


    sprintf (tbuf, "%s/%d.cnf", bbs_path, qwk_areas[cur_conf].num);

    if ((fpi = fopen (tbuf, "r")) == NULL)
	return;

    a = 0;
    for (;;) {
	if (fread (&hdr, sizeof (hdr), 1, fpi) <= 0) {
	    fclose (fpi);
	    return;
	    }

	while (hdr.numchunks) {
	    fread (tbuf, QWK_BLK, 1, fpi);
	    hdr.numchunks--;
	    }

	sprintf (tbuf, "%-25.25s %-25.25s %-25.25s",
			hdr.from, hdr.to, hdr.subj);

	xms = XmStringCreateLtoR (tbuf, XmFONTLIST_DEFAULT_TAG);
	XmListAddItem (msg_list, xms, 0);
	XmStringFree (xms);
	}
}

/*========================================================================*
 * DELETE_MSG -- Delete a message from the conf file 9000 only !
 *========================================================================*/

delete_msg ()
{
int	a, rdf;
char	fname[256], wname[256];
FILE	*fpi, *fpo;
char	ebuf[256], tbuf[256];
long	hpos;
int	spos, sposn;
QWKHDR	qwk_hdr;;

    if (qwk_areas[cur_conf].nmsg == 0)
	return -1;

    sprintf (wname, "%s/%d.tmp", bbs_path, qwk_areas[cur_conf].num);
    sprintf (fname, "%s/%d.cnf", bbs_path, qwk_areas[cur_conf].num);

    if ((fpo = fopen (wname, "w")) == NULL) {
	sprintf (ebuf, "Error: %s\n       %s", fname, strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	return - 1;
	}

    if ((fpi = fopen (fname, "r")) == NULL) {
	fprintf (fpo, "No messages in conference\n");
	fclose (fpo);
	}
    else {
	for (a = 0; a < cur_msg; a++) {
	    fread (&qwk_hdr, sizeof (qwk_hdr), 1, fpi);
	    fwrite (&qwk_hdr,  sizeof (qwk_hdr), 1, fpo);
	    while (qwk_hdr.numchunks) {
		fread (tbuf, QWK_BLK, 1, fpi);
		fwrite (tbuf, QWK_BLK, 1, fpo);
		qwk_hdr.numchunks--;
		}
	    }

	fread (&qwk_hdr, sizeof (qwk_hdr), 1, fpi);
	while (qwk_hdr.numchunks) {
	    fread (tbuf, QWK_BLK, 1, fpi);
	    qwk_hdr.numchunks--;
	    }
	a++;

	for (; a < qwk_areas[cur_conf].nmsg; a++) {
	    fread (&qwk_hdr, sizeof (qwk_hdr), 1, fpi);
	    fwrite (&qwk_hdr,  sizeof (qwk_hdr), 1, fpo);
	    while (qwk_hdr.numchunks) {
		fread (tbuf, QWK_BLK, 1, fpi);
		fwrite (tbuf, QWK_BLK, 1, fpo);
		qwk_hdr.numchunks--;
		}
	    }

	fclose (fpo);
	fclose (fpi);

	unlink (fname);
	rename (wname, fname);
    	qwk_areas[cur_conf].nmsg--;
	}
}


/*========================================================================*
 * CONF9000_TO_REP -- Convert conf 9000 to replies
 *========================================================================*/

conf_9000_to_rep ()
{
int		a;
FILE		*fpi, *fpo;
char		fname[128];
char		cname[128];
char		tbuf[256];
QWKHDR		hdr;
SHT_QWKHDR	h;

    strcpy (fname, bbs_path);
    strcat (fname, "/");
    strcat (fname, bbs_name);
    strcat (fname, ".MSG");

    strcpy (cname, bbs_path);
    strcat (cname, "/");
    strcat (cname, "9000.cnf");

    if ((fpi = fopen (cname, "r")) == NULL) {
	sprintf (tbuf, "Error: %s\n       %s", cname, strerror (errno));
	error_dialog (tbuf, "OK", "", "", NULL);
	return;
	}

    if ((fpo = fopen (fname, "w")) == NULL) {
	sprintf (tbuf, "Error: %s\n       %s", fname, strerror (errno));
	error_dialog (tbuf, "OK", "", "", NULL);
	fclose (fpi);
	return;
	}

    memset (tbuf, ' ', QWK_BLK);
    memcpy (tbuf, bbs_name, strlen (bbs_name));
    fwrite (tbuf, QWK_BLK, 1, fpo);

    for (;;) {
	if (fread (&hdr, sizeof (hdr), 1, fpi) != 1)
	    break;

	h.status  = hdr.status;
	sprintf (h.msgnum, "%-7d", hdr.confnum);
	strftime (h.date, 14, "%m-%d-%y%H:%M", localtime (&hdr.date));
	sprintf (h.to, "%-25.25s", hdr.to);
	sprintf (h.from, "%-25.25s", hdr.from);
	sprintf (h.subj, "%-25.25s", hdr.subj);
	memset (h.pword, ' ', 12);
	sprintf (h.repnum, "%-8d", hdr.repnum);
	sprintf (h.numchunks, "%-6d", hdr.numchunks + 1);
	h.live = 0xE1;	/* Live */
	h.confnum[0] = (u_char)(hdr.confnum & 255);
	h.confnum[1] = (u_char)((hdr.confnum >> 8) & 255);

	if (!fwrite (&h, QWK_BLK, 1, fpo)) {
	    sprintf (tbuf, "Error: %s\n       %s", fname, strerror (errno));
	    error_dialog (tbuf, "OK", "", "", NULL);
	    fclose (fpi);
	    fclose (fpo);
	    return;
	    }
	
	while (hdr.numchunks) {
	    fread (tbuf, QWK_BLK, 1, fpi);
	    fwrite (tbuf, QWK_BLK, 1, fpo);
	    hdr.numchunks--;
	    }
	}

    fclose (fpi);
    fclose (fpo);
}


/*========================================================================*
 * SET_QWK_NMSG -- Sets the qwk_areas.nmsg to the given var and returns
 *                 the old one or -1;
 *========================================================================*/

set_qwk_nmsg (QWKHDR *hdr, int nnmsg)
{
int	a, onmsg;

    for (a = 0; a < 9999; a++)
	if (hdr->confnum == qwk_areas[a].num)
	    break;

    if (a == 9999)
	return -1;

    onmsg = qwk_areas[a].nmsg;
    qwk_areas[a].nmsg = nnmsg;

    return onmsg;
}


/*========================================================================*
 * GET_CONF_NAME -- Get the conference name, It looks in the news.db
 *		    for a real match or just returns the shitty qwk
 *		    name.
 *========================================================================*/

char *get_conf_name ()
{
int	a, cnum;
FILE	*fp;
char	fname[256];
char	nname[256];

    strcpy (fname, bbs_path);
    strcat (fname, "/nnews.db");

    for (a = 0; a < 9999; a++)
	if (cur_conf == qwk_areas[a].num)
	    break;

    if (a == 9999)	/* What ! how can there be no conf ! */
	return "";

    if ((fp = fopen (fname, "r")) == NULL)
	return qwk_areas[a].name;

    while (fscanf (fp, "%d %s\n", &cnum, nname) == 2) {
	if (cur_conf == cnum) {
	    fclose (fp);
	    return nname;
	    }
	}

    fclose (fp);
    return qwk_areas[a].name;
}

/*========================================================================*
 * $Log: unpack.c,v $
 * Revision 1.6  1995/05/19  12:28:47  ross
 * New (C) policy
 *
 * Revision 1.5  1994/12/20  01:08:55  ross
 * Added News mode support, and message n of n numbering systym.
 * Also added util funcs to access some of the qwk_area data.
 *
 * Revision 1.4  1994/12/06  00:37:00  ross
 * Fixed bug in MSG_PRESS that caused displayed message to be one in
 * advance of the selected message.
 *
 * Revision 1.3  1994/09/29  13:11:28  ross
 * Added support for Conf 9000 the replies conf. Also made sure the
 * message and conference selection lists stay in phase.
 * Fixed 3000 char signature limit, now intelligent <g>
 *
 * Revision 1.2  1994/09/13  09:46:03  ross
 * added the "-k" flag to the zip command line to make it pkzip compatible.
 * Automated shell scripts on compustat's uqwk front end assumed UPPER CASE
 * file names, so GOOFY.msg now becomes GOOFY.MSG
 *
 * Revision 1.1  1994/07/24  17:49:35  ross
 * Initial revision
 *
 *========================================================================*/

