/*========================================================================*
 * TITLE:	Qwik Mail Reader for Unix/Linux
 * MODULE:	tagline.c -- Tagline handling
 * BY:		Ross C LINDER	(c) 1994 All rights reserved
 *
 * X11-QMR is Copyright (c) 1994 of Ross C Linder. X11-QMR is not public
 * domain. Permission is granted to use and distribute X11-QMR freely.
 * 
 * The only restriction is that you do not attempt to prevent others from
 *  having free access to the source.
 *========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <sys/errno.h>
#include <Xm/SelectioB.h>
#include <Xm/List.h>

static char id[]=

"@(#)tagline.c	$Revision: 1.4 $	$Date: 1995/05/19 12:28:44 $";

/*========================================================================*/

Widget		tag_sel = NULL, tag_list;

extern Widget	toplevel;
extern char	bbs_tagfile[];
extern char	tag_line[];

char * xmsstr ();

/*========================================================================*
 * TAG_PRESS -- Tagline selection callback
 *========================================================================*/

void tag_press (Widget w, int ud, XmSelectionBoxCallbackStruct *cbd)
{
char	*txp, ebuf[256];
FILE	*fp;

    if (!cbd->value)
	return;

    txp = xmsstr (cbd->value);
    if (strlen (txp) > 60)
	txp[60] = 0;

    strcpy (tag_line, txp);

    if (!XmListItemExists (tag_list, cbd->value)) {	/* A new tagline */
	if ((fp = fopen (bbs_tagfile, "a+")) == NULL) {
	    sprintf (ebuf, "Error: %s\n     %s", bbs_tagfile, strerror (errno));
	    error_dialog (ebuf, "OK", "", "", NULL);
	    }
	else {
	    fprintf (fp, "%s\n", txp);
	    fclose (fp);
	    }
	}

    XtFree (txp);

    write_qmr_config ();	/* Update Default Tagline */
}


/*========================================================================*
 * TAG_SEL_SEL -- Tagline selected with OK callback
 *========================================================================*/

void tag_sel_sel (Widget w, int ud, XmListCallbackStruct *cbd)
{
char	*txp;

    txp = xmsstr (cbd->item);
    strcpy (tag_line, txp);
    XtFree (txp);
}

/*========================================================================*
 * EDIT_TAGLINE -- Create/Manage the tagline selection dialog
 *========================================================================*/

edit_tagline ()
{
FILE		*fp;
Arg		args[5];
char		ebuf[256];
char		tbuf[80];
Widget		twid;
XmString	xms;

    if (tag_sel == NULL) {
	xms = XmStringCreateLtoR ("Tag Line Selection", XmFONTLIST_DEFAULT_TAG);
	XtSetArg (args[0], XmNdialogTitle, xms);
	tag_sel = XmCreateSelectionDialog (toplevel, "TAG", args, 1);
	XmStringFree (xms);

	tag_list = XmSelectionBoxGetChild (tag_sel, XmDIALOG_LIST);
	XtAddCallback (tag_sel, XmNokCallback,
			(XtCallbackProc)tag_press, 0);
	XtAddCallback (tag_list, XmNsingleSelectionCallback,
			(XtCallbackProc)tag_sel_sel, 0);
	
	twid = XmSelectionBoxGetChild (tag_sel, XmDIALOG_HELP_BUTTON);
	XtUnmanageChild (twid);
	twid = XmSelectionBoxGetChild (tag_sel, XmDIALOG_APPLY_BUTTON);
	XtUnmanageChild (twid);

	xms = XmStringCreateLtoR ("Tagline", XmFONTLIST_DEFAULT_TAG);
	twid = XmSelectionBoxGetChild (tag_sel, XmDIALOG_SELECTION_LABEL);
	XtSetArg (args[0], XmNlabelString, xms);
	XtSetValues (twid, args, 1);
	XmStringFree (xms);
	}

    XmListDeleteAllItems (tag_list);

    if ((fp = fopen (bbs_tagfile, "r")) == NULL) {
	sprintf (ebuf, "Warning: %s\n       %s", bbs_tagfile, strerror (errno));
	warn_dialog (ebuf, "OK", "", "", NULL);
	XtManageChild (tag_sel);
	return;
	}
	
    while (fgets (tbuf, 80, fp)) {
	tbuf[strlen (tbuf) - 1] = 0;
	tbuf[60] = 0;
	xms = XmStringCreateLtoR (tbuf, XmFONTLIST_DEFAULT_TAG);
	XmListAddItem (tag_list, xms, 0);
	XmStringFree (xms);
	}
    fclose (fp);
    XtManageChild (tag_sel);
}


/*========================================================================*
 * SEL_RANDOM_TAG -- Select a tagline at random from the tagline file
 *
 * This is a bit yukky, but still..
 *========================================================================*/

sel_random_tag ()
{
FILE	*fp;
double	max_tag = 0;
char	tbuf[80];	/* Last on stack in case of over flow */

    if ((fp = fopen (bbs_tagfile, "r")) == NULL) {
	sprintf (tbuf, "Warning: %s\n       %s", bbs_tagfile, strerror (errno));
	warn_dialog (tbuf, "OK", "", "", NULL);
	XtManageChild (tag_sel);
	return;
	}
	
    while (fgets (tbuf, 80, fp))	/* Get # tags */
	max_tag++;

    srand48 (time (0));
    max_tag *= drand48 ();

    fseek (fp, SEEK_SET, 0);

    while (max_tag > 0) {
	fgets (tbuf, 80, fp);
	max_tag--;
	}

    tbuf[strlen (tbuf) - 1] = 0;
    tbuf[60] = 0;
    fclose (fp);

    strcpy (tag_line, tbuf);
}

/*========================================================================*
 * $Log: tagline.c,v $
 * Revision 1.4  1995/05/19  12:28:44  ross
 * New (C) policy
 *
 * Revision 1.3  1994/09/29  13:09:57  ross
 * improved randomizer using drand
 *
 * Revision 1.2  1994/09/13  09:45:04  ross
 * Added "sel_random_tag" to Select a tagline at random from the
 * tagline file.
 *
 * Revision 1.1  1994/07/24  17:49:33  ross
 * Initial revision
 *
 *========================================================================*/
