/*========================================================================*
 * TITLE:	Qwik Mail Reader for Unix/Linux
 * MODULE:	reply.c -- Handle the reply edits etc.
 * BY:		Ross C LINDER	(c) 1994 All rights reserved
 *
 * X11-QMR is Copyright (c) 1994 of Ross C Linder. X11-QMR is not public
 * domain. Permission is granted to use and distribute X11-QMR freely.
 * 
 * The only restriction is that you do not attempt to prevent others from
 *  having free access to the source.
 *========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/errno.h>
#include <Xm/Text.h>
#include <Xm/ComboBox.h>
#include "qwk.h"

static char id[]=

"@(#)reply.c	$Revision: 1.8 $	$Date: 1995/05/19 12:28:39 $";

/*========================================================================*/

u_char		reg_id[] = " X11-QMR 1.5 ";
char		tag_line[80] = " Linux -- a kind of magic";
int		auto_sig_flg;
int		random_tag_flg;
int		justify_flg, nnews_flg;


extern Widget	head_to_combo, head_subj_text, pub_tb, pvt_tb;
extern Widget	msg_text, env_dialog, lp_text, spell_text;
extern Widget	xedit_text, tagpath_text, ansiv_text, zip_text, unzip_text;
extern Widget	pub_tb;

extern int	cur_conf, reply_cnt;
extern int	cur_msg;
extern char	bbs_tagfile[];
extern char	bbs_printcmd[];
extern char	bbs_spellcmd[];
extern char	bbs_xeditcmd[];
extern char	bbs_ansicmd[];
extern char	bbs_zipcmd[], bbs_unzipcmd[];
extern char	bbs_user[];
extern char	bbs_path[];
extern char	bbs_name[];
extern char	last_dmsg[];
extern QWKHDR	extr_hdr;
QWKHDR		reply_hdr;

void pop_head_dialog (char *subj, char *to, char *from, int pvt);

/*========================================================================*
 * NEW_MSG -- Clear the msg text for a new message, pop up the
 *            message header dialog
 *========================================================================*/

new_msg (int msgno)
{
int		a, c;
struct tm	*tm;
char		nnbuf[256];

    reply_hdr.status = QWK_PUBLIC;
    reply_hdr.msgnum = extr_hdr.confnum;	/* This a reply */
    reply_hdr.cmsgno = 0;
    reply_hdr.date = time (0);
    strcpy (reply_hdr.to, "ALL");
    strcpy (reply_hdr.from, bbs_user);
    strcpy (reply_hdr.subj, "");
    reply_hdr.repnum = msgno;
    reply_hdr.numchunks = 0;
    reply_hdr.live = 'a';
    reply_hdr.confnum = extr_hdr.confnum;

    if (nnews_flg) {
	sprintf (nnbuf, "Newsgroups: %s\nFrom: %s\nSubject: \n\n",
		get_conf_name (), getenv ("QMR_EMAIL") ?
		getenv ("QMR_EMAIL") : bbs_user);

	XmTextSetString (msg_text, nnbuf);
	}
    else
	XmTextSetString (msg_text, "");

    display_header (&reply_hdr);

    if (!nnews_flg)
	edit_reply_header ();
}

/*========================================================================*
 * REPLY_TO_MSG -- Copy the current message to the message text
 *                 after adding the senders initials. Set header etc.
 *========================================================================*/

reply_to_msg (int msgno)
{
FILE		*fp, *fpo;
static char	*msgbuf;
char		ebuf[512];
char		*tp, uname[80];
char		fname[256];
struct stat	st;
int		a, c;
struct tm	*tm;
int		tnmsg;

    if ((fp = fopen (last_dmsg, "r")) == NULL) {
	sprintf (ebuf, "Error: %s\n       %s", last_dmsg, strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	return;
	}

    strcpy (fname, bbs_path);
    strcat (fname, "/reply");

    if ((fpo = fopen (fname, "w")) == NULL) {
	sprintf (ebuf, "Error: %s\n       %s", fname, strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	fclose (fp);
	return;
	}

    if (cur_conf != 9000) {
	reply_hdr.status = QWK_PUBLIC;
	reply_hdr.msgnum = extr_hdr.confnum;	/* This a reply */
	reply_hdr.cmsgno = reply_cnt + 1;
	reply_hdr.date = time (0);
	strcpy (reply_hdr.to, extr_hdr.from);
	strcpy (reply_hdr.from, bbs_user);
	strcpy (reply_hdr.subj, extr_hdr.subj);
	reply_hdr.repnum = msgno;
	reply_hdr.numchunks = 0;
	reply_hdr.live = 'a';
	reply_hdr.confnum = extr_hdr.confnum;

	strcpy (fname, extr_hdr.from);	/* In case we dont find From: */

	if (nnews_flg) {		/* Usenet news mode ? */
	    for (;;) {
		fgets (ebuf, 512, fp);

		if (strncmp (ebuf, "Newsgroups:", 11) == 0) {
		    fprintf (fpo, ebuf);
		    continue;
		    }

		else if (strncmp (ebuf, "Subject:", 8) == 0) {
		    if ((tp = strstr (ebuf, "Re:")) != NULL)
			fprintf (fpo, ebuf);
		    else
			fprintf (fpo, "Subject: Re: %s", &ebuf[9]);
		    continue;
		    }

		else if (strncmp (ebuf, "From:", 5) == 0) {
		    if (ebuf[strlen (ebuf) - 2] == ')') {		/* Got real */
			ebuf[strlen (ebuf) - 2] = 0;
		 	if ((tp = strrchr (ebuf, '(')) != NULL)
			    tp++;
			}
		    else
			tp = &ebuf[7];

		    strcpy (fname, tp);
		    }

		else if (strchr (ebuf, ':') != NULL)
		    continue;
		
		else {
		    fprintf (fpo, "From: %s\n\n", getenv ("QMR_EMAIL") ?
		    getenv ("QMR_EMAIL") : bbs_user);
		    break;
		    }
		}
	    }

	tm = localtime (&extr_hdr.date);
	strcpy (ebuf, asctime (tm));
	ebuf[strlen (ebuf) - 15] = 0;

	if (!nnews_flg) {
	    strcpy (fname, extr_hdr.to);
	    fprintf (fpo, "On %s, in a message to ", ebuf);
	    dual_case (fname);
	    fprintf (fpo, "%s\n", fname);
	    }
	else
	    fprintf (fpo, "On %s, ", ebuf);

	if (!nnews_flg)
	    strcpy (fname, extr_hdr.from);

	dual_case (fname);
	fprintf (fpo, "%s, stated that ..\n\n", fname);

	ebuf[0] = fname[0];
	a = 1;
	while (!isupper (fname[a]) && fname[a])
	    a++;
	
	if (fname[a])
	    ebuf[1] = fname[a];
	else
	    ebuf[1] = '-';

	ebuf[2] = '>'; ebuf[3] = ' ';
	}
    else {
	reply_hdr.status = extr_hdr.status;
	reply_hdr.msgnum = extr_hdr.confnum;	/* This a reply */
	reply_hdr.cmsgno = reply_cnt + 1;
	reply_hdr.date = extr_hdr.date;
	strcpy (reply_hdr.to, extr_hdr.to);
	strcpy (reply_hdr.from, extr_hdr.from);
	strcpy (reply_hdr.subj, extr_hdr.subj);
	reply_hdr.repnum = extr_hdr.repnum;
	reply_hdr.numchunks = 0;
	reply_hdr.live = 'a';
	reply_hdr.confnum = extr_hdr.confnum;
	}

    for (;;) {
	if (feof (fp))
	    break;
    
	fgets (&ebuf[4], 512, fp);
	if (!nnews_flg)
	    ebuf[78] = 0;	/* Waste long garbage ! */

	if (cur_conf != 9000)
	    fputs (ebuf, fpo);
	else
	    fputs (&ebuf[4], fpo);
	}

    fclose (fp);
    fclose (fpo);

    strcpy (fname, bbs_path);
    strcat (fname, "/reply");

    if (stat (fname, &st) == -1) {
	sprintf (ebuf, "Error: %s\n       %s", last_dmsg, strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	return;
	}

    if ((fp = fopen (fname, "r")) == NULL) {
	sprintf (ebuf, "Error: %s\n       %s", fname, strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	return;
	}

    if ((msgbuf = calloc (st.st_size + 1000, 1)) == NULL) {
	sprintf (ebuf, "Error: %s", strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	fclose (fp);
	return;
	}

    a = 0;
    for (;;) {
	if ((c = fgetc (fp)) == 0x0d)
	    continue;
	if (c == -1)
	    break;
	msgbuf[a++] = c;
	}

    fclose (fp);

    XmTextSetString (msg_text, msgbuf);

    tnmsg = set_qwk_nmsg (&reply_hdr, reply_cnt + 1);

    display_header (&reply_hdr);

    if (tnmsg != -1)
	set_qwk_nmsg (&reply_hdr, tnmsg);

    free (msgbuf);
}


/*========================================================================*
 * DUAL_CASE -- Turn ABC DEF to Abc Def, a friendly name <g>
 *========================================================================*/

dual_case (char *name)
{
int	a;

    a = 1;
    while (name[a] && name[a] != ' ') {
	name[a] = tolower (name[a]);
	a++;
	}

    if (name[a]) {
	a += 2;
	while (name[a] && name[a] != ' ') {
	    name[a] = tolower (name[a]);
	    a++;
	    }
	}
}

/*========================================================================*
 * EDIT_REPLY_HEADER -- Change details in the reply message header
 *========================================================================*/

edit_reply_header ()
{
    pop_head_dialog (reply_hdr.subj, reply_hdr.to, extr_hdr.to,
			reply_hdr.status == QWK_PRIVATE);
}


/*========================================================================*
 * HEAD_EDIT_CB -- Calback for the Edit header dialog
 *                 Set the destiantion, mode, and subject
 *========================================================================*/

void head_edit_cb ()
{
char	*tp;
int	a;

    tp = XmComboBoxGetString (head_to_combo);

    for (a = 0; tp[a] && a < 25; a++)
	reply_hdr.to[a] = toupper (tp[a]);

    reply_hdr.to[a] = 0;

    XtFree (tp);

    tp = XmTextGetString (head_subj_text);
    strncpy (reply_hdr.subj, tp, 25);
    XtFree (tp);

    if (XmToggleButtonGetState (pub_tb))
	reply_hdr.status = QWK_PUBLIC;
    else
	reply_hdr.status = QWK_PRIVATE;

    display_header (&reply_hdr);
}

/*========================================================================*
 * ENV_CB -- Edit Environment dialog callback, save new settings
 *========================================================================*/

void env_cb ()
{
FILE	*fp;
char	fname[256];
char	ebuf[256];
char	*tp;
int	a;

    sprintf (fname, "%s/QMR/config", getenv ("HOME"));
    if ((fp = fopen (fname, "w")) == NULL) {
	sprintf (ebuf, "Error: %s\n       %s", fname, strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	return;
	}

    tp = XmTextGetString (lp_text);
    fprintf (fp, "%s\n", tp);
    XtFree (tp);

    tp = XmTextGetString (spell_text);
    fprintf (fp, "%s\n", tp);
    XtFree (tp);

    tp = XmTextGetString (xedit_text);
    fprintf (fp, "%s\n", tp);
    XtFree (tp);

    tp = XmTextGetString (tagpath_text);
    fprintf (fp, "%s\n", tp);
    XtFree (tp);

    tp = XmTextGetString (ansiv_text);
    fprintf (fp, "%s\n", tp);
    XtFree (tp);

    tp = XmTextGetString (zip_text);
    fprintf (fp, "%s\n", tp);
    XtFree (tp);

    tp = XmTextGetString (unzip_text);
    fprintf (fp, "%s\n", tp);
    XtFree (tp);

    fprintf (fp, "%s\n", tag_line);

    fclose (fp);

    read_qmr_config ();
}


/*========================================================================*
 * READ_QMR_CONFIG -- Read the configuration environment from the
 *                    users config file. Assume defaults if it does
 *                    not exist, but warn luser.
 *========================================================================*/

read_qmr_config ()
{
FILE	*fp;
char	fname[256];
char	ebuf[256];
char	*tp;
int	a;

    sprintf (fname, "%s/QMR/config", getenv ("HOME"));
    if ((fp = fopen (fname, "r")) == NULL) {
	sprintf (ebuf, "Warning: %s\n       %s\nMaking default assumtions",
			fname, strerror (errno));
	warn_dialog (ebuf, "OK", "", "", NULL);
	sprintf (bbs_tagfile, "%s/QMR/taglines", getenv ("HOME"));
	return;
	}

    if (fgets (ebuf, 80, fp)) {
	ebuf[strlen (ebuf) - 1] = 0;
	strcpy (bbs_printcmd, ebuf);
	}

    if (fgets (ebuf, 80, fp)) {
	ebuf[strlen (ebuf) - 1] = 0;
	strcpy (bbs_spellcmd, ebuf);
	}

    if (fgets (ebuf, 80, fp)) {
	ebuf[strlen (ebuf) - 1] = 0;
	strcpy (bbs_xeditcmd, ebuf);
	}

    if (fgets (ebuf, 80, fp)) {
	ebuf[strlen (ebuf) - 1] = 0;
	strcpy (bbs_tagfile, ebuf);
	}

    if (fgets (ebuf, 80, fp)) {
	ebuf[strlen (ebuf) - 1] = 0;
	ebuf[60] = 0;
	strcpy (bbs_ansicmd, ebuf);
	}

    if (fgets (ebuf, 80, fp)) {
	ebuf[strlen (ebuf) - 1] = 0;
	strcpy (bbs_zipcmd, ebuf);
	}

    if (fgets (ebuf, 80, fp)) {
	ebuf[strlen (ebuf) - 1] = 0;
	strcpy (bbs_unzipcmd, ebuf);
	}

    if (fgets (ebuf, 80, fp)) {
	ebuf[strlen (ebuf) - 1] = 0;
	ebuf[60] = 0;
	strcpy (tag_line, ebuf);
	}

    fclose (fp);
}


/*========================================================================*
 * WRITE_QMR_CONFIG -- Save the current config environment to the
 *                     users config file.
 *========================================================================*/

write_qmr_config ()
{
FILE	*fp;
char	fname[256];
char	ebuf[256];
char	*tp;
int	a;

    sprintf (fname, "%s/QMR/config", getenv ("HOME"));
    if ((fp = fopen (fname, "w")) == NULL) {
	sprintf (ebuf, "Warning: Can't update config\n%s",
			fname, strerror (errno));
	warn_dialog (ebuf, "OK", "", "", NULL);
	return;
	}

    fprintf (fp, "%s\n", bbs_printcmd);
    fprintf (fp, "%s\n", bbs_spellcmd);
    fprintf (fp, "%s\n", bbs_xeditcmd);
    fprintf (fp, "%s\n", bbs_tagfile);
    fprintf (fp, "%s\n", bbs_ansicmd);
    fprintf (fp, "%s\n", bbs_zipcmd);
    fprintf (fp, "%s\n", bbs_unzipcmd);
    fprintf (fp, "%s\n", tag_line);
    fclose (fp);
}


/*========================================================================*
 * MAIL_REPLY_MSG -- Add the current message to the reply packet
 *========================================================================*/

mail_reply_msg ()
{
FILE		*fp;
FILE		*fpsig;
char		fname[256], *src, *sp;
char		ebuf[256];
SHT_QWKHDR	h;
int		len;
int		cm;
struct stat	st;
int		tag_blob;

    if (nnews_flg)		/* Type of blob in tagline, news, mail etc */
	tag_blob = '*';		/* uses 7 bit ASCII */
    else
	tag_blob = '\376';	/* Traditional square */

    if (cur_conf == 9000) {	/* Relace the reply */
	cm = cur_msg;		/* Save msg -> */
	delete_msg ();		/* Remove old version of reply */
	conf_9000_to_rep ();	/* from .REP as well */
	}

    strcpy (fname, bbs_path);
    strcat (fname, "/");
    strcat (fname, bbs_name);
    strcat (fname, ".MSG");

    if ((fp = fopen (fname, "a+")) == NULL) {
	sprintf (ebuf, "Error: %s\n       %s", fname, strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	return;
	}

    src = XmTextGetString (msg_text);

    sprintf (fname, "%s/QMR/signature", getenv ("HOME"));

    if (stat (fname, &st) != -1)
	sp = calloc (strlen (src) + st.st_size + 100, 1);	/* Sig + Tag */
    else
	sp = calloc (strlen (src) + 100, 1);			/* Tag only */

    if (sp == NULL) {
	sprintf (ebuf, "Error: ", strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	fclose (fp);
	return;
	}

    strcpy (sp, src);
    XtFree (src);
    src = sp;

    if (cur_conf != 9000)	/* No auto justify of re-edits */
	break_lines (src);

    if (auto_sig_flg && cur_conf != 9000) {
	sprintf (fname, "%s/QMR/signature", getenv ("HOME"));
	if ((fpsig = fopen (fname, "r")) != NULL) {
	    while (fgets (ebuf, 80, fpsig) != NULL)
		strcpy (&src[strlen (src)], ebuf);
	    fclose (fpsig);
	    }
	}

    if (random_tag_flg)
	sel_random_tag ();

    if (cur_conf != 9000)
	sprintf (&src[strlen (src)], "\n%c%s%c %s\n", tag_blob, reg_id,
						      tag_blob,  tag_line);

    reply_hdr.numchunks = (strlen (src) / QWK_BLK) +
			  ((strlen (src) % QWK_BLK) ? 2 : 1);

    h.status  = reply_hdr.status;
    sprintf (h.msgnum, "%-7d", reply_hdr.confnum);
    strftime (h.date, 14, "%m-%d-%y%H:%M", localtime (&reply_hdr.date));
    sprintf (h.to, "%-25.25s", reply_hdr.to);
    sprintf (h.from, "%-25.25s", reply_hdr.from);
    sprintf (h.subj, "%-25.25s", reply_hdr.subj);
    memset (h.pword, ' ', 12);
    sprintf (h.repnum, "%-8d", reply_hdr.repnum);
    sprintf (h.numchunks, "%-6d", reply_hdr.numchunks);
    h.live = 0xE1;	/* Live */
    h.confnum[0] = (u_char)(reply_hdr.confnum & 255);
    h.confnum[1] = (u_char)((reply_hdr.confnum >> 8) & 255);

    if (!fwrite (&h, QWK_BLK, 1, fp)) {
	sprintf (ebuf, "Error: %s\n       %s", fname, strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	fclose (fp);
	free (src);
	return;
	}
	
    sp = src;
    while (sp = strchr (sp, '\n'))
	*sp = 0xE3;			/* Arshole eol */

    strip_espace (src);			/* Remove trailing white space */
    len = strlen (src);

    fwrite (src, 1, len, fp);

    while (len < QWK_BLK * (reply_hdr.numchunks - 1)) {
	fputc (0, fp);
	len++;
	}

    fclose (fp);

    free (src);

    if (cur_conf == 9000) {
	cur_conf = 8999;	/* Unused # */
	next_conf ();		/* Re-extract conf 9000 */
	cur_msg = cm;
	extract_msg (cm);
	}
}


/*========================================================================*
 * SPELL_CHECK_REPLY -- Run an external spelling checker on the reply
 *
 * NOTE: Ispell is recomended, and used by default.
 *========================================================================*/

spell_check_reply ()
{
FILE	*fp;
char	cmd[256], ebuf[256];
char	*src;

    strcpy (cmd, bbs_path);
    strcat (cmd, "/reply");

    if ((fp = fopen (cmd, "w")) == NULL) {
	sprintf (ebuf, "Error: %s\n       %s", cmd, strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	return;
	}
	
    src = XmTextGetString (msg_text);
    break_lines (src);

    fwrite (src, 1, strlen (src), fp);
    fclose (fp);

    XtFree (src);

    sprintf (cmd, "%s %s/reply", bbs_spellcmd, bbs_path);
    if (system (cmd) == 0) {
	strcpy (cmd, bbs_path);
	strcat (cmd, "/reply");
	file_to_msg (cmd, 1);
	}
    else
	error_dialog ("Problem Spell Checking", "OK", "", "", NULL);
}


/*========================================================================*
 * FORMAT_REPLY -- Limit the with of a line to 72 chars so that when
 *                 the message is replied to, it still is neat for
 *                 most offline mail readers. Yuk !
 *========================================================================*/

format_reply ()
{
char	*src;

    src = XmTextGetString (msg_text);
    break_lines (src);

    XmTextSetString (msg_text, src);

    XtFree (src);
}


/*========================================================================*
 * EXT_EDIT_REPLY -- Edit the reply using the external editor.
 *
 * NOTE: This uses "vi" by default, the best editor ever created
 *========================================================================*/

ext_edit_reply ()
{
FILE	*fp;
char	cmd[256], ebuf[256];
char	*src;

    strcpy (cmd, bbs_path);
    strcat (cmd, "/reply");

    if ((fp = fopen (cmd, "w")) == NULL) {
	sprintf (ebuf, "Error: %s\n       %s", cmd, strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	return;
	}
	
    src = XmTextGetString (msg_text);
    break_lines (src);

    fwrite (src, 1, strlen (src), fp);
    fclose (fp);

    XtFree (src);

    sprintf (cmd, "%s %s/reply", bbs_xeditcmd, bbs_path);
    if (system (cmd) == 0) {
	strcpy (cmd, bbs_path);
	strcat (cmd, "/reply");
	file_to_msg (cmd, 1);
	}
    else
	error_dialog ("Problem executing external editor", "OK", "", "", NULL);
}


/*========================================================================*
 * BREAK_LINES -- Split the lines of source into lines of not more than
 *                72 Chars for sender, and 79 Chars for quotee
 *========================================================================*/

break_lines (char *s)
{
int	a, b, c, snip;

    if (justify_flg == 0)
	return;

    a = 0;
    b = 0;

    for (;;) {
	if (s[a] == 0)
	    break;

	if (s[a+2] == '>' || s[a] == '\376')	/* Quotee or Tag ? */
	    snip = 79;
	else
	    snip = 72;

	for (b = a; b < a + snip; b++) {
	    if (s[b] == 0)
		return;
	    if (s[b] == '\n')
		break;
	    }

	if (b != a + snip) {
	    b++;
	    a = b;
	    continue;
	    }

	while (s[b] != ' ' && b && s[b] != '\n')
	    b--;

	if (b > a) {
	    s[b] = '\n';
	    c = 1;
	    for (;; c++) {
	    	if (!s[b+c])
	    	    break;			/* End of Text */
		if (s[b+c] == '\n') {		/* Join next line */
		    if (s[b+c+1] != '\n')	/* unless paragraph */
			s[b+c] = ' ';
		    break;
		    }
		}
	    }
	else {
	    b++;
	    while (s[b] != ' ' && s[b] != '\n' && s[b]) /* cant break line */
		b++;
	    }

	if (s[b])
	    a = b + 1;
	else
	    a = b;
	}
}

/*========================================================================*
 * ADD_CONF -- Send mail to QMAIL asking to add this conf
 *========================================================================*/

add_conf (int msgno)
{
int		a, c;
struct tm	*tm;

    reply_hdr.status = QWK_PRIVATE;
    reply_hdr.msgnum = extr_hdr.confnum;	/* This a reply */
    reply_hdr.date = time (0);
    strcpy (reply_hdr.to, "QMAIL");
    strcpy (reply_hdr.from, bbs_user);
    strcpy (reply_hdr.subj, "ADD");
    reply_hdr.repnum = msgno;
    reply_hdr.numchunks = 0;
    reply_hdr.live = 'a';
    reply_hdr.confnum = extr_hdr.confnum;

    mail_qmail_msg ();

    info_dialog ("Conference ADD requested", "OK", "", "", NULL);
}

/*========================================================================*
 * DROP_CONF -- Send mail to QMAIL asking to drop this conf
 *========================================================================*/

drop_conf (int msgno)
{
int		a, c;
struct tm	*tm;

    reply_hdr.status = QWK_PRIVATE;
    reply_hdr.msgnum = extr_hdr.confnum;	/* This a reply */
    reply_hdr.date = time (0);
    strcpy (reply_hdr.to, "QMAIL");
    strcpy (reply_hdr.from, bbs_user);
    strcpy (reply_hdr.subj, "DROP");
    reply_hdr.repnum = msgno;
    reply_hdr.numchunks = 0;
    reply_hdr.live = 'a';
    reply_hdr.confnum = extr_hdr.confnum;

    mail_qmail_msg ();

    info_dialog ("Conference DROP requested", "OK", "", "", NULL);
}

/*========================================================================*
 * MAIL_QMAIL_MSG -- Add a ADD or DROP message to the reply packet
 *========================================================================*/

mail_qmail_msg ()
{
FILE		*fp;
char		fname[256];
char		ebuf[256];
SHT_QWKHDR	h;
int		len;

    strcpy (fname, bbs_path);
    strcat (fname, "/");
    strcat (fname, bbs_name);
    strcat (fname, ".MSG");

    if ((fp = fopen (fname, "a+")) == NULL) {
	sprintf (ebuf, "Error: %s\n       %s", fname, strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	return;
	}

    reply_hdr.numchunks = 1;

    h.status  = reply_hdr.status;
    sprintf (h.msgnum, "%-7d", reply_hdr.confnum);
    strftime (h.date, 14, "%m-%d-%y%H:%M", localtime (&reply_hdr.date));
    sprintf (h.to, "%-25.25s", reply_hdr.to);
    sprintf (h.from, "%-25.25s", reply_hdr.from);
    sprintf (h.subj, "%-25.25s", reply_hdr.subj);
    memset (h.pword, ' ', 12);
    sprintf (h.repnum, "%-8d", reply_hdr.repnum);
    sprintf (h.numchunks, "%-6d", reply_hdr.numchunks);
    h.live = 0xE1;	/* Live */
    h.confnum[0] = (u_char)(reply_hdr.confnum & 255);
    h.confnum[1] = (u_char)((reply_hdr.confnum >> 8) & 255);

    if (!fwrite (&h, QWK_BLK, 1, fp)) {
	sprintf (ebuf, "Error: %s\n       %s", fname, strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	fclose (fp);
	return;
	}
	
    fclose (fp);
}

/*========================================================================*
 * ANSI_VIEW -- Run the external ansi viewer command
 *
 * NOTE: This uses "color-xterm" by default.
 *========================================================================*/

ansi_view (char *path)
{
char	cmd[256];

    sprintf (cmd, "%s %s/%s", bbs_ansicmd, bbs_path, path);

    if (system (cmd) != 0)
	error_dialog ("Problem executing ANSI Viewer", "OK", "", "", NULL);
}

/*========================================================================*
 * $Log: reply.c,v $
 * Revision 1.8  1995/05/19  12:28:39  ross
 * New (C) policy
 *
 * Revision 1.7  1995/02/01  06:17:27  ross
 * When in news mode, the high ASCII blobs arround the version number in
 * the tag line have been replaced with "*"'s
 *
 * Revision 1.6  1994/12/20  01:02:33  ross
 * Added News mode support, and fixed reply message counters.
 *
 * Revision 1.5  1994/12/06  00:41:51  ross
 * Fixed version number for EOM.
 *
 * Revision 1.4  1994/12/06  00:36:30  ross
 * Added code to now use environment settings for (un)zip
 *
 * Revision 1.3  1994/09/29  13:08:05  ross
 * Added Ansi view facility, also the message number of replies now
 * follows in a logical manner.
 *
 * Revision 1.2  1994/09/13  09:42:56  ross
 * Added code to send ADD and DROP messages to Qmail, a new mailer
 * sub that does not add sigs or taglines is used, "mail_qmail_msg"
 * Also the heart of the auto signature, and random taglines code
 * is held here. Perhaps the names of the files need a rethink.
 *
 * Revision 1.1  1994/07/24  17:49:31  ross
 * Initial revision
 *
 *========================================================================*/
