/*========================================================================*
 * TITLE:	Qwik Mail Reader for Unix/Linux
 * MODULE:	qwk.h -- Simple QWK message info
 * BY:		Ross C LINDER	(c) 1994 All rights reserved
 *
 * X11-QMR is Copyright (c) 1994 of Ross C Linder. X11-QMR is not public
 * domain. Permission is granted to use and distribute X11-QMR freely.
 * 
 * The only restriction is that you do not attempt to prevent others from
 *  having free access to the source.
 *
 * @(#)qwk.h	$Revision: 1.3 $	$Date: 1995/05/19 12:28:33 $
 *========================================================================*/

#include <sys/types.h>

#define QWK_BLK		128	/* Size of msg block */
#define QWK_PUBLIC	0x20	/* Public unread message */
#define QWK_PRIVATE	0x2A	/* Private message */


/*=================== Shitty basic type QWK header =======================*/

typedef struct {
    char	status;
    char	msgnum[7];
    char	date[8];
    char	time[5];
    char	to[25];
    char	from[25];
    char	subj[25];
    char	pword[12];
    char	repnum[8];
    char	numchunks[6];
    u_char	live;
    u_char	confnum[2];
    char	junk[3];
    } SHT_QWKHDR;

/*========================== niCe C type =================================*/

typedef struct {
    char	status;
    long	msgnum;
    long	cmsgno;
    time_t	date;
    char	to[26];
    char	from[26];
    char	subj[26];
    char	pword[13];
    long	repnum;
    long	numchunks;
    char	live;
    u_short	confnum;
    } QWKHDR;

/*========================================================================*
 * $Log: qwk.h,v $
 * Revision 1.3  1995/05/19  12:28:33  ross
 * New (C) policy
 *
 * Revision 1.2  1994/12/20  01:02:01  ross
 * Added a cmsgno (Current message no) var to C qwk header struct
 *
 * Revision 1.1  1994/07/24  17:49:28  ross
 * Initial revision
 *
 *========================================================================*/

