/*========================================================================*
 * TITLE:	Qwik Mail Reader for Unix
 * MODULE:	qwk.c
 * BY:		Ross C LINDER	(c) 1994 All rights reserved
 *
 * X11-QMR is Copyright (c) 1994 of Ross C Linder. X11-QMR is not public
 * domain. Permission is granted to use and distribute X11-QMR freely.
 * 
 * The only restriction is that you do not attempt to prevent others from
 *  having free access to the source.
 *========================================================================*/

#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include "qwk.h"

static char id[]=

"@(#)qwk.c	$Revision: 1.2 $	$Date: 1995/05/19 12:28:02 $";

/*========================================================================*
 * READ_QWK_HDR -- Read the shitty qwk header into a C structure
 *========================================================================*/

read_qwk_hdr (FILE *fp, QWKHDR *hdr, int rep, int errf)
{
SHT_QWKHDR	h;
struct tm	tm;
char		date[14], p;
int		a;


    if (fread (&h, 1, QWK_BLK, fp) != QWK_BLK)
	return 0;


    if (h.status == 0 && errf == 0)
	return 0;

    hdr->status  = h.status;
    hdr->confnum = (h.confnum[0] & 255) + ((h.confnum[1] & 255) << 8);
    hdr->live = h.live == 0xE1 ? 1 : 0;
    h.live = 0;
    hdr->numchunks = atol (h.numchunks) - 1;	/* minus header */
    *h.numchunks = 0;
    hdr->repnum = atol (h.repnum);
    *h.repnum = 0;
    strcpy (hdr->pword, h.pword);
    strip_espace (hdr->pword);
    *h.pword = 0;
    strcpy (hdr->subj, h.subj);
    strip_espace (hdr->subj);
    *h.subj = 0;
    strcpy (hdr->from, h.from);
    strip_espace (hdr->from);
    *h.from = 0;
    strcpy (hdr->to, h.to);
    strip_espace (hdr->to);
    *h.to = 0;
    strcpy (date, h.date);
    *h.date = 0;
    if(!rep)
	hdr->msgnum = atol (h.msgnum);
    else {
        hdr->msgnum = 0;
        hdr->confnum = atoi (h.msgnum);
    }

    date[2] = 0;
    tm.tm_mon = atoi (date) - 1;
    date[5] = 0;
    tm.tm_mday = atoi (&date[3]);
    p = date[8];
    date[8] = 0;
    tm.tm_year = atoi (&date[6]);
    if (tm.tm_year < 89)		/* PC's screw the world */
	tm.tm_year += 100;
    date[8] = p;
    date[10] = 0;
    tm.tm_hour = atoi (&date[8]);
    tm.tm_min = atoi (&date[11]);
    tm.tm_sec = 0;
    tm.tm_wday = 0;
    tm.tm_yday = 0;
    tm.tm_isdst = 0;
    hdr->date = mktime (&tm);

    /*==== Convert to QWK SPEC ! ====*/

    for (a = strlen (hdr->to) - 1;  a >= 0; a--)
	hdr->to[a] = toupper (hdr->to[a]);

    for (a = strlen (hdr->from) - 1;  a >= 0; a--)
	hdr->from[a] = toupper (hdr->from[a]);

    return 1;
}


/*========================================================================*
 * READ_QWK_BLK -- Read the block, convert 0xE3 to LF's
 *========================================================================*/

read_qwk_blk (FILE *fp, char *blk)
{
char	*p = blk;

    if (fread (blk, 1, QWK_BLK, fp) != QWK_BLK)
	return 0;

    blk[QWK_BLK] = 0;
    while ((p = strchr (p, 0xE3)) != NULL)
	*p = '\n';

    return 1;
}


/*========================================================================*
 * STRIP_ESPACE -- Remove white space at end of string
 *========================================================================*/

strip_espace (char *s)
{
int	a;

    a = strlen (s) - 1;
    while (a > 0 && isspace (s[a]))
	s[a--] = 0;
}

/*========================================================================*
 * $Log: qwk.c,v $
 * Revision 1.2  1995/05/19  12:28:02  ross
 * New (C) policy
 *
 * Revision 1.1  1994/07/24  17:49:26  ross
 * Initial revision
 *
 *========================================================================*/
