/*========================================================================*
 * TITLE:	Qwik Mail Reader for Unix/Linux
 * MODULE:	qmr.c -- most of the interface stuff
 * BY:		Ross C LINDER	(c) 1994 All rights reserved
 *
 * X11-QMR is Copyright (c) 1994 of Ross C Linder. X11-QMR is not public
 * domain. Permission is granted to use and distribute X11-QMR freely.
 * 
 * The only restriction is that you do not attempt to prevent others from
 *  having free access to the source.
 *
 * If you make some usefull modifications to qmr, then send them to me
 * I will include them and give you credit.
 *========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/errno.h>
#include <X11/StringDefs.h>
#include <Mrm/MrmAppl.h>	/* Motif Toolkit */
#include <Xm/Command.h>
#include <Xm/Form.h>
#include <Xm/List.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <Xm/Separator.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/ComboBox.h>
#include <X11/cursorfont.h>
#include <Xmd/Help.h>
#include "about.h"
#include "qwk.h"

static char id[]=

"@(#)qmr.c	$Revision: 1.7 $	$Date: 1995/05/19 12:26:33 $";

/*========================================================================*/

void set_title (char *name);
void file_cb ();
void filesel_cb (Widget w, int *tag, XmFileSelectionBoxCallbackStruct *cbd);
void savesel_cb (Widget w, int *tag, XmFileSelectionBoxCallbackStruct *cbd);
void edit_cb ();
void view_cb ();
void options_cb ();
void icon_cb ();
void help_cb (Widget w, int *opt);
void exit_cb (void);
void head_edit_cb (void);
void env_cb (void);
void topinit (int argc, char **argv);
static void file_query_ret (int key);
static void trash_query_ret (int key);
static void del9000_query_ret (int key);
Widget tree_widget ();

MrmHierarchy	s_MrmHierarchy;
static	char	*Lvec[] = {"qmr.uid",
			   };
static	MrmCode	class ;

extern Widget	conf_sel;
extern		conf_skip_flg;
extern		auto_sig_flg;
extern		random_tag_flg;
extern		justify_flg, nnews_flg;
extern		cur_conf;
extern		cur_msg;
extern char	bbs_path[], bbs_printcmd[];
extern char	bbs_spellcmd[];
extern char	bbs_xeditcmd[];
extern char	bbs_tagfile[];
extern char	bbs_ansicmd[];
extern char	bbs_zipcmd[], bbs_unzipcmd[];
extern char	bbs_news[10][20];
extern char	bbs_user[];
extern QWKHDR	extr_hdr;
char		last_dmsg[256];


/*========================================================================*/

XtAppContext	app_context;
Display		*disp = NULL;
Widget		toplevel, mainw, msg_text;
Widget		control_box, econtrol_box, news_box;
Widget		filesel, savesel;
Widget		head_to_combo, head_subj_text, pub_tb, pvt_tb;
Widget		env_dialog, lp_text, spell_text;
Widget		xedit_text, tagpath_text, ansiv_text, zip_text, unzip_text;
static char	pktfname[256];
static		news_flash = 0, last_news_flash = 0;
int		reply_cnt = 0;

Widget		to_lab, from_lab, subject_lab, date_lab;
Widget		conf_lab, msgno_lab;
Widget		fmsg_pb = NULL;
Widget		bmsg_pb = NULL;
Widget		fconf_pb = NULL;
Widget		bconf_pb = NULL;
Widget		nmsg_pb = NULL;
Widget		drep_pb = NULL;
Cursor		context_cur;

/*========================================================================*/

static	MrmCount		regnum = 10;
static	MRMRegisterArg	regvec[] = {
	{"file_cb",		(XtPointer)file_cb},
	{"filesel_cb",		(XtPointer)filesel_cb},
	{"savesel_cb",		(XtPointer)savesel_cb},
	{"edit_cb",		(XtPointer)edit_cb},
	{"view_cb",		(XtPointer)view_cb},
	{"options_cb",		(XtPointer)options_cb},
	{"icon_cb",		(XtPointer)icon_cb},
	{"help_cb",		(XtPointer)help_cb},
	{"exit_cb",		(XtPointer)exit_cb},
	{"env_cb",		(XtPointer)env_cb},
	};

/*========================================================================*
 *  MAIN -- Start of the long and eventfull road !
 *========================================================================*/

int main (int argc, char *argv[])
{
int		a;
Widget		twid, tw;
char		cmd[128];
Arg		args[10];
XmRendition	rend[10];
XmRenderTable	rt;
char		*ep;

    bbs_path[0] = 0;

    MrmInitialize ();

    topinit (argc, argv);
    
    if (MrmOpenHierarchy (1, Lvec, NULL, &s_MrmHierarchy) != MrmSUCCESS) {
	perror ("problem opening the widget Hierarchy");
	exit (1);
	}

    if (MrmRegisterNames (regvec, regnum) != MrmSUCCESS) {
	perror ("problem registering callbacks");
	exit (1);
	}
    mainw = (Widget)NULL;
    if (MrmFetchWidget (s_MrmHierarchy, "mainw", toplevel, &mainw,
					    &class) != MrmSUCCESS) {
	perror ("problem fetching interface");
	exit (1);
	}

    env_dialog = (Widget)NULL;
    if (MrmFetchWidget (s_MrmHierarchy, "env_dialog", mainw,
                        &env_dialog, &class) != MrmSUCCESS) {
        perror ("Can't feach environment header dialog");
        exit (1);
        }

    lp_text = tree_widget (env_dialog, "lp_text", "");
    spell_text = tree_widget (env_dialog, "spell_text", "");
    xedit_text = tree_widget (env_dialog, "xedit_text", "");
    tagpath_text = tree_widget (env_dialog, "tagpath_text", "");
    ansiv_text = tree_widget (env_dialog, "ansiv_text", "");
    zip_text = tree_widget (env_dialog, "zip_text", "");
    unzip_text = tree_widget (env_dialog, "unzip_text", "");

    XtManageChild (mainw);

    if (MrmFetchWidget (s_MrmHierarchy, "filesel", toplevel, &filesel,
						&class) != MrmSUCCESS) {
	perror ("can't fetch file selection dialog");
	exit (1);
	}

    if (MrmFetchWidget (s_MrmHierarchy, "savesel", toplevel, &savesel,
						&class) != MrmSUCCESS) {
	perror ("can't fetch file selection dialog");
	exit (1);
	}

    XtRealizeWidget (toplevel);

    set_title ("X11-QMR 1.5");

    control_box = tree_widget (mainw, "work_form", "control_box", "");

    econtrol_box = tree_widget (mainw, "work_form", "econtrol_box", "");

    news_box = tree_widget (mainw, "work_form", "news_box", "");

    nmsg_pb = tree_widget (control_box, "control_rc", "nmsg_pb", "");

    drep_pb = tree_widget (control_box, "control_rc", "drep_pb", "");

    bconf_pb = tree_widget (control_box, "control_rc", "bconf_pb", "");

    twid = tree_widget (mainw, "work_form", "message_box", "");
    XtSetArg (args[0], XmNuserData, &msg_text);
    XtGetValues (twid, args, 1);

    if (msg_text == NULL) {
	perror ("Cant get msg_txt");
	exit (1);
	}

    to_lab = tree_widget (mainw, "work_form", "header_box", "to_lab", "");

    from_lab = tree_widget (mainw, "work_form", "header_box", "from_lab", "");

    subject_lab = tree_widget (mainw, "work_form", "header_box",
							"subject_lab", "");

    date_lab = tree_widget (mainw, "work_form", "header_box", "date_lab", "");

    conf_lab = tree_widget (mainw, "work_form", "header_box", "conf_lab", "");

    msgno_lab = tree_widget (mainw, "work_form", "header_box", "msgno_lab", "");

    read_qmr_config ();

    twid = tree_widget (mainw, "main_menu_bar", "to_options", "");
    XtSetArg (args[0], XmNsubMenuId, &tw);
    XtGetValues (twid, args, 1);

    twid = tree_widget (tw, "auto_sig_tb", "");
    XtSetArg (args[0], XmNset, &auto_sig_flg);
    XtGetValues (twid, args, 1);

    twid = tree_widget (tw, "random_tag_tb", "");
    XtSetArg (args[0], XmNset, &random_tag_flg);
    XtGetValues (twid, args, 1);

    twid = tree_widget (tw, "justify_tb", "");
    XtSetArg (args[0], XmNset, &justify_flg);
    XtGetValues (twid, args, 1);

    twid = tree_widget (tw, "nnews_tb", "");
    XtSetArg (args[0], XmNset, &nnews_flg);
    XtGetValues (twid, args, 1);

    init_help (toplevel, "X11-QMR Help", "/usr/lib/X11/help/X11-QMR/qmr.help");

    XtAppMainLoop (app_context);
     
    return 0;		/* Happy Ansi */
}


/*========================================================================*
 * EXIT_CB -- Exit button call back, test for data changed etc
 *========================================================================*/

void exit_cb (void)
{
char	defname[128];

    if (reply_cnt)
	pack_replies ();

    exit (0);
}

/*========================================================================*
 * SET_SAVE_NAME -- Display current save file name
 *========================================================================*/

void set_title (char *name)
{
char	*n;
Display	*d;
Window	w;

    d = XtDisplayOfObject (mainw);
    w = XtWindowOfObject (toplevel);
    XStoreName (d, w, name);
}


/*========================================================================*
 * TOPINIT -- Initialize the top level hirachy
 *========================================================================*/

void topinit (int argc, char **argv)
{
char    *aname;

    if (disp) {
	XtWarning ("topinit already called\n");
	return;
	}

    aname = strrchr (argv[0], '/');
    if (aname == NULL)
	aname = argv[0];
    else
	aname++;

    XtToolkitInitialize();

    app_context = XtCreateApplicationContext();
    disp = XtOpenDisplay(app_context, NULL, aname, "X11-QMR", NULL, 0,
	   &argc, argv);

    toplevel = XtAppCreateShell (aname, "TSOFT", applicationShellWidgetClass,
	disp, NULL, 0);

    context_cur = XCreateFontCursor (disp, XC_question_arrow);
}


/*========================================================================*
 * FILE_TO_MSG -- Place contents of file in the message text widget
 *========================================================================*/

file_to_msg (char *fname, int eflag)
{
FILE		*fp;
char		*msgbuf;
char		ebuf[256];
struct stat	st;
int		a, c;

    if (stat (fname, &st) == -1) {
	if (!eflag) {
	    sprintf (ebuf, "Notice: %s no such news flash", fname);
	    XmTextSetString (msg_text, ebuf);
	    return;
	    }
	sprintf (ebuf, "Error: %s\n       %s", fname, strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	return;
	}

    if ((fp = fopen (fname, "r")) == NULL) {
	if (!eflag)
	    return;
	sprintf (ebuf, "Error: %s\n       %s", fname, strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	return;
	}

    strcpy (last_dmsg, fname);

    if ((msgbuf = calloc (st.st_size + 1, 1)) == NULL) {
	sprintf (ebuf, "Error: %s", strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	fclose (fp);
	return;
	}

    a = 0;
    for (;;) {
	if ((c = fgetc (fp)) == 0x0d)
	    continue;
	if (c == -1)
	    break;
	msgbuf[a++] = c;
	}

    fclose (fp);

    XmTextSetString (msg_text, msgbuf);
    free (msgbuf);
}


/*========================================================================*
 * FILE_CB -- File "open" callback, manage file selection dialog
 *========================================================================*/

void file_cb (Widget w, int *op)
{
    XtManageChild (filesel);
}


/*========================================================================*
 * FILESEL_CB -- File selection buttons callback/dialog
 *========================================================================*/

void filesel_cb (Widget w, int *tag, XmFileSelectionBoxCallbackStruct *cbd)
{
Arg             args[2];
char            *fname = NULL;
char            tbuf[256];
struct	stat	sbd, sbp;
int		st;

    if (*tag == 2) {    /* HELP button hehe, RTFM ! */
        return;
        }

    XtUnmanageChild (filesel);

    XtUnmanageChild (control_box);
    XtManageChild (news_box);

    if (*tag == 0) {    /* OK button */
	if (reply_cnt)
	    pack_replies ();
	reply_cnt = 0;

	XmStringGetLtoR (cbd->value, XmSTRING_DEFAULT_CHARSET, &fname);
	update_app (app_context);
	make_bbs_path (fname);
	news_flash = 0;
	strcpy (pktfname, bbs_path);
	strcat (pktfname, "/control.dat");
	st = stat (pktfname, &sbd);
	strcpy (pktfname, fname);
	stat (pktfname, &sbp);

	XFree (fname);

	if (st) 	/* Its a new one */
	    file_query_ret (1);
	else {
	    if (sbd.st_ctime >= sbp.st_ctime)
		sprintf (tbuf, "Import QWK packet is older than existing"
			" data\nReplace Existing Data");
	    else
		sprintf (tbuf, "Replace Existing data with newer Imported"
			" QWK packet");
	    
	    query_dialog (tbuf, "YES", "NO", "", file_query_ret);
	    }
	}
}

/*========================================================================*
 * FILE_QUERY_RET -- Replace data query dialog callback
 *========================================================================*/

static void file_query_ret (int key)
{
int	op = 12;	/* News flash */

    unpack_qwk (pktfname, key == 1 ? 1 : 0);

    icon_cb (0, &op);	/* Show stats */
}


/*========================================================================*
 * TRASH_QUERY_RET -- Trash reply query dialog callback
 *========================================================================*/

static void trash_query_ret (int key)
{
Arg	args[2];

    if (key != 1)		/* NOT YES */
	return;

    XtUnmanageChild (econtrol_box);
    XtManageChild (control_box);
    XtSetArg (args[0], XmNcolumns, 80);
    XtSetArg (args[1], XmNeditable, 0);
    XtSetValues (msg_text, args, 2);
    file_to_msg (last_dmsg, 1);
    display_header (&extr_hdr);
}

/*========================================================================*
 * DEL9000_QUERY_RET -- Query deletion of reply from message base
 *========================================================================*/

static void del9000_query_ret (int key)
{
Arg	args[2];

    if (key != 1)		/* NO */
	return;

    delete_msg ();
    conf_9000_to_rep ();

    if (reply_cnt)
	reply_cnt--;

    if (cur_msg > reply_cnt - 1)
	cur_msg = reply_cnt - 1;

    extract_msg (cur_msg);
}

/*========================================================================*
 * DO_SAVE_CB -- Do (or not) the actual file save
 *========================================================================*/

static char do_save_name[256];

void do_save_cb (int but)
{
FILE	*fp;
char	ebuf[256];
char	*src;

    if (but == 3)	/* Cancel */
	return;

    if (but == 1)
	fp = fopen (do_save_name, "w");
    else
	fp = fopen (do_save_name, "a");

    if (fp == NULL) {
	sprintf (ebuf, "Error: %s\n       %s", do_save_name, strerror (errno));
	error_dialog (ebuf, "OK", "", "", NULL);
	}
    else {
	src = XmTextGetString (msg_text);
	fwrite (src, strlen (src), 1, fp);
	fclose (fp);
	XtFree (src);
	}
}

/*========================================================================*
 * SAVESEL_CB -- File selection buttons callback/dialog for save to disk
 *========================================================================*/

void savesel_cb (Widget w, int *tag, XmFileSelectionBoxCallbackStruct *cbd)
{
int		a;
Arg             args[2];
char            *fname = NULL;
char            ebuf[256];
FILE		*fp;
struct stat	st;

    if (*tag == 2) {    /* HELP button */
        return;
        }

    XtUnmanageChild (savesel);

    if (*tag == 0) {    /* OK button */
	XmStringGetLtoR (cbd->value, XmSTRING_DEFAULT_CHARSET, &fname);
	strcpy (do_save_name, fname);
	if (stat (fname, &st) != -1) {	/* File exists */
	    sprintf (ebuf, "%s exists", fname);
	    query_dialog (ebuf, "OVERWRITE", "APPEND", "CANCEL", do_save_cb);
	    }
	else
	    do_save_cb (1);

	XFree (fname);
	}
}


/*========================================================================*
 * EDIT_CB -- Edit menu callback, *op == what to do
 *========================================================================*/

void edit_cb (Widget w, int *op)
{
XmString	xms;

    if (*op == 0)
	edit_tagline ();
    else {
	XmTextSetString (lp_text, bbs_printcmd);
	XmTextSetString (spell_text, bbs_spellcmd);
	XmTextSetString (xedit_text, bbs_xeditcmd);
	XmTextSetString (tagpath_text, bbs_tagfile);
	XmTextSetString (ansiv_text, bbs_ansicmd);
	XmTextSetString (zip_text, bbs_zipcmd);
	XmTextSetString (unzip_text, bbs_unzipcmd);
	XtManageChild (env_dialog);
	}
}

/*========================================================================*
 * VIEW_CB View menu callback, *op == what to view
 *========================================================================*/

void view_cb (Widget w, int *op)
{
XmString	xms;

    if (*op == 0)
	view_conf_sel ();
    else
	view_msg_sel ();
}

/*========================================================================*
 * OPTIONS_CB -- Options menu callback, read toggle button "w"
 *========================================================================*/

void options_cb (Widget w, int *op)
{
    if (*op == 0) {
	conf_skip_flg = XmToggleButtonGetState (w);

	if (conf_sel != NULL)
	    if (XtIsManaged (conf_sel)) {
		view_conf_sel ();
		}
	}
    else if (*op == 1)
	auto_sig_flg = XmToggleButtonGetState (w);

    else if (*op == 2)
	random_tag_flg = XmToggleButtonGetState (w);

    else if (*op == 3)
	justify_flg = XmToggleButtonGetState (w);

    else if (*op == 4)
	nnews_flg = XmToggleButtonGetState (w);

    else if (*op == 4) {	/* Add this conf */
	if (XtIsManaged (econtrol_box)) {
	    error_dialog ("Can't DROP conference while editing message",
		"OK", "", "", NULL);
	    return;
	    }
	add_conf (++reply_cnt);
	}

    else if (*op == 5) {	/* Drop this conf */
	if (XtIsManaged (econtrol_box)) {
	    error_dialog ("Can't DROP conference while editing message",
		"OK", "", "", NULL);
	    return;
	    }
	drop_conf (++reply_cnt);
	}
}

/*========================================================================*
 * ICON_CB -- Main callback for all ICON push buttons, all modes
 *========================================================================*/

void icon_cb (Widget w, int *op)
{
int		a;
Arg		args[2];
static		p = 0;
char		fname[256];
struct stat	st;

    if (bbs_path[0] == 0) {
	error_dialog ("No Active BBS", "OK", "", "", NULL);
	return;
	}

    switch (*op) {
	case 0 :		/* Prev conf */
	    if (prev_conf () == 0) {
		bconf_pb = w;
		XtSetArg (args[0], XmNsensitive, 0);
		XtSetValues (w, args, 1);
		}
	    else {
		XtSetArg (args[0], XmNsensitive, 1);
		XtSetValues (w, args, 1);
		}
	    if (fconf_pb != NULL) {
		XtSetArg (args[0], XmNsensitive, 1);
		XtSetValues (fconf_pb, args, 1);
		fconf_pb = NULL;
		}
	    if (fmsg_pb != NULL) {
		XtSetArg (args[0], XmNsensitive, 1);
		XtSetValues (fmsg_pb, args, 1);
		fmsg_pb = NULL;
		}
	    if (bmsg_pb != NULL) {
		XtSetArg (args[0], XmNsensitive, 1);
		XtSetValues (bmsg_pb, args, 1);
		bmsg_pb = NULL;
		}
	    if (XtIsManaged (drep_pb)) {
		XtUnmanageChild (drep_pb);
		XtManageChild (nmsg_pb);
		}
	    break;

	case 1 :		/* Next conf */
	    if (next_conf () == 0) {
		fconf_pb = w;
		XtSetArg (args[0], XmNsensitive, 0);
		XtSetValues (w, args, 1);
		XtUnmanageChild (nmsg_pb);
		XtManageChild (drep_pb);
		}
	    else {
		XtSetArg (args[0], XmNsensitive, 1);
		XtSetValues (w, args, 1);
		}
	    if (bconf_pb != NULL) {
		XtSetArg (args[0], XmNsensitive, 1);
		XtSetValues (bconf_pb, args, 1);
		bconf_pb = NULL;
		}
	    if (fmsg_pb != NULL) {
		XtSetArg (args[0], XmNsensitive, 1);
		XtSetValues (fmsg_pb, args, 1);
		fmsg_pb = NULL;
		}
	    if (bmsg_pb != NULL) {
		XtSetArg (args[0], XmNsensitive, 1);
		XtSetValues (bmsg_pb, args, 1);
		bmsg_pb = NULL;
		}
	    break;

	case 2 :		/* Prev msg */
	    if (prev_message () == 0) {
		bmsg_pb = w;
		XtSetArg (args[0], XmNsensitive, 0);
		XtSetValues (w, args, 1);
		}
	    else {
		bmsg_pb = NULL;
		XtSetArg (args[0], XmNsensitive, 1);
		XtSetValues (w, args, 1);
		}
	    if (fmsg_pb != NULL) {
		XtSetArg (args[0], XmNsensitive, 1);
		XtSetValues (fmsg_pb, args, 1);
		fmsg_pb = NULL;
		}
	    break;

	case 3 :		/* Next msg */
	    if (next_message () == 0) {
		fmsg_pb = w;
		XtSetArg (args[0], XmNsensitive, 0);
		XtSetValues (w, args, 1);
		}
	    else {
		fmsg_pb = NULL;
		XtSetArg (args[0], XmNsensitive, 1);
		XtSetValues (w, args, 1);
		}
	    if (bmsg_pb != NULL) {
		XtSetArg (args[0], XmNsensitive, 1);
		XtSetValues (bmsg_pb, args, 1);
		bmsg_pb = NULL;
		}
	    break;

	case 4 :				/* Reply to Message */
	    XtManageChild (econtrol_box);
	    XtUnmanageChild (control_box);
	    XtSetArg (args[0], XmNcolumns, 72);
	    XtSetArg (args[1], XmNeditable, 1);
	    XtSetValues (msg_text, args, 2);
	    reply_to_msg (reply_cnt + 1);
	    break;

	case 5 :				/* New Message */
	    XtManageChild (econtrol_box);
	    XtUnmanageChild (control_box);
	    XtSetArg (args[0], XmNcolumns, 72);
	    XtSetArg (args[1], XmNeditable, 1);
	    XtSetValues (msg_text, args, 2);
	    new_msg (reply_cnt + 1);
	    break;

	case 6 :				/* Message to Disk */
	    XtManageChild (savesel);
	    break;

	case 7 :				/* Print message */
	    sprintf (fname, "%s %s/print", bbs_printcmd, bbs_path);
	    if (system (fname) == 0)
		info_dialog ("Message Printed", "OK", "", "", NULL);
	    else
		error_dialog ("Problem Printing", "OK", "", "", NULL);
	    break;

	case 8 :				/* Save reply */
	    mail_reply_msg (++reply_cnt);
	    XtUnmanageChild (econtrol_box);
	    XtManageChild (control_box);
	    XtSetArg (args[0], XmNcolumns, 80);
	    XtSetArg (args[1], XmNeditable, 0);
	    XtSetValues (msg_text, args, 2);

	    if (cur_conf != 9000) {
		file_to_msg (last_dmsg, 1);
		display_header (&extr_hdr);
		}
	    break;

	case 9 :				/* Trash reply */
	    query_dialog ("Trash your editing ?", "YES", "NO", "",
			   trash_query_ret);
	    break;

	case 10 :				/* Spell Check reply */
	    spell_check_reply ();
	    break;

	case 11 :				/* Edit header */
	    edit_reply_header ();
	    break;

	case 13 :				/* External editor */
	    ext_edit_reply ();
	    break;

	case 14 :				/* format reply */
	    a = justify_flg;
	    justify_flg = 1;
	    format_reply ();
	    justify_flg = a;
	    break;

	case 15 :
	    query_dialog ("Delete this reply from message base ?",
			  "YES", "NO", "", del9000_query_ret);
	    break;

	case 16 :
	    ansi_view ("work");		/* View a message */
	    break;

	case 17 :
	    ansi_view (bbs_news[last_news_flash]);
	    break;
	}

    if (*op == 12) {		/* This might look strange, but qmr allways */
	if (news_flash < 10) {	/* inserts news flash 0 (the stats) */
	    sprintf (fname, "%s/%s", bbs_path, bbs_news[news_flash]);
	    file_to_msg (fname, 0);
	    last_news_flash = news_flash;
	    news_flash++;
	    while (news_flash < 10) {
		if (bbs_news[news_flash][0] == 0) {
		    news_flash = 10;
		    break;
		    }

		sprintf (fname, "%s/%s", bbs_path, bbs_news[news_flash]);
		if (stat (fname, &st) != -1)
		    break;
		news_flash++;
		}
	    }
	else {
	    XtManageChild (control_box);
	    XtUnmanageChild (news_box);
	    next_conf ();
	    }
	return;
	}
}


/*========================================================================*
 * HELP_CB -- Display the help message in the info dialog
 *========================================================================*/

void help_cb (Widget w, int *opp)
{
Widget	cw;
char	tmp[256];

    switch (*opp) {
	case 0 :
	    help_goto_ref ("qmr.help#Overview", "Overview");
	    break;

	case 1 :
	    help_goto_ref ("qmr.help#toc", "Table of Contents");
	    break;

	case 2 :
	    help_goto_ref ("qmr.help#GetStart", "Getting Started");
	    break;

	case 3 :
	    strcpy (tmp, "qmr.help#");
	    if ((cw = XmTrackingLocate (mainw, context_cur, 0)) == 0) {
		error_dialog ("Context help on application only",
					     "OK", "", "", NULL);
		return;
		}

	    if (cw->core.name == NULL) {
		error_dialog ("No help avalable on selected item",
					     "OK", "", "", NULL);
		return;
		}
printf ("Widget \"%s\"\n", cw->core.name);
	    strcat (tmp, cw->core.name);
	    help_goto_ref (tmp, "context");
	    break;

	case 4 :
	    help_goto_ref ("qmr.help#help", "Using Help");
	    break;

	case 5 :
	    info_dialog (about_msg, "OK", "", "", NULL);
	    return;
	
	default :
	    help_goto_ref (NULL, NULL);
	}
}


/*========================================================================*
 * SET_HEADER_DISPLAY -- Fill in the fields in the header info box
 *========================================================================*/

set_header_display (char *to, char *from, char *sub, time_t date,
		 char *conf, int msgno, int cmsgno, int tmsg, int rdf)
{
Arg		args[1];
XmString	xms;
char		tbuf[80];
struct tm	*tm;

    if (strcmp (to, bbs_user) == 0) {
	fputc (7, stderr);
	fputc (7, stderr);
	}

    sprintf (tbuf, "TO: %s", to);

    xms = XmStringCreateSimple (tbuf);

    XtSetArg (args[0], XmNlabelString, xms);
    XtSetValues (to_lab, args, 1);
    XmStringFree (xms);

    sprintf (tbuf, "FROM: %s", from);

    xms = XmStringCreateSimple (tbuf);

    XtSetArg (args[0], XmNlabelString, xms);
    XtSetValues (from_lab, args, 1);
    XmStringFree (xms);

    sprintf (tbuf, "SUBJECT: %s", sub);

    xms = XmStringCreateSimple (tbuf);

    XtSetArg (args[0], XmNlabelString, xms);
    XtSetValues (subject_lab, args, 1);
    XmStringFree (xms);

    tm = localtime (&date);
    sprintf (tbuf, "DATE: %s", asctime (tm));
    tbuf[strlen (tbuf) - 1] = 0;

    xms = XmStringCreateSimple (tbuf);

    XtSetArg (args[0], XmNlabelString, xms);
    XtSetValues (date_lab, args, 1);
    XmStringFree (xms);

    sprintf (tbuf, "CONF: %s", conf);

    xms = XmStringCreateSimple (tbuf);

    XtSetArg (args[0], XmNlabelString, xms);
    XtSetValues (conf_lab, args, 1);
    XmStringFree (xms);

    sprintf (tbuf, "MSG#: %d [%d/%d]  READ (%c)", msgno, 
				cmsgno, tmsg, rdf ? 'Y' : 'N');

    xms = XmStringCreateSimple (tbuf);

    XtSetArg (args[0], XmNlabelString, xms);
    XtSetValues (msgno_lab, args, 1);
    XmStringFree (xms);
}

/*========================================================================*
 * POP_HEAD_DIALOG -- Create if needed, and manage the header dialog
 *========================================================================*/

void pop_head_dialog (char *subj, char *to, char *from, int pvt)
{
static Widget	head_dialog = NULL;
Widget		head_OK;
Widget		status_radio, twid;
int		a;
Arg		args[5];
XmString	xms;

    if (head_dialog == NULL) {	/* Create it */
	xms = XmStringCreateSimple ("Message Header");

	a = 0;
	XtSetArg (args[a], XmNdialogTitle, xms); a++;
	XtSetArg (args[a], XmNdialogStyle, XmDIALOG_MODELESS); a++;
	XtSetArg (args[a], XmNdefaultButton, head_OK); a++;
	head_dialog = XmCreateFormDialog (mainw, "head_dialog", args, a);
	XmStringFree (xms);

	status_radio = XtVaCreateManagedWidget ("status_radio",
		xmRowColumnWidgetClass, head_dialog,
		XmNtopAttachment, XmATTACH_FORM,
		XmNtopOffset, 2,
		XmNleftOffset, 2,
		XmNpacking, XmPACK_COLUMN,
		XmNnumColumns, 2,
		XmNradioBehavior, XmNradioAlwaysOne,
		NULL);

	xms = XmStringCreateSimple ("Private");
	pvt_tb = XtVaCreateManagedWidget ("pvt_tb",
	 	xmToggleButtonWidgetClass, status_radio,
	 	XmNlabelString, xms,
	 	XmNset, False,
	 	NULL);

	XmStringFree (xms);

	xms = XmStringCreateSimple ("Public");
	pub_tb = XtVaCreateManagedWidget ("pub_tb",
	 	xmToggleButtonWidgetClass, status_radio,
	 	XmNlabelString, xms,
	 	XmNset, True,
	 	NULL);

	XmStringFree (xms);

	xms = XmStringCreateSimple ("Subject:");
	twid = XtVaCreateManagedWidget ("head_label",
		xmLabelWidgetClass, head_dialog,
		XmNleftAttachment, XmATTACH_FORM, 
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, status_radio,
		XmNtopOffset, 8,
		XmNleftOffset, 2,
		XmNlabelString, xms,
		NULL);

	XmStringFree (xms);

	head_subj_text = XtVaCreateManagedWidget ("subj_text",
		xmTextWidgetClass, head_dialog,
		XmNleftAttachment, XmATTACH_WIDGET, 
		XmNleftWidget, twid,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, status_radio,
		XmNrightAttachment, XmATTACH_FORM,
		XmNrightOffset, 2,
		XmNeditMode, XmSINGLE_LINE_EDIT,
		NULL);

	xms = XmStringCreateSimple ("To:");
	twid = XtVaCreateManagedWidget ("to_label",
		xmLabelWidgetClass, head_dialog,
		XmNleftAttachment, XmATTACH_FORM, 
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, head_subj_text,
		XmNlabelString, xms,
		NULL);

	XmStringFree (xms);

	head_to_combo = XtVaCreateManagedWidget ("to_combobox",
		xmComboBoxWidgetClass, head_dialog,
		XmNleftAttachment, XmATTACH_FORM, 
		XmNrightAttachment, XmATTACH_FORM,
		XmNrightOffset, 2,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, twid,
		XmNcomboBoxType, XmDROP_DOWN_COMBO_BOX,
		XmNvisibleItemCount, 2,
		NULL);

	twid = XtVaCreateManagedWidget ("separator",
		xmSeparatorWidgetClass, head_dialog,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, head_to_combo,
		XmNleftAttachment, XmATTACH_FORM,
		XmNrightAttachment, XmATTACH_FORM,
		NULL);

	xms = XmStringCreateSimple ("OK");
	head_OK = XtVaCreateManagedWidget ("head_OK",
		xmPushButtonWidgetClass, head_dialog,
		XmNshowAsDefault, True,
		XmNtopAttachment, XmATTACH_WIDGET,
		XmNtopWidget, twid,
		XmNbottomAttachment, XmATTACH_FORM,
		XmNbottomOffset, 8,
		XmNtopOffset, 8,
		XmNwidth, 60,
		XmNleftOffset, -30,
		XmNleftAttachment, XmATTACH_POSITION,
		XmNleftPosition, 50,
		XmNlabelString, xms,
		XmNcomboBoxType, XmDROP_DOWN_COMBO_BOX,
		NULL);

	XmStringFree (xms);

	XtAddCallback (head_OK, XmNactivateCallback,
		(XtCallbackProc)head_edit_cb, NULL);
	}
 
    if (pvt)
	XmToggleButtonSetState (pvt_tb, True, True);
    else
	XmToggleButtonSetState (pub_tb, True, True);

    XmTextSetString (head_subj_text, subj);

    XmComboBoxDeleteAllItems (head_to_combo);

    xms = XmStringCreateSimple (to);
    XmComboBoxAddItem (head_to_combo, xms, 0);
    XmStringFree (xms);

    xms = XmStringCreateSimple (from);
    XmComboBoxAddItem (head_to_combo, xms, 0);
    XmStringFree (xms);

    XmComboBoxSelectPos (head_to_combo, 0, False);

    XtManageChild (head_dialog);
}

/*========================================================================*
 * $Log: qmr.c,v $
 * Revision 1.7  1995/05/19  12:26:33  ross
 * Added new help system and now useses Motif 2.0 ComboBox
 *
 * Revision 1.6  1994/12/20  01:01:07  ross
 * Added News mode stuff, and [n/n] message counter to set_header
 *
 * Revision 1.5  1994/12/06  00:39:02  ross
 * Corrected version number
 *
 * Revision 1.4  1994/12/06  00:33:53  ross
 * Added code to now use environment settings for (un)zip
 *
 * Revision 1.3  1994/09/29  13:02:36  ross
 * Fixed processing of message and conf selection lists.
 * Added query dialogs for message save for append, overwrite or cancel
 * Added icon callbacks for editing of replies.
 * Fix all known BUGS :) and any that cropped up along the way.
 *
 * Revision 1.2  1994/09/13  09:38:42  ross
 * Added query dialog to trash reply icon callback
 * Also set width of text to 72, but this is not used :)
 * Added the options for ADD, DROP, AUTO SIG, and RANDOM Taglines to
 * the options callback
 *
 * Revision 1.1  1994/07/24  17:49:21  ross
 * Initial revision
 *
 *========================================================================*/
