/*========================================================================*
 * TITLE:	Ansi File View for X11-QMR
 * MODULE:	aview.c
 * BY:		Ross C Linder (c) 1994
 *
 * X11-QMR is Copyright (c) 1994 of Ross C Linder. X11-QMR is not public
 * domain. Permission is granted to use and distribute X11-QMR freely.
 * 
 * The only restriction is that you do not attempt to prevent others from
 * having free access to the source.
 *
 * NOTE: This simply read a file outputting the chars to the tty, it
 * then waits for a <CR> before returning. This allows us to say ..
 * color_xterm -e aview ansi_file
 * The window will remain displaying the file.
 *========================================================================*/

#include <stdio.h>

main (int argc, char *argv[])
{
int	c;
FILE	*fp;

    if (argc != 2) {
	fprintf (stderr, "Usage: %s ansi_file\n", argv[0]);
	exit (1);
	}

    if ((fp = fopen (argv[1], "r")) == NULL) {
	perror (argv[1]);
	exit (1);
	}

    while ((c = getc (fp)) != -1)
	putchar (c);

    fclose (fp);
    getchar ();
}
