/*
 * NAME
 *   GetListOfGroups.c
 * USAGE
 *   Usage: GetListOfGroups
 * DESCRIPTION
 *   Retrieve the list of valid newsgroups from the news server.
 * OUTPUT
 *   The list of newsgroups is printed on standard output, one group per line.
 * COPYRIGHT
 *   Skim - Off-line news reading package optimized for slow lines.
 *   Copyright (C) 1995  Rene W.J. Pijlman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 * 
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * VERSION
 *   Skim version 0.6.
 */

#include <unistd.h>
#include <string.h>

#include "Skim.h"

FILE_ID("/home/rene/sys/CVS_MasterSourceRepository/skim/GetListOfGroups.c,v 1.9 1995/08/15 19:33:34 rpijlman Exp");

int main( int argc, char * argv[] )
{
    FILE * NewsServer;

    if ( argc != 1 )
    {
        fprintf( stderr, "%s\n",
                 "Usage: GetListOfGroups" );
        exit( EXIT_FAILURE );
    }

    NewsServer = NNTPStreamOpen();

    if ( fprintf( NewsServer, "list\r\n" ) == EOF ||
         fflush( NewsServer ) == EOF )
    {
        fprintf( stderr, "Error writing to NewsServer.\n" );
        exit( EXIT_FAILURE );
    }
    CheckStatusResponse( NewsServer, argv[1], "215" );

    /* Write the article in a file. */
    TextResponseToFile( NewsServer, stdout );

    NNTPStreamClose( NewsServer );

    return EXIT_SUCCESS;
}
