/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_TYPES
#define IS_FCNTL
#define IS_STDIO
#define IS_UNISTD
#define IS_SIGNAL
#define IS_STRING
#define IS_ERRNO

#include "config.h"
#include "includes.h"
#include "mailflags.h"
#include "prototypes.h"


void signaldaemon(char *home, char *daemon_name, long flags){
  int  process;
  char daemon[LINESIZE], *command=daemon;
  FILE *fd;

#ifdef DEBUG
  fprintf(fstdio[1],"Opening daemon %s\n",daemon_name);
  fflush(fstdio[1]);
#endif

  if(QUEUEDIR[0] == '~')
    sprintf(daemon,"%s%s/%s.%s",home,&QUEUEDIR[1],daemon_name,PID_EXT);
  else
    sprintf(daemon,"%s/%s.%s",QUEUEDIR,daemon_name,PID_EXT);
  fd = fopen(daemon,"r");
#ifdef DEBUG
  fprintf(fstdio[1],"daemon %s\n",daemon);
#endif
  if(fd!=NULL)
    if(!fscanf(fd,"%d",&process)){
      unlink(daemon);
      fprintf(fstdio[2],"Scan of %s failed",daemon);
    }else{
      int  pid;
      if(kill(process,SIGCONT)!=0){
        fprintf(fstdio[2],"Attempt to signal %d failed %d\n",process,errno);
	unlink(daemon);
        kill(process,SIGKILL);
        if(!(pid=fork())){
          char *s,*t,path[LINESIZE];
/* I'll need to pass a PATH to daemon, and use it for hashing. */
          t=PATH;
          sprintf(path,"PATH=%s",t);
          for(s=index(path,'~');s!=NULL;s=index(++s,'~')){
            if((t=index(t,'~'))==NULL) break;
            if(*(s-1)==':'||*(s-1)=='=')
              sprintf(s,"%s%s",home,++t);
            else
              t++; 
          };

          if((command=hash(index(path,'=')+1,"daemon"))!=NULL){
            putenv(path);
            fprintf(fstdio[2],"Using %s from %s\n",command,path);
#ifdef USE_TERM
            if((flags&MF_FORTERM)!=0)
              execl(command,command,"-t",(char *) 0);
#endif
            if((flags&MF_OUTGOING)!=0)
              execl(command,command,"-o",(char *) 0);
            else
              execl(command,command,"-n",daemon_name,(char *) 0);
          }else{
	    fprintf(fstdio[2],"Can't hash daemon in %s",index(path,'=')+1);
          };
          exit(-1);
        }else if(pid==-1){
          fprintf(fstdio[2],"Fork failed\n");
        };
      };
    };
}

