/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_TYPES
#define IS_STDIO
#define IS_UNISTD
#define IS_STRING
#define IS_STAT

#include "config.h"
#include "includes.h"
#include "readline.h"
#include "prototypes.h"

int parseheader(struct BFILE *input,char *from,char *reply,char *to,
  char **subject,int *hops){

  static char b[LINESIZE];
  int i,j,n,mfrom=0,msubject=0,mto=0;
  char *s, *t;

  int nsubjects=0, hopcount=0;

  if(from!=NULL)
    from[0]='\0';

  if(reply!=NULL)
    reply[0]='\0';
  else
    mfrom=NFROM_FIELDS+1;

  if(to!=NULL)
    to[0]='\0';
  else
    mto=NTO_FIELDS+1;

  if(subject==NULL)
    msubject=NSUBJECT_FIELDS+1;

  for(n=0;n<SAVEDLINES &&!readline(input,n);n++){
    static char *From_field[NFROM_FIELDS]={ FROM_FIELDS };
    static char *To_field[NTO_FIELDS]={ TO_FIELDS };
    static char *Subject_field[NSUBJECT_FIELDS]={ SUBJECT_FIELDS };
    int header=1,nsubject_fields=NSUBJECT_FIELDS;

    if(!index(input->line,'\n')) continue;

/* I allow the subject line to be in the body of the message,
 * excluding XCOMMAND.
 */

    if(!header){
      if(msubject>nsubject_fields) break;
    }else if(!strcmp(input->line,"\n")){
      mfrom=NFROM_FIELDS+1;
      mto=NTO_FIELDS+1;
      nsubject_fields--;
      header=0;
      continue;
    };

/* Find who the message was from, and who to reply to */

    for(j=mfrom;j<NFROM_FIELDS;j++)
      if(!strncasecmp(input->line,From_field[j],strlen(From_field[j]))){

      s=index(input->line,'<');
      if(s==NULL)
        s=index(input->line,' ');
      if(s==NULL) continue;
      s=parseaddress(s,&t);

      if(reply[0]!='\0')if(!strcasecmp(reply,s)) break;
      strcpy(reply,s);
      if(j<2 && from!=NULL) strcpy(from,reply);
      mfrom=j+1;
      break;
    };
    if(j<NFROM_FIELDS) continue;

/* Find who the message was addressed to */

    for(j=mto;j<NTO_FIELDS;j++)
      if(!strncasecmp(input->line,To_field[j],strlen(To_field[j]))){
      s=index(input->line,' ');
      if(s==NULL) continue;
      while(index(FS "()",*s)!=NULL)s++;
      if(to[0]!='\0' && strlen(s)>0) strcat(to,",");
      strcat(to,s);
      if((s=index(to,'\n'))!=NULL) *s='\0';
      break;
    };
    if(j<NTO_FIELDS) continue;

/* Find the subject of the message */

    for(j=msubject;j<NSUBJECT_FIELDS;j++)
      if(!strncasecmp(input->line,Subject_field[j],strlen(Subject_field[j]))){

      t=b;
      nsubjects=0;
      for(s=input->line+strlen(Subject_field[j]);*s!='\0';s++)
        if(index(FS,*s)==NULL){

        subject[nsubjects++]=t;
        while(index(FS,*s)==NULL){
          if(*s != '-')
            *t++ = tolower(*s);
          else
            *t++ = '/';
          if(*++s=='\0') break;
        };
        *t++ = '\0';
      };
      msubject=j+1;
      if(nsubjects>0 && msubject==NSUBJECT_FIELDS) nsubjects=-nsubjects;
      break;
    };
    if(j<nsubject_fields) continue;

    if(!strcmp(input->line,RECEIVEDBY)) hopcount++;
  };
  if(reply!=NULL){
    if(from!=NULL)
      for(i=0;from[i]!='\0';i++){char c;c=tolower(from[i]);from[i]=c;};
    for(i=0;reply[i]!='\0';i++){char c;c=tolower(reply[i]);reply[i]=c;};
  };
  if(to!=NULL) for(i=0;to[i]!='\0';i++){
    char c;
    c=(index(FS "<()>",to[i])==NULL) ? tolower(to[i]) : ',';
    to[i]=c;
  };

  *hops=hopcount;
  if(reply!=NULL && from!=NULL)
    fprintf(fstdio[1],
      "Message to %s recieved from %s reply %s with a hop count of %d\n",
      to,from,reply,*hops);
  return nsubjects;
}

