/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#define IS_TYPES
#define IS_FCNTL
#define IS_STDIO
#define IS_UNISTD
#define IS_STRING
#define IS_STAT

#include "config.h"
#include "includes.h"

/* Find the executable... */

char *hash(char *path, char *name){
  struct stat file_status;
  static char file[LINESIZE];


  if(index(name,'/')!=NULL || path==NULL){
    strcpy(file,name);
    return file;
  };

  while(path!=NULL){
    file[0]='\0';

    strcat(file,path);
    if(index(path,':')!=NULL){
      path=index(path,':')+1;
      strcpy(index(file,':')+1,name);
      *index(file,':')='/'; 
    }else{
      sprintf(file,"%s/%s",path,name);
      path=NULL;
    }; 

    if(stat(file,&file_status)==-1)continue;
    if( (file_status.st_mode&S_IFREG)!=0
        && (file_status.st_mode&(S_IXUSR|S_IXGRP|S_IXOTH))!=0
      ) return file;
  };
  return NULL;
}

