/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_GETOPT
#define IS_TYPES
#define IS_FCNTL
#define IS_STDIO
#define IS_UNISTD
#define IS_SIGNAL
#define IS_STRING
#define IS_STAT
#define IS_STDLIB

#include "config.h"
#include "includes.h"
#include "prototypes.h"


static char *rmailbox;

int forward(char option,char *mailbox,char *to,char *hostname,char *smtpservice){
  FILE *fdin,*fdout;
  int  i,fdpipe[2];
  char file[LINESIZE];

  sprintf(file,"/tmp/%d",getpid());
  rmailbox=mailbox;

/* Tupload is so slow, I copy input to a /tmp file...  Thus I must
 * keep checking if the a new mailbox has been created....
 */

  i=dup(0);
  close(0);
  fdin=fdopen(i,"r");
  if(fdin!=NULL) do{

    i=umask(0077);
    if((fdout=fopen(file,"w"))!=NULL){
      char buffer[LINESIZE];

/* Copy the mailbox and delete the original.  This seems to help with
   race conditions. */

      while(fgets(buffer,LINESIZE,fdin)!=NULL) fputs(buffer,fdout);
      fclose(fdin);
      freopen(file,"r",fdout);
      unlink(mailbox);
      signal(SIGTERM,forward_abort);
      umask(i);

      switch(option){
#ifdef USE_TERM
        case 't':
          i=termforward(file,to);
          break;
#endif
        case 'f':
          sleep(1);
          i=mailforward(file,to,hostname,smtpservice);
          break;
        default:
          i=-1;
          fprintf(fstdio[2],"Unrecognize forward option '%c'\n",option);
      };
      if(i!=0) {
        forward_quit(fopen(file,"r"));
        if(i<0) exit(i);
        return i;
      }else {
        unlink(file);
        continue;
      };

/* Exit */

    }else{
      umask(i);
      fprintf(fstdio[2],"Opening of %s failed",file);
    };
    return 1;
  }while((fdin=fopen(mailbox,"r"))!=NULL);
  return 0;
}
      
void forward_abort(void){
  FILE *fdin;
  char file[LINESIZE];

  sprintf(file,"/tmp/%d",getpid());
  fprintf(fstdio[2],"%s\n","SIGTERM forwardd");
  if((fdin=fopen(file,"r"))!=NULL){
    unlink(file);
    forward_quit(fdin);
  };
  exit(-1);
}

void forward_quit(FILE *fdin){
  FILE *fdout;
  char buffer[LINESIZE];

  signal(SIGTERM,SIG_IGN);
  fprintf(fstdio[2],"%s\n","Quiting forward");
  if(fdin!=NULL){
    if((fdout=fopen(rmailbox,"w"))!=NULL){
      while(fgets(buffer,LINESIZE,fdin)!=NULL) fputs(buffer,fdout);
      fclose(fdout);
    };
    fclose(fdin);
  };
  signal(SIGTERM,SIG_DFL);
}

