/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_GETOPT
#define IS_TYPES
#define IS_FCNTL
#define IS_STDIO
#define IS_UNISTD
#define IS_SIGNAL
#define IS_STRING
#define IS_STAT
#define IS_STDLIB
#define IS_PWD

#include "config.h"
#include "includes.h"
#include "prototypes.h"


void main(int argc, char *argv[]) {
  int  pid,kill_daemon=0,debug=0,resume=0;
  char c,option=(char) -1;
  char command[LINESIZE],queue[LINESIZE],logfile[LINESIZE];
  char daemon_name[LINESIZE],daemon[LINESIZE],mailbox[LINESIZE];
  char *s,*home,*user,*path,*queuedir=QUEUEDIR,*forward_to,*smtpservice;
  static char *arguments[5]={NULL,NULL,NULL,NULL,NULL};

  close(0);
  fstdioopen();
  arguments[0]=daemon_name;
  command[0]='\0';
  daemon_name[0]='\0';
  forward_to=getenv("GETMAIL_FORWARD");
  smtpservice=getenv("SMTPSERVICE");

/* Get the default daemon name from `basename argv[0] '\.DAEMON_EXT'`
 */

  if(rindex(argv[0],'.')!=NULL)
    if(!strcmp("." DAEMON_EXT,rindex(argv[0],'.'))){
      if(rindex(argv[0],'/')==NULL)
        strcpy(daemon_name,argv[0]);
      else
        strcpy(daemon_name,rindex(argv[0],'/')+1);
      rindex(daemon_name,'.')[0]='\0';
    };
 
 
  while ((c = getopt (argc, argv, "c:e:df:kn:op:q:stvw:")) != EOF)
    switch (c) {
      case 'c':  /* shell command */
        option=c;
        arguments[1]="-c";
	arguments[2]=optarg;
        strcpy(command,SHELL);
        break;
      case 'd':  /* debug */
        debug=1;
        break;
      case 'e':  /* executable command */
        option=c;
        strcpy(command,optarg);
        break;
      case 'f':  /* forward address */
        strcpy(daemon_name,RECEIVE);
        forward_to=optarg;
        break;
      case 'k':  /* kill daemon */
        kill_daemon=1; 
        break;
      case 'n':  /* specify daemon name */
        strcpy(daemon_name,optarg);
        break;
      case 'o':  /* OUTGOING deamon */
        strcpy(daemon_name,OUTGOING);
        option=c;
        break;
      case 'p':  /* SMTP service to use */
        smtpservice=optarg;
        break; 
      case 'q':  /* queue directory */
        queuedir=optarg;
        break;
      case 's':
        resume=1;
        break;
      case 't':
#ifdef USE_TERM
        option=c;
        strcpy(daemon_name,RECEIVE);
        break;
#else
        fprintf(fstdio[2],"Recompile with -DUSE_TERM\n");
        exit(-1);
#endif
      case 'v':
        version();
        exit(0);
      default:
        fprintf(fstdio[2],"Usage: daemon %s\n\t%s\n",
          "[-dkost] [-a alarmtime] [-c command] [-e executable] [-l logfile]",
          "[-n name] [-q directory]");
        exit(1);
    };

  if(!debug){
    close(1);
    fstdioopen();
  };

  if(!daemon_name[0]){
    fprintf(fstdio[2],"Usage: daemon %s\n\t%s\n",
      "[-dkost] [-a alarmtime] [-c command] [-e executable] [-l logfile]",
      "[-n name] [-q directory]");
    exit(1);
  };
  

/* Get username and home directory
 */
  {
    struct passwd *pw;
    pw=getpwuid(getuid());
    home=pw->pw_dir;
    user=pw->pw_name;
  };

/* I want to pass these definitions to the scripts while I'm at it.
 */

  if(MAILBOX [0] == '~')
    sprintf(mailbox,"%s%s",home,&MAILBOX[1]);
  else
    sprintf(mailbox,"%s/%s",MAILBOX,user);

  if(queuedir [0] == '~'){
    sprintf(queue,"%s%s/%s",home,&queuedir[1],QUEUE);
    sprintf(logfile,"%s%s/%s.%s",home,&queuedir[1],daemon_name,LOG_EXT);
    sprintf(daemon,"%s%s/%s.%s",home,&queuedir[1],daemon_name,PID_EXT);
  }else{
    sprintf(queue,"%s/%s",queuedir,QUEUE);
    sprintf(logfile,"%s/%s.%s",queuedir,daemon_name,LOG_EXT);
    sprintf(daemon,"%s/%s.%s",queuedir,daemon_name,PID_EXT);
  };

  daemonputenv(queuedir,mailbox,queue,user,home);
  path=getenv("PATH");

/* Redirect to logfile
 */

  if(!debug){
    close(2);
    freopen(logfile,"a",fstdio[2]);
    if(fileno(fstdio[2])!=2){
      dup2(fileno(fstdio[2]),2);
    };
  }else
    printf("Would have opened logfile %s\n",logfile);


/* Set the daemon command.  Normally this is a script.
 */

  if(index("ceo",option)==NULL){
    if(!strcmp(daemon_name,RECEIVE) && forward_to!=NULL){
      char hostname[LINESIZE];

      if(gethostname(hostname,sizeof(hostname))==-1){
        fprintf(fstdio[2],"Can't get hostname\n");
        exit(-1);
      };
      if(option!='t') option='f';
      arguments[2]=smtpservice;
      arguments[3]=hostname;
      arguments[4]=forward_to;
    }else{
	/* Assume its an exec command of the name daemon_name.SCRIPT_EXT */
      sprintf(command,"%s.%s",daemon_name,SCRIPT_EXT);
      option='e';
    }
  };


/* This sets and hash command name...
 */
  switch(option){
    case 'o':
    case 't':
    case 'f':
      break;
    case 'e':
      if(command[0]!='\0'){
        s=hash(path,command);
        printf("Hashed command %s\n",command);
        if(s!=NULL)if(*s=='/'){
          strcpy(command,s);
          break;
        };
      };
      command[0]='\0'; /* Now I let this fall through to default */
    case 'c':
    default:
      if(!command[0]){
        fprintf(fstdio[2],"%s\n","Can't find daemon command.");
#ifdef USE_TERM
        if(!strcmp(daemon_name,RECEIVE)){
          option='t';
          fprintf(fstdio[2],"%s\n","Attempting to use term.");
        }else
          exit(-1);
#endif
     };
     break;
  };
  if(command==NULL){
    fprintf(fstdio[2],"%s\n","Can't find daemon command");
    exit(1);
  };


/* Signal old daemon
 */
  if(resume) daemonsignal(daemon);


/* OK, here is where I fork, so the daemon can continue past logouts.
 */

  if(debug!=1)if((pid=fork())!=0)
    if(pid==-1){
      fprintf(fstdio[2], "Fork failded\n");
      exit(1);
    }else
      exit(0);



  daemonkill(daemon,kill_daemon);
  daemonloop(option,daemon,queue,mailbox,command,arguments);
}

