/*
 *		BCR Mail Handler, version 3.1
 *
 *	      Copyright (c) 1994 Bill C. Riemers
 *		  All Rights Reserved
 *
 *  This following is the standard GNU notice of copyright.  The only
 *  exception is I maintain I own this program and reserve all future
 *  rights.  (Meaning I might use a different copyright on future 
 *  releases, or violate my own copyright anyway I see fit.)
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define IS_FCNTL
#define IS_STAT
#define IS_STDIO
#define IS_STRING
#define IS_TYPES
#define IS_UNISTD

#include "config.h"
#include "includes.h"
#include "prototypes.h"


/* This routine checks if "from" matches a regulare expression either
 * in the allow or the deny file.
 *
 * If a user is not listed in the allow file, but an allow file exists,
 * or the user is listed in a deny file, then 0 is returned, otherwise
 * 1 is returned.
 */

int checkaccess(char *home, char *from, char *to, char *extra){
  char file[LINESIZE];
  FILE *fd;

  if(from==NULL) return 1;

/* Check the deny file */

  if(QUEUEDIR [0] == '~')
    sprintf(file,"%s/%s/%s",home,&QUEUEDIR [1],DENYFILE);
  else
    sprintf(file,"%s/%s",QUEUEDIR,DENYFILE);

  fd=fopen(file,"r");
  if(fd==NULL){
    char hostname[LINESIZE];

#ifdef DEBUG
    fprintf(fstdio[1],"Opening %s\n",file);
    fflush(fstdio[1]);
#endif
    fd=fopen(file,"w");
    gethostname(hostname,sizeof(hostname));
    fprintf(fd,"%s%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n%s\n",
      "# The following users are not allowed access to the mail handler",
      "?*@",hostname, "?*@localhost", "daemon@?*", "deamon@?*",
      "mailer@?*", "postmaster@?*", "mailer-daemon@?*", "?*@" ANON);
    fclose(fd);
    fd=fopen(file,"r");
  };

  if(searchforuser(fd,from,extra)){
    fprintf(fstdio[1],"Access denied\n"); 
    return 0;
  };
 
/* Check the access file */

  if(QUEUEDIR [0] == '~')
    sprintf(file,"%s/%s/%s",home,&QUEUEDIR [1],ALLOWFILE);
  else
    sprintf(file,"%s/%s",QUEUEDIR,ALLOWFILE);

  fd=fopen(file,"r");
  if(fd==NULL) return 1;
  if(searchforuser(fd,from,extra)){
    fprintf(fstdio[1],"Access allowed\n"); 
    return 1;
  };
  return 0;
}

