include layout.inc

_TEXT	SEGMENT BYTE PUBLIC 'CODE'

	ASSUME	CS:_TEXT
	ASSUME	DS:_TEXT

	PUBLIC	START
	extrn	_romstart:near

ifdef UNDER_DOS
	ORG	100h
else
	org 0
endif

START	PROC	NEAR
ifdef REALLY_ROM
	dw	0aa55h		; rom signature
	db	08000h / 512	; size
endif
ifdef ROM_CODE
	mov	bx,100h
ifdef REALLY_ROM
	push	bx
	xor	ax,ax		; check if a disk is inserted in drive A:
	xor	dx,dx		; use head 0, drive 0
	int	13h		; initialize drives
	mov	es,bx
	xor	bx,bx
	mov	cx,0001h	; read sector 1 of track 0
	mov	ax,0201h	; read 1 sector
	int	13h
	pop	bx
	jc	nodisk
	retf			; return to BIOS to boot from diskette
endif

nodisk:	mov	dx,ss
	mov	ax,sp		; save old stack pointer
	mov	bx, 100h
	mov	cx, 6bf0h
	mov	ss,bx		; put stack at 100:6bf0 -> 7bf0
	mov	sp,cx
	push	dx
	push	ax		; save old stack pointer onto new stack

	mov	dx,cs
	mov	ds,dx		; going to move ds:si to es:di

	cld
	mov	es,bx
	xor	di,di		; clear dest
	mov	si,OFFSET CGROUP:_start_of_data 
				; move _DATA segment
	mov	cx, offset dgroup:_end_of_data
	rep movsb
				; now clear _BSS segment
	mov	cx, offset dgroup:_end_of_bss
	sub	cx, offset dgroup:_end_of_data
	mov	al,0
	rep stosb

	mov	ax,100h
	mov	es,ax
	mov	ds,ax	
	STI			;Enable interrupts and the jump
	call	_romstart	;to the start of the C code

else
	MOV	DX,CS		; 
	mov	ax,9800h	; nice high place
	mov	es,ax
	cld
	xor	di,di		; clear dest
	xor	si,si
	mov	cx, offset dgroup:_end_of_data
	rep movsb
				; now clear _BSS segment
	mov	cx, offset dgroup:_end_of_bss
	sub	cx, offset dgroup:_end_of_data
	mov	al,0
	rep stosb

	cli
	mov	bx,ss		; get old stack pointer
	mov	dx,sp
	mov	ax,9800h	; nice high place
	mov	ds,ax
	mov	es,ax
	mov	ss,ax	
	mov	sp, 07ffeh	; stack
	push	bx		; save old stack pointer onto new stack
	push	dx
; I'm tired and I can't be bothered fighting this assembler
	db	0eah		; far jump
	dw	offset dgroup: here_i_am
	dw	09800h
here_i_am:
	STI			;Enable interrupts and the jump
	call	_romstart	;to the start of the C code
endif

ifdef UNDER_DOS
	int	19h
endif
	pop	ax		; get old stack pointer
	pop	bx		; get old stack segment
	mov	ss,bx
	mov	sp,ax
	retf			; return to where we came from
START	ENDP

_TEXT	ENDS

	END START
