#include <stdio.h>
#include <fcntl.h>

unsigned char buffer[0x8000];

main(int argc, char **argv)
{
int fp;
unsigned int i, len;
unsigned char x;
	if (argc != 2)
	{
		fprintf(stderr, "Usage: dosum file\n");
		exit(1);
	}
	for(i = 0; i < sizeof(buffer); i++)
		buffer[i] = 0xff;
	fp = open(argv[1], O_RDWR | O_BINARY, 0);
	
	if (fp == -1)
	{
		fprintf(stderr, "Can't open %s\n", argv[1]);
		exit(2);
	}
	len = read(fp, buffer, sizeof(buffer));
	if (len < 10)
	{
		close(fp);
		fprintf(stderr, "%s not a sensible file\n", argv[1]);
		exit(3);
	}
	x = 0;
	for(i = 0; i < sizeof(buffer) - 1; i++)
		x += buffer[i];
	x = 0 - x;
	buffer[i] = x;
	lseek(fp, 0L, 0);
	len = write(fp, buffer, sizeof(buffer));
	if (len != sizeof(buffer))
	{
		close(fp);
		fprintf(stderr, "could not write %s\n", argv[1]);
		exit(4);
	}
	close(fp);
	exit(0);
}
