#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "protocol.h"
#include "bootinc.h"

/* Copyright 1993 Jamie Honan
   May be freely copied, sold and modified.
*/

int 
xinch(char *s)
{
	int             val;
	int             nseen;

	nseen = 0;
	val = 0;
	for (; *s; s++)
	{
		if (!nseen && isspace(*s))
			continue;
		if (!nseen)
		{
			if (*s == '0')
			{
				nseen = 1;
				continue;
			}
			nseen = 2;
		}
		if (nseen == 1 && (*s == 'x' || *s == 'X'))
		{
			nseen = 2;
			continue;
		}
		if (*s >= 'a' && *s <= 'f')
			val = val * 16 + (*s - 'a') + 10;
		else if (*s >= 'A' && *s <= 'F')
			val = val * 16 + (*s - 'A') + 10;
		else if (*s >= '0' && *s <= '9')
			val = val * 16 + (*s - '0');
		else
			break;
	}
	return val;
}

main(argc, argv)
int             argc;
char           *argv[];

{
	int             irq,
	                ioaddr,
	                haddr,
	                extra;
static	char            ifname[30];
	char           *argp;
	int             argn;

	argn = 0;
	ifname[0] = 'w';
	ifname[1] = 'd';
	ifname[2] = '\0';

	irq = 10;
	ioaddr = 0x280;
	haddr = 0xd000;
	extra = 0;


/*	n_printf(" ds %x cs %x ss %x, sp %x, start_of_data %x, end_of_data %x, end_of_bss %x\n",
		segds(), segcs(), segss(), &argn, &start_of_data, &end_of_data,&end_of_bss);
	
	n_putscrlf("booter ... ");

	dos_exit(0);
*/
	while (--argc > 0)
	{
		argn++;
		argp = argv[argn];
		if (*argp == '-' || *argp == '?')
		{
			fprintf(stderr, "usage: %s [ifname [irq [ioaddr [hardaddr [extra]]]]\n", argv[0]);
			exit(1);
		}
		switch (argn)
		{
		case 1:
			strncpy(ifname, argp, sizeof(ifname) - 1);
			ifname[sizeof(ifname) - 1] = '\0';
			break;
		case 2:
			irq = xinch(argp);
			break;
		case 3:
			ioaddr = xinch(argp);
			break;
		case 4:
			haddr = xinch(argp);
			break;
		case 5:
			extra = xinch(argp);
			break;
		default:
			fprintf(stderr, "Too many params on command line\n");
			fprintf(stderr, "usage: %s [ifname [irq [ioaddr [hardaddr [extra]]]]\n", argv[0]);
			exit(1);
		}
	}
	netparms(irq, haddr, ioaddr, extra);
	do_boot_process(ifname);
	dos_exit(0);
}
