#!/bin/sh
#
# This is a shell script to patch your keytables so that the
# VAX-VMS-EDT style keypad works with the edt-emulation mode of emacs
#
while [ ! -f "$oldtable" ]
do
  echo -n "please enter the name of your current keytable: "
  read oldtable
  if [ ! -f "$oldtable" ]
  then
    echo "$oldtable doesn't exist. I need a template to work with"
  fi
done

echo now writing the patched table edt-vt100-kbd.map

sed -e 's/Num_Lock/F11 # Num_Lock -> GoldKey/g' \
    -e 's/KP_Divide/F12 # KP_Divide -> Help/g' \
    -e 's/KP_Multiply/F13 # KP_Multiply -> FindNext+Find/g' \
    -e 's/KP_Subtract/F14 # KP_Subtract -> DelLine+UnDelLine/g' \
    -e 's/KP_Add/F26 # KP_Add -> DelWord+UnDelWord/g' \
    -e 's/KP_Enter/F10 # KP_Enter -> Enter/g' \
    -e 's/KP_Comma/F25 # KP_Comma -> Select+Reset/g' \
    -e 's/KP_0/F24 # KP_0/g' \
    -e 's/KP_1/F21 # KP_1/g' \
    -e 's/KP_2/F22 # KP_2/g' \
    -e 's/KP_3/F23 # KP_3/g' \
    -e 's/KP_4/F18 # KP_4/g' \
    -e 's/KP_5/F19 # KP_5/g' \
    -e 's/KP_6/F20 # KP_6/g' \
    -e 's/KP_7/F15 # KP_7/g' \
    -e 's/KP_8/F16 # KP_8/g' \
    -e 's/KP_9/F17 # KP_9/g' \
    -e 's/\\033\[21~/\\033OM/g' \
    -e 's/\\033\[23~/\\033OP/g' \
    -e 's/\\033\[24~/\\033OQ/g' \
    -e 's/\\033\[25~/\\033OR/g' \
    -e 's/\\033\[26~/\\033OS/g' \
    -e 's/\\033\[28~/\\033Ow/g' \
    -e 's/\\033\[29~/\\033Ox/g' \
    -e 's/\\033\[31~/\\033Oy/g' \
    -e 's/\\033\[32~/\\033Ot/g' \
    -e 's/\\033\[33~/\\033Ou/g' \
    -e 's/\\033\[34~/\\033Ov/g' \
    -e 's/F21 = ""/F21 = "\\033Oq"/g' \
    -e 's/F22 = ""/F22 = "\\033Or"/g' \
    -e 's/F23 = ""/F23 = "\\033Os"/g' \
    -e 's/F24 = ""/F24 = "\\033Op"/g' \
    -e 's/F25 = ""/F25 = "\\033On"/g' \
    -e 's/F26 = ""/F26 = "\\033Om"/g' $oldtable > edt-vt100-kbd.map
