/* Here lies the main part of lread, a DOS program designed to read
 * the Linux ext2 file system.  It was written in April of 1995 by a
 * group of three:  Jason Hunter, Kris Hett, and David Lutz.
 * It is the first really cool program produced for Ed Loyot's
 * Operating Systems class.  Kris unfortunately had too little time
 * available to devote to this project, so none of his code is included
 * in this package.
*/

/* This file's contents were written by both Jason and Dave.
*/

/* Still to do: (you're welcome to help!)
 *   add more robust modes--like for devices
 *   allow chasing softlinks
 *   make ldir dates shorter (like ls ???)
 *   add more error handling
 *   don't let it overwrite a DOS file ???
 *
 */

#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <ctype.h>       /* for tolower() */
#ifdef __TURBOC__
#include <sys\stat.h>
#include <io.h>          /* for creat/write/close */
#else
#include <sys/stat.h>
#endif
#include <string.h>
#include "ext2.h"
#include "proto.h"

#define DEBUG 0  /* true==1 */

void main( int argc, char **argv )
{
  inode *i;
  byte buf[1024];
  char argv1bak[1024];
  int bytes, fd;
  long inode_num;
  int x;

  /* change the argv[0] to lowercase */
  for( x=0; x < strlen( argv[0] ); x++ )
    argv[0][x] = tolower( argv[0][x] );


  if( argc < 2 )
    if( strstr( argv[0], "ldir" ) != NULL )  /* See if a dir is requested */
    {
      printf( "format: ldir /LinuxPath/LinuxDir\n" );
      exit(-1);
    }
    else                                     /* it was a lread */
    {
      printf( "format: lread /LinuxPath/LinuxFile [DosFile]\n" );
      exit(-1);
    }


#ifdef __TURBOC__
  _fmode = O_BINARY;   /* we want all files binary for this */
#endif

#ifdef __TURBOC__
  examine_drive();
#else
  open_dev( "/dev/hda4" );
#endif

  if( load_super() == -1 )		   /* Couldn't get superblock */
    exit( -1 );
  if (DEBUG) print_super();

  if( load_groups() == -1 )		   /* Couldn't read groups */
    exit( -1 );
  if (DEBUG) print_groups();

  strcpy( argv1bak, argv[1] );
  inode_num = eatpath( argv[1] );
  if( inode_num == 0 ) exit( -1 );         /* Linux path was invalid */
  i = load_inode( inode_num );
  if( i == NULL ) exit( -1 );              /* Problem with the inode */

  if( strstr( argv[0], "ldir" ) != NULL )  /* See if a dir is requested */
  {
    list_dir( i );
    exit( 1 );
  }

  if (DEBUG) print_inode( i );
  if (DEBUG) print_blocks( i );

  if( argc == 3)
  {
    fd = creat( argv[2], S_IREAD | S_IWRITE );
    if (fd == -1)
    {
      perror( "Problem opening second argument file (DOS file)" );
      exit( -1 );
    }
  }
  else /* argc == 2 and we want output to stdout */
  {
    fd = 1;
  }


  /* No malloc needed since it's char buf[1024] */
  bytes = read_inode( i, buf, 1024 ); /* read first block */
  if( bytes == -1 ) exit( -1 ); /* problem reading */
  do
    {
      write( fd, buf, bytes );	/* write to disk */
      bytes = read_inode( NULL, buf, 1024 );
      if( bytes == -1) exit( -1 ); /* problem reading */
    } while( bytes != 0 );

  if( bytes == 0 && argc == 3 )
    printf( "%s copied to %s\n",argv1bak, argv[2]);
  else if( bytes == 0 && argc == 2 )
    printf( "*** No errors ***\n" );
  else if( bytes == -1 && argc == 3 )
    printf( "Problem reading file... check %s for partial data.\n",argv[2]);
  else if( bytes == -1 && argc == 2 )
    printf( "*** Problem encountered reading file ***\n");
  else
    printf( "You should NEVER see this error message.  :-)\n");  
    
  close( fd );
}
