/*
 *  linux/fs/msdos/dir.c
 *
 *  Written 1992,1993 by Werner Almesberger
 *
 *  MS-DOS directory handling functions
 */

#ifdef MODULE
#include <linux/module.h>
#endif

#include <asm/segment.h>

#include <linux/fs.h>
#include <linux/msdos_fs.h>
#include <linux/errno.h>
#include <linux/stat.h>
#include <linux/string.h>

#include "msbuffer.h"

/* Begin GV Added Code +++ */
#include "lfn.h"

int msdos_get_entry_lfn(struct inode *dir, loff_t *pos,struct buffer_head **bh,
    struct msdos_dir_entry **de,char *lfn,int *piLenLfn);

/* End GV Added Code +++ */

#define PRINTK(X)

static int msdos_dir_read(struct inode * inode,struct file * filp, char * buf,int count)
{
	return -EISDIR;
}

static struct file_operations msdos_dir_operations = {
	NULL,			/* lseek - default */
	msdos_dir_read,		/* read */
	NULL,			/* write - bad */
	msdos_readdir,		/* readdir */
	NULL,			/* select - default */
	NULL,			/* ioctl - default */
	NULL,			/* mmap */
	NULL,			/* no special open code */
	NULL,			/* no special release code */
	file_fsync		/* fsync */
};

struct inode_operations msdos_dir_inode_operations = {
	&msdos_dir_operations,	/* default directory file-ops */
	msdos_create,		/* create */
	msdos_lookup,		/* lookup */
	NULL,			/* link */
	msdos_unlink,		/* unlink */
	NULL,			/* symlink */
	msdos_mkdir,		/* mkdir */
	msdos_rmdir,		/* rmdir */
	NULL,			/* mknod */
	msdos_rename,		/* rename */
	NULL,			/* readlink */
	NULL,			/* follow_link */
	msdos_bmap,		/* bmap */
	NULL,			/* truncate */
	NULL			/* permission */
};

int msdos_readdir(
	struct inode *inode,
	struct file *filp,
	void *dirent,
	filldir_t filldir)
{
	struct super_block *sb = inode->i_sb;
	int ino,i,i2,last;
	char c;
	struct buffer_head *bh;
	struct msdos_dir_entry *de;
	unsigned long oldpos = filp->f_pos;
	/* Begin GV Added Code +++ */	
	BOOL fNameLowerCase,fExtLowerCase;
	char bufname[13+MAXLFN];
	/* End GV Added Code +++ */

	if (!inode || !S_ISDIR(inode->i_mode))
		return -EBADF;
/* Fake . and .. for the root directory. */
	if (inode->i_ino == MSDOS_ROOT_INO) {
		while (oldpos < 2) {
			if (filldir(dirent, "..", oldpos+1, oldpos, MSDOS_ROOT_INO) < 0)
				return 0;
			oldpos++;
			filp->f_pos++;
		}
		if (oldpos == 2)
			filp->f_pos = 0;
	}
	if (filp->f_pos & (sizeof(struct msdos_dir_entry)-1))
		return -ENOENT;
	bh = NULL;
	/* Begin GV Added Code +++ */
	while ((ino = msdos_get_entry_lfn(inode,&filp->f_pos,&bh,&de,bufname,&i)) > -1) {
	/* End GV Added Code +++ */
	/* Begin GV Removed Code +++ *
	while ((ino = msdos_get_entry(inode,&filp->f_pos,&bh,&de)) > -1) {
	 * End GV Removed Code +++ */
		/* Begin GV Added Code +++ */		
		GetDosDirEntryNameInfo(de,NULL,&fNameLowerCase,&fExtLowerCase) ;
		/* End GV Added Code +++ */
		if (!IS_FREE(de->name)
			&& !(de->attr & (ATTR_VOLUME|ATTR_SYS|ATTR_HIDDEN))) {
		        /* Begin GV Removed Code +++ *
			char bufname[12];
		         * End GV Removed Code +++ */
                        if (i==0)
                        {
			char *ptname = bufname;

			for (i = last = 0; i < 8; i++) {
				if (!(c = de->name[i])) break;
				/* Begin GV Added Code +++ */
				if ((c >= 'A' && c <= 'Z') && (fNameLowerCase)) c += 32;
				/* End GV Added Code +++ */
				/* Begin GV Removed Code +++ *
				if (c >= 'A' && c <= 'Z') c += 32;
				 * End GV Removed Code +++ */
				if (c != ' ')
					last = i+1;
				ptname[i] = c;
			}
			i = last;
			ptname[i] = '.';
			i++;
			for (i2 = 0; i2 < 3; i2++) {
				if (!(c = de->ext[i2])) break;
				/* Begin GV Added Code +++ */
				if ((c >= 'A' && c <= 'Z') && (fExtLowerCase)) c += 32;
				/* End GV Added Code +++ */
				/* Begin GV Removed Code +++ *
				if (c >= 'A' && c <= 'Z') c += 32;
				 * End GV Removed Code +++ */
				if (c != ' ')
					last = i+1;
				ptname[i] = c;
				i++;
			}
                        /* Begin GV Added Code +++ */
                        i = last;
                        }
                        if (i != 0) {
                        /* End GV Added Code +++ */
                        /* Begin GV Removed Code +++ *
			if ((i = last) != 0) {
                         * End GV Removed Code +++ */
				if (!strcmp(de->name,MSDOS_DOT))
					ino = inode->i_ino;
				else if (!strcmp(de->name,MSDOS_DOTDOT))
					ino = msdos_parent_ino(inode,0);
				if (filldir(dirent, bufname, i, oldpos, ino) < 0) {
					filp->f_pos = oldpos;
					break;
				}
			}
		}
		oldpos = filp->f_pos;
	}
	if (bh) brelse(bh);
	return 0;
}
