/* dos emulator, Matthias Lautner */

#include <linux/vm86.h>

#define _regs	vm86s.regs

#define us unsigned short


#define SP_ADR (unsigned short *) (((_regs.ss<< 4) + _regs.esp) & 0xfffff)

#if	0
#define SEG_ADR(type, seg, reg) type((int)(*(us *)&_regs.seg<<4)\
				 + *(us *)&_regs.e##reg)

#define LO(reg)		(int)(*(unsigned char *)&_regs.e##reg)
#define HI(reg)		(int)(*((unsigned char *)&_regs.e##reg +1))
#define CF 0x01
#define ZF 0x40
#define SF 0x80

#define TF TF_MASK
#define IF IF_MASK
#define VM VM_MASK
#define VIF VIF_MASK
#define VIP VIP_MASK

#define CARRY	_regs.eflags|=CF;
#define NOCARRY	_regs.eflags&=~CF;
#define ISEG(i) ivecs[i].segment
#define IVEC(i) ((ISEG(i)<<4) + IOFF(i))
#define IOFF(i) ivecs[i].offset
#define WORD(i) (i&0xffff)
#define LWORD(reg)      (*( (unsigned short *)&(vm86s.regs.reg)  ))
#endif



extern struct vm86_struct vm86s;
extern int error, c_screen;

#include "disk.h"
#include "machcompat.h"

void show_regs(void);
int ext_fs(int, char *, char *, int);
void char_out(unsigned char, int);
int outc(int c);
void termioInit();
void termioClose();
#define NOWAIT  0
#define WAIT    1
#define TEST    2
int ReadKeyboard(int *, int);
void ReadString(int, char *);

#define SIG_TIME  SIGALRM

#define warn printf
#define h_printf printf
#define s_printf printf
#define g_printf printf
#define i_printf printf
#define k_printf printf
#if	0
#define x_printf printf
#endif
#define v_printf printf
#define dbug_printf printf
#define W_printf printf
#define er_printf printf 
extern void d_printf();

     typedef unsigned char boolean;

     typedef struct config_info {
       int hdiskboot;

       /* for video */
       boolean console_video;
       boolean graphics;
       boolean vga;
       u_short cardtype;
       u_short chipset;
       u_short gfxmemsize;	/* for SVGA card, in K */
       u_short redraw_chunks;
       boolean fullrestore;

       boolean console_keyb;
       boolean exitearly;
       boolean mathco;
       boolean ipxsup;
       boolean keybint;
       boolean dosbanner;
       boolean allowvideoportaccess;
       boolean timers;
       boolean mouse_flag;
       boolean mapped_bios;	/* video BIOS */
       boolean mapped_sbios;	/* system BIOS */
       char *vbios_file;	/* loaded VBIOS file */
       boolean vbios_copy;
       int vbios_seg;           /* VGA-BIOS-segment for mapping */

       boolean bootdisk;	/* Special bootdisk defined */
       boolean fastfloppy;
       char *emusys;		/* map CONFIG.SYS to CONFIG.EMU */
       char *emubat;		/* map AUTOEXEC.BAT to AUTOEXEC.EMU */

       u_short speaker;		/* 0 off, 1 native, 2 emulated */
       u_short fdisks, hdisks;
       u_short num_lpt;
       u_short num_ser;
       u_short num_mice;

       int pktflags;		/* global flags for packet driver */

       unsigned int update, freq;	/* temp timer magic */

       unsigned int hogthreshold;

       int mem_size, xms_size, ems_size, dpmi_size;

       int keyboard;
       unsigned char *key_map;     /* pointer to the correct keyboard-map */
       unsigned char *shift_map;
       unsigned char *alt_map;
       unsigned char *num_table;
     }

config_t;

extern config_t config;
#define error(f,a...)             printf(f,##a)
#define E_printf(f,a...)             printf(f,##a)
