.TH ntape 1 "August 1995" "ntape 0.20"
.SH NAME
ntape \- an archive management system for SCSI tapes
.SH SYNOPSIS
ntape
.SH DESCRIPTION
\fIntape\fP is a colored ncurses based program to manage archives on
tapes. With \fIntape\fP you can archive files, directories and
combinations of both on tape with some additional information. All the
data about the archive is stored in a simple database.
This makes it easy to extract a certain archive on a tape or only
parts of it.
ntape is especially suitable for small archive packages(< 100
files). If you want to backup your whole system or a partition you
should consider dump and restore as an alternative.
.SH "MAIN WINDOW"
The main view port is divided into four parts. In the first line there
are various menu items. See the menu section for more. 

In the second line you can get information about the current
tape. This line displays its name and how many archives are saved on
it if one tape is selected. You can also see the current position of
the highlighted archive as an absolute number and in percent.

In the third part - the big box in the middle of the screen - the list
of the available archives is shown. After the program starts
\fIntape\fP displays all accessible archives of all tapes you have
registered with \fIntape\fP. If you have set one tape as the active
one the list box contains only these archives that are saved on the
selected tape. To get more information about a certain archive you
should highlight this list entry at first (use cursor up/down, page
up/down and home/end for this; BTW: these keys work for every list box
in \fIntape\fP) and then press SPACE. This will pop up an information
box about the highlighted archive. See the info box section for more.

The fourth part is the last line on the screen. It contains some
information about what is actually going on or error messages
especially about failures with tape operations.
.SH "INFO BOX"
The info box contains - as the name already says - a lot of additional
information about the selected (highlighted) archive in the archive
list such as the name of the archive, the name of the tape where it is
stored, the archive size, the absolute block position on the tape, the
date of archivation, the so called platform (normally the Operating
System), the category (e.g. game, utility, backup, etc.), a flag if
the archive contents are saved to the database (for faster partial
extraction) and a field for some comments about the archive that are
not covered by the previous fields.

If you have selected a tape then there are buttons for basic
operations on the tape archive such as modifying its information,
extracting the whole archive and extracting only parts of the archive
or showing the archive contents. See section Extracting and Viewing
Archives for more.
.SH MENUS
There are three different menu items in the first line. You can access
each of them with cursor left/right and TAB and pop up one with RET.
.TP
.B Tape
This menu contains all the tape specific operations:
.br 
You can \fBCreate a new tape\fP for \fIntape\fP. That means
\fIntape\fP erases this tape (think twice!!) and writes a header at
the beginning of the tape for later identification. There is no other
way to register a tape to \fIntape\fP with the current version
(Suggestions welcome!). This tape is automatically the selected one so
you can perform other tape operations with it. 
.br
Another way to select a tape is \fBSet active tape\fP. \fIntape\fP
rewinds the tape, reads the header and updates the archive
list. Selecting a tape is the first step if you want to add an archive
or extract one or do some other stupid things. 
.br
It is better to rewind a tape before you eject it. This is possible
with the item \fBRewind tape\fP.
.br
To get some internal tape information you should select the \fBTape
status report\fP. This is a little experimental and if some
information is wrong (especially the "Online" and "Write protected"
fields) please contact me. At last use \fBQuit\fP to terminate
\fIntape\fP.
.TP 
.B Utilities
This menu contains various useful items:
.br
The most important one is \fBAdd archives to tape\fP. The selection of
this item will pop up a file dialog box. You can now mark files (press
SPACE) and directories in this list which you want to be
archived. Currently you can mark files only at one directory
level. This may be changed in future versions. After you have composed
your archive you will be asked for some information about the
archive. Then the file will be appended at the end of tape data and
the block position of the beginning is stored to the database for
faster read access.
.br
People do stupid things sometimes and it can happen that you have
appended a useless archive to your tape and the f*cking ntape has no
way to undo this operation (it is non-trivial and dangerous and I have
no experiences in this). But ntape is able to make this archive
invisible to you by setting a certain flag. Just highlight the damned
archive and choose \fBComment focused archive\fP then the archive
won't appear in your list in the future (but it's still stored on
tape). 
.br
\fBSearch archive by substring\fP makes it easier to find a certain
archive. It also understands the well known wild-cards '*' and '?'.
.br
To have an overview about the entire bunch of archives you have to
select \fBShow complete archive list\fP. As an side effect the current
tape becomes unselected and you have to set it active again for
further operations.
.br
Selecting the last item in the utilities menu - \fBShow complete tape
list\fP - will show you all registered tapes accessible with
ntape. Besides you can remove all data connected with a certain tape
from all three databases. The tape won't be erased with this operation
as this will be performed in any case if you re-register this tape to
ntape.
.TP
.B Options
In this section you can change settings at runtime that are layed down
in the configuration file (see also Configuration). Currently there
are two different options dialogs available. In the \fBSort options\fP
dialog you can change the sorting behavior. It overwrites the
following definitions in the configuration file: DefaultSortOrder and
DefaultSortType. In the \fBOther options\fP dialog you can only set if
ntape should display a logging window during tape operations or
not. This overwrites the option WatchTape in your .ntaperc.
.SH "MAIN TAPE OPERATIONS"
.TP
.B Adding an archive to tape
Adding an archive to tape covers the following situation in current
versions:
.br
You have a set of files and directories (with their subdirectories of
course), all in the same directory and you want to save them as one
archive on a tape that is registered to ntape with \fBCreate new
tape\fP. Then you have to perform the following steps:
.br 
\fB1.\fP Insert the tape where you want to store the archives and
choose the Item \fBSet active tape\fP in the Menu \fBTape\fP. Make
sure that the tape isn't write protected.
.br
\fB2.\fP Choose Item \fBAdd archives to tape\fP in the Menu
\fBUtilities\fP. 
.br
\fB3.\fP In the file selection dialog go to the directory where the
files and directories are placed in (switch directories with
RET). Then mark all entries you want to be archived (use SPACE for
this). After this press the OK button (use the keys TAB and RETURN).
.br
\fB4.\fP Answer the questions about the archives in the following
dialog (switch between fields with TAB, in non-editing fields use
cursor up/down to choose the item that fits best).
.br
\fB5.\fP Press OK and the storing process starts.
.TP
.B Extracting and viewing archives
To extract archives or view the archive contents you must perform the
following steps:
.br
\fB1.\fP Insert the tape where you want to extract or view the
archives and choose the Item \fBSet active tape\fP in the Menu
\fBTape\fP.
.br
\fB2.\fP Highlight the item in the archive list which you want to
extract or view (use cursor up/down, page up/down, HOME/END for this)
and select the item (with SPACE).
.br
\fB3.\fP Choose \fBExtract all\fP in the archive information window if
you want to extract the whole archive, choose \fBExtract selected\fP
if you want to view the archive contents or you want to extract only
parts of the archive.
.br
\fB4.\fP Go to the directory where you want the archive to be
extracted (if you just want to view the archive contents press OK
immediately). The control of the directory selection window is the
same as in the file selection window in step 3 when adding an archive
to tape. The current path is displayed in the Path line. Press OK when
you're in the right directory. 
.br
If you have chosen \fBExtract all\fP then the extraction
starts. Otherwise you still have to step through the following items.
.br
\fB5.\fP If the archive contents aren't already saved to the database
you will be asked if the contents should be saved now. You should
answer Yes if you want to extract parts of this archive some more
times. Otherwise answer No especially if the archive only consists 
of one file.
.br
\fB6.\fP Now ntape reads the archive contents from database (relatively
fast) or from tape (sloow). After this a list of the contents will be
displayed. You can step through this list with the cursor keys. If
you just wanted to view the archive press Cancel after you have seen
enough. Otherwise mark the items you want to be extracted (with SPACE)
and press OK. That's it!
.SH CONFIGURATION
At program start ntape will search for the configuration file
\fI$HOME/.ntaperc\fP which describes a lot of properties of
ntape. Some of them can be changed at runtime in the Options
menu. ntape will ignore anything in a line after a hash ('#'). Every
configuration line consist of two words (a word is a set of chars
without a whitespace). The first word is known as the keyword the
second specifies its special property.

DatabasePath \fIDatabasedir\fP
.IP
The directory where ntape searches its database files.
.PP
DefaultSortOrder \fISortby\fP
.IP
The way ntape should display the list of archives. Valid values for
\fISortby\fP are \fBname\fP (sorted by archive name), \fBsize\fP
(archive size) and \fBposition\fP (absolute block position on tape).
.PP
DefaultSortType \fIAscDesc\fP
.IP
ntape will sort the archives \fBAscending\fP or \fBDescending\fP.
.PP
Platform \fIplatform\fP
.IP
Here you can specify all the platforms from which you want to archive
files on tape. This may be an operating system such as Linux or an
extender such as MS Windoze. You can specify up to 20 Platforms.
.PP
Category \fIcategory\fP
.IP
With this keyword you are able to specify your archive more
exactly. Categories are for example backups, games, utilities, etc. 20
categories are allowed.
.PP
SaveContents \fIyesno\fP
.IP
If \fIyesno\fP is \fBYes\fP then the archive contents will be saved to
the contents file by default. This would result in a faster partial
extraction but is useless in one-file-archives. Other value for
\fIyesno\fP is \fBNo\fP, what else!
.PP
WatchTape \fIyesno\fP
.IP
If \fIyesno\fP is \fBYes\fP then every time a tape dependent operation
is executed a log window pops up and displays what is actually going
on. If \fIyesno\fP is \fBNo\fP then only short messages are displayed
in the foot line.
.PP
The following keywords configure the colors in ntape. The keyword
specifies the area and the second word the foreground/background
color combination of this area. Valid colors are \fBblack, red, green,
yellow, blue, magenta, cyan, white\fP. If you add the word \fBlight\fP 
in front of the color name, e.g. \fBlightblue\fP, the color will be
brightened. This works only with foreground colors and with a terminal
that supports the \fBbold\fP attribute.

ColMenu	\fIforeground/background\fP
.IP
Specifies the menu with its popups at the top of the window.
.PP
ColInvMenu \fIforeground/background\fP
.IP
The selected part of the menu.
.PP
ColStatusline \fIforeground/background\fP
.IP
The second line on the screen.
.PP
ColArchiveList \fIforeground/background\fP
.IP
The list of archives.
.PP
ColInvArchiveList \fIforeground/background\fP
.IP
The highlighted line in the archive list.
.PP
ColFooter \fIforeground/background\fP
.IP
The last line on the screen.
.PP
ColMessageBox \fIforeground/background\fP
.IP
The message boxes, for example when quitting the program.
.PP
ColInvMessageBox \fIforeground/background\fP
.IP
Active OK or Cancel button in message box.
.PP
ColInputDialog \fIforeground/background\fP
.IP
The popup window which prompts for an input, e.g. when asking for a
tape name.
.PP
ColInvInputDialog \fIforeground/background\fP
.IP
The active OK or Cancel button in the popup window.
.PP
ColEntryField \fIforeground/background\fP
.IP
The text entry field in the popup window.
.PP
ColTapeOpLog \fIforeground/background\fP
.IP
The tape operations log window.
.PP
ColInfoFrame \fIforeground/background\fP
.IP
The border of the info box.
.PP
ColInvInfoFrame \fIforeground/background\fP
.IP
The active Cancel, Extract, Edit button in the info box.
.PP
ColInfoLabels \fIforeground/background\fP
.IP
The field names in the info box, e.g. Sort order, Watch tape ,etc.
.PP
ColInvInfoLabels \fIforeground/background\fP
.IP
The active field name in the info box.
.PP
ColInfoFields \fIforeground/background\fP
.IP
The data fields in the info box.
.PP
ColOptsFrame \fIforeground/background\fP
.IP
The border of the options dialog window.
.PP
ColInvOptsFrame \fIforeground/background\fP
.IP
The active OK or Cancel button in the options dialog window.
.PP
ColOptsLabels \fIforeground/background\fP
.IP
The field names in the options dialog window. Similar to
ColInfoLabels.
.PP
ColInvOptsLabels \fIforeground/background\fP
.IP
The active field name in the options dialog window.
.PP
ColOptsFields \fIforeground/background\fP
.IP
The data field in the options dialog window.
.PP
ColFdlgHeader \fIforeground/background\fP
.IP
The top part of the file selection dialog window.
.PP
ColFdlgList \fIforeground/background\fP
.IP
The file list in the file selection dialog window.
.PP
ColInvFdlgList \fIforeground/background\fP
.IP
The highlighted item in the file list.
.PP
ColFdlgListSel \fIforeground/background\fP
.IP
The selected items of the file list in the file selection dialog.
.PP
ColInvFdlgListSel \fIforeground/background\fP
.IP
The highlighted selected item in the file list.
.PP
ColFdlgPath \fIforeground/background\fP
.IP
The line of the file selection dialog which displays the current path.
.PP
ColFdlgBtn \fIforeground/background\fP
.IP
The bottom part of the file selection dialog window with the OK and
Cancel button.
.PP
ColInvFdlgBtn \fIforeground/background\fP
.IP
The active OK or Cancel button in file selection dialog.
.PP
ColContHeader \fIforeground/background\fP
.IP
The top part of the window with the list of archive contents.
.PP
ColContList \fIforeground/background\fP
.IP
The list of archive contents itself.
.PP
ColInvContList \fIforeground/background\fP
.IP
The highlighted item in the list of archive contents.
.PP
ColContListSel \fIforeground/background\fP
.IP
The selected items of the list of archive contents.
.PP
ColInvContListSel \fIforeground/background\fP
.IP
The highlighted selected item in the list of archive contents.
.PP
ColContBtn \fIforeground/background\fP
.IP
The bottom part of the window with the list of archive contents with
the OK and Cancel button.
.PP
ColInvContBtn \fIforeground/background\fP
.IP
The active OK or Cancel button in the window with the list of archive
contents.
.PP
ColTapeStatusWin \fIforeground/background\fP
.IP
The window with the tape status information.
.PP
ColTapeStatusBtn \fIforeground/background\fP
.IP
The Cancel button in the tape status window.
.PP
ColTapeListHeader \fIforeground/background\fP
.IP
The top part of the tape list window.
.PP
ColTapeList \fIforeground/background\fP
.IP
The color of the entries in the tape list window.
.PP
ColInvTapeList \fIforeground/background\fP
.IP
The highlighted item in the tape list.
.PP
ColTapeListSel \fIforeground/background\fP
.IP
The selected items in the tape list.
.PP
ColInvTapeListSel \fIforeground/background\fP
.IP
The highlighted line with a selected item in the tape list window.
.PP
ColTapeListBtn \fIforeground/background\fP
.IP
The bottom part of the tape list window with OK and Cancel button.
.PP
ColInvTapeListBtn \fIforeground/background\fP
.IP
The active OK and Cancel button in the tape list window.
.PP
.SH ENVIRONMENT
.TP
.B TAPE\c
TAPE has to be set to your non-rewind tape device, e.g.
TAPE=/dev/nrmt0.
.SH FILES
$HOME/.ntaperc
.IP
The ntape configuration file.
.PP
The following files reside in the directory specified by
\fIDatabasePath\fP in your configuration file.

ntape_archives
.IP
This file contains all archive dependent informations separated by
line feeds in plain ASCII format so you can get a pretty printer
output by piping the file through a simple awk command or shell script
for example.
.PP
ntape_tapes
.IP
All registered tapes are stored in this file.
.PP
ntape_contents
.IP
This file contains the contents of all archives whose "Save Contents"
flag is toggled to Yes.
.PP
.SH LIMITATIONS
\fIntape\fP expects a tape drive that supports seek and tell at
least. Additionally \fIntape\fP tries to detect if your tape is
off-line or if it is write protected. This may not work with some
tapes due to my limited hardware access. If you have problems in this
section please contact me.
.br
One archive can only consist of files and directories  which reside
all in the same directory.
.br
ntape is not very useful on terminals with no color support. This
should be fixed in the future.
.br
It seems that some keys don't work in a colored xterm. For me this
happens with HOME and END.
.SH BUGS
\fIntape\fP is still very new to the LinuX world and has certainly
some bugs. Please report them so they can be fixed.
.SH "SEE ALSO"
mt(1), ncurses(3X)
.SH COPYRIGHT
\fIntape\fP is original work of Matthias Hanisch with help of some
other contributors. Please mail criticism, bug reports, bug fixes,
suggestions and donations to
.br
<hanisch@cip.informatik.uni-wuerzburg.de>
