/*************************************************************************/
/* ntape - a tape archiver                                               */
/* Module:  menu.c                                                       */
/* Author:  Matthias Hanisch                                             */
/*************************************************************************/
/*                                                                       */
/* This program is free software; you can redistribute it and/or modify  */
/* it under the terms of the GNU General Public License as published by  */
/* the Free Software Foundation; either version 2 of the License, or     */
/* (at your option) any later version.                                   */
/*                                                                       */
/* This program is distributed in the hope that it will be useful,       */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/* GNU General Public License for more details.                          */
/*                                                                       */
/* You should have received a copy of the GNU General Public License     */
/* along with this program; if not, write to the Free Software           */
/* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                       */
/*************************************************************************/

#include <ntape.h>

#define NO_CELLS 2
static char *cell[] = {"Tape","Utilities","Options"};
static int active = 0;

/*************************************************************************/
/* Name:     print_menu                                                  */
/* Purpose:  Prints text in last line.                                   */
/*************************************************************************/
void print_menu()
{
    int i;

    wmove(menu,0,0);

    for (i = 0; i <= NO_CELLS; i++)
    {    
	waddstr(menu,"    ");
	if (i == active)
	{
	    set_color_pair(menu,INV_MENU);
	    waddstr(menu,cell[i]);
	    set_color_pair(menu,MENU);
	}
	else
	{
	    waddstr(menu,cell[i]);
	}
    }
    winclrtoeol(menu);
    touchwin(menu);
    wrefresh(menu);
}

/*************************************************************************/
/* Name:     change_menu                                                 */
/* Purpose:  Change to next/previous menu item.                          */
/*************************************************************************/
void change_menu(int direction)
{
    int old_active;
  
    old_active = active;
    if (direction) /* right */
    {
	if (active == NO_CELLS)
	    active = 0;
	else
	    active++;
    }
    else /* left */
    {
	if (active == 0)
	    active = NO_CELLS;
	else
	    active--;
    }
    if (popup_active)
    {
	switch(old_active)
	{
	case 0:
	    destroy_tape_popup();
	    break;
	case 1:
	    destroy_utils_popup();
	    break;
	case 2:
	    destroy_options_popup();
	    break;
	default:
	    break;
	}
      
	switch(active)
	{
	case 0:
	    tape_chosen();
	    break;
	case 1:
	    utils_chosen();
	    break;
	case 2:
	    options_chosen();
	    break;
	default:
	    break;
	}
    }
    print_menu();
}

/*************************************************************************/
/* Name:     choose_menu                                                 */
/* Purpose:  Opens the selected menu popup.                              */
/*************************************************************************/
void choose_menu()
{
    switch(active)
    {
    case 0:
	tape_chosen();
	break;
    case 1:
	utils_chosen();
	break;
    case 2:
	options_chosen();
	break;
    default:
	break;
    }
}


/*************************************************************************/
/* Name:     choose_cell                                                 */
/* Purpose:  Executes selected menu item.                                */
/*************************************************************************/
void choose_cell()
{
    switch(active)
    {
    case 0:
	tape_chosen_cell();
	break;
    case 1:
	utils_chosen_cell();
	break;
    case 2:
	options_chosen_cell();
	break;
    default:
	break;
    }
}


/*************************************************************************/
/* Name:     scroll_down_popup                                           */
/* Purpose:  Scrolls down in menu popup                                  */
/*************************************************************************/
void scroll_down_popup()
{
    switch(active)
    {
    case 0:
	tape_scroll_down();
	break;
    case 1:
	utils_scroll_down();
	break;
    case 2:
	options_scroll_down();
	break;
    default:
	break;
    }
}


/*************************************************************************/
/* Name:     scroll_up_popup                                             */
/* Purpose:  Scrolls up in menu popup.                                   */
/*************************************************************************/
void scroll_up_popup()
{
    switch(active)
    {
    case 0:
	tape_scroll_up();
	break;
    case 1:
	utils_scroll_up();
	break;
    case 2:
	options_scroll_up();
	break;
    default:
	break;
    }
}


/*************************************************************************/
/* Name:     destroy_popup                                               */
/* Purpose:  Closes popup window.                                        */
/*************************************************************************/
void destroy_popup()
{
    switch(active)
    {
    case 0:
	destroy_tape_popup();
	break;
    case 1:
	destroy_utils_popup();
	break;
    case 2:
	destroy_options_popup();
	break;
    default:
	break;
    }
}


/*************************************************************************/
/* Copyright (C) 1994,1995 Matthias Hanisch, Wuerzburg                   */
/*************************************************************************/
