/*************************************************************************/
/* ntape - a tape archiver                                               */
/* Module:  footer.c                                                     */
/* Author:  Matthias Hanisch                                             */
/*************************************************************************/
/*                                                                       */
/* This program is free software; you can redistribute it and/or modify  */
/* it under the terms of the GNU General Public License as published by  */
/* the Free Software Foundation; either version 2 of the License, or     */
/* (at your option) any later version.                                   */
/*                                                                       */
/* This program is distributed in the hope that it will be useful,       */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of        */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         */
/* GNU General Public License for more details.                          */
/*                                                                       */
/* You should have received a copy of the GNU General Public License     */
/* along with this program; if not, write to the Free Software           */
/* Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.             */
/*                                                                       */
/*************************************************************************/

#include <ntape.h>


/*************************************************************************/
/* Name:     print_footer                                                */
/* Purpose:  Prints text in last line                                    */
/*************************************************************************/
void print_footer(char *text)
{
    mvwaddch(foot,0,0,' ');
    waddstr(foot,text);
    winclrtoeol(foot);
    touchwin(foot);
    wrefresh(foot);
}


/*************************************************************************/
/* Copyright (C) 1994,1995 Matthias Hanisch, Wuerzburg                   */
/*************************************************************************/
