#!/bin/sh

# In DATABASEPATH you should specify the home of the ntape database files
DATABASEPATH=$HOME/database

# If you really want to edit the following line, you have to edit the source
# code, too. So think twice!!
NTAPERC=$HOME/.ntaperc


if [ ! -d $DATABASEPATH ]; then
	echo "Creating directory" $DATABASEPATH
	mkdir $DATABASEPATH
fi


echo "Creating database files"

if [ ! -f $DATABASEPATH/ntape_archives ]; then
	echo "Creating archive database header..."
	echo "# Archive Database V0.15" > $DATABASEPATH/ntape_archives
else
	echo "Archive database exists. Nothing done."
fi
if [ ! -f $DATABASEPATH/ntape_tapes ]; then
	echo "Creating tape database header..."
	echo "# Tape Database V0.18" > $DATABASEPATH/ntape_tapes
else
	echo "Archive database exists. Nothing done."
fi
echo "Touching contents database..."
touch $DATABASEPATH/ntape_contents


echo "Creating your .ntaperc" 

if [ -f $HOME/.ntaperc ]; then
	echo "Renaming your .ntaperc to .ntaperc.old"
	mv $NTAPERC $NTAPERC.old
fi

cat << EOF > $NTAPERC
# This is the place for the databases
DatabasePath	$DATABASEPATH

# I want it sorted by name. And ascending.
DefaultSortOrder	name
#DefaultSortOrder	size
#DefaultSortOrder	position

DefaultSortType         Ascending
#DefaultSortType        Descending

# Some Platforms I use. The first one is the default.
# No more than 20 entries, each entry no longer than 20 chars.
Platform	Unknown
Platform	DOS
Platform	Unix/Linux
Platform	Windows
Platform	OS/2
Platform	Macintosh

# The Category is a nice thing to say more about your archive
# No more than 20 entries, each entry no longer than 20 chars.
Category	Unknown
Category	Misc
Category	Game
Category	Utility
Category	Backup

# Since the contents file would grow too much, I don't
# want to save the archive contents by default.
SaveContents		No

# I like to see what ntape makes with my tape. Maybe
# because I don't trust my own program?
WatchTape		Yes

# Color configuration
# You can define pairs of colors (foreground/background) for certain
# areas. e.g. the menu at the top on the window. The syntax is
# <area>	<foreground>/<background>
#
# The following colors are available:
# black, red, green, yellow, blue, magenta, cyan, white
# Additionally it is possible to set the bold attribute for the
# foreground color which makes it brighter. Just add the keyword
# 'light' in front of the color name, e.g.
# ColMenu	lightred/blue

# The following configuration needs a terminal that supports the bold
# attribute. Please look in the color_conf directory for alternative
# configurations!
# ** If your terminal isn't able to display bold colors you should at least  **
# ** replace the lightwhite/white combinations with black/white for example. **

ColMenu			lightwhite/magenta	# The menu with popups at the top
ColInvMenu		lightyellow/magenta	# The highlighted part of the menu

ColStatusline		lightyellow/blue	# The second line on the screen

ColArchiveList		white/black		# The list of archives
ColInvArchiveList	lightwhite/white	# The highlighted line in the list

ColFooter		lightyellow/blue	# The last line on the screen

ColMessageBox		lightwhite/blue		# The message boxes (e.g. quit)
ColInvMessageBox	lightyellow/blue	# Active OK or Cancel at message box

ColInputDialog		lightwhite/magenta	# The input dialog (e.g. set tape name)
ColInvInputDialog	lightyellow/magenta	# Active OK or Cancel at input dialog
ColEntryField		lightwhite/white	# Entryfield at input dialog

ColTapeOpLog		lightwhite/blue		# The tape operations log window

ColInfoFrame		lightwhite/blue		# The archive information border
ColInvInfoFrame		lightyellow/blue	# Active Cancel,Extract,etc. 
ColInfoLabels		lightwhite/magenta	# Labels, e.g. Archive name, Tape, Size
ColInvInfoLabels	lightyellow/magenta	# The active label
ColInfoFields		lightwhite/blue		# The data fields

ColOptsFrame		lightwhite/cyan		# The options border
ColInvOptsFrame		lightyellow/cyan	# Active OK or Cancel at options dialog
ColOptsLabels		lightwhite/blue		# Labels, e.g. Sort order, Watch tape
ColInvOptsLabels	lightyellow/blue	# The active label
ColOptsFields		lightwhite/magenta	# The options data fields

ColFdlgHeader		lightwhite/cyan		# The top of the file selection dialog
ColFdlgList		white/blue		# The file list
ColInvFdlgList          lightwhite/white 	# The highlighted line in list
ColFdlgListSel		magenta/blue		# Selected items
ColInvFdlgListSel	lightmagenta/white      # The highlighted line with a selected item in the list
ColFdlgPath		lightwhite/cyan		# Current path
ColFdlgBtn		lightwhite/blue		# OK and Cancel button
ColInvFdlgBtn		lightyellow/blue	# The active one

ColContHeader		lightwhite/cyan		# The top of the archive contents list
ColContList		white/blue		# The contents list
ColInvContList		lightwhite/white	# The highlighted line in list
ColContListSel		magenta/blue		# Selected items
ColInvContListSel       lightmagenta/white     	# The highlighted line with a selected item in the list
ColContBtn		lightwhite/cyan		# OK and Cancel button
ColInvContBtn		lightyellow/cyan	# The active one

ColTapeStatusWin	lightwhite/blue		# The tape status window
ColTapeStatusBtn	lightyellow/blue	# The Cancel button

ColTapeListHeader	lightwhite/cyan		# The top of tape list header
ColTapeList		white/blue		# The tape list
ColInvTapeList		lightwhite/white	# The highlighted line in list
ColTapeListSel		magenta/blue		# Selected items
ColInvTapeListSel       lightmagenta/white	# The highlighted line with a selected item in the list
ColTapeListBtn		lightwhite/cyan		# OK and Cancel button
ColInvTapeListBtn	lightyellow/cyan	# The active one
EOF
