/*	Copyright (c) 1993 by Tycho Softworks.  All rights reserved.

	VU Terminal Database Support;
*/

#ifndef __PROTOTYPES_H__
#include <prototypes.h>
#endif

#ifndef	__BOOL_H__
#include <bool.h>
#endif

#define	TERMLIB_HASH_SIZE	997

typedef	struct
{
	/*	key name and link	*/

	long	term_link;
	char	term_id[11];
	char	term_name[33];

	/*	properties			*/
	
	char	term_rows[4], term_cols[4];
	char	term_startup[19], term_shutdown[19];
	char	term_beep[7];
	char	term_cls[7];
	char	term_eol[7];
	char	term_eop[7];
	char	term_left[7];
	char	term_right[7];
	char	term_up[7];
	char	term_down[7];

	/*	cursor positioning	*/

	char	term_cursor_beg[4];
	char	term_cursor_sep[4];
	char	term_cursor_end[4];
	char	term_cursor_vt[4];
	
	bool	term_cursor_order;
	bool	term_cursor_decimal;
	char	term_cursor_offset[3];

	char	term_cursor_hide[7];
	char	term_cursor_show[7];
	char	term_cursor_big[7];
	
	/*	attributes			*/

	char	term_attr_beg[4];
	char	term_attr_sep[4];
	char	term_attr_end[4];
	bool	term_attr_merge;

	char	term_attr_clear[7];
	char	term_attr_inverse_on[7];
	char	term_attr_inverse_off[7];
	char	term_attr_bright_on[7];
	char	term_attr_bright_off[7];
	char	term_attr_underline_on[7];
	char	term_attr_underline_off[7];
	char	term_attr_graphics_on[7];
	char	term_attr_graphics_off[7];
	char	term_attr_blink_on[7];
	char	term_attr_blink_off[7];

	/*	color				*/

	char	term_color_beg[7];
	char	term_color_sep[7];
	char	term_color_end[7];
	char	term_color_fore[3];
	char	term_color_back[3];
	bool	term_color_order;
	bool	term_color_ansi;

	/*	charsets	*/

	char	char_shade;
	char	char_solid;
	char	char_top;
	char	char_bot;

	char	char_arrows[4];
	char	char_boxset[16];
	char	char_cards[4];

	bool	key_scancodes;
	char	key_table[20][7];

	char	term_stat_line[17];

	char	term_window_beg[4];
	char	term_window_sep[4];
	char	term_window_end[4];
	char	term_window_clr[17];
	char	term_window_up[7];
	char	term_window_down[7];
	char	term_window_offset[4];
	bool	term_window_cursor;
	bool	term_window_mode;

	char	key_alt_base[4];
	char	key_alt_prefix[7];
	char	key_move[4][7];

	bool	term_color_attr;
	char	term_export_id[13];
	bool	term_wrap_flag;
	bool	term_ansi_keypad;

	unsigned	char	char_stty_break;
	unsigned	char	char_stty_quit;
	unsigned	char	char_stty_start;
	unsigned	char	char_stty_stop;
	unsigned	char	char_stty_eof;
	unsigned	char	char_stty_kill;
	unsigned	char	char_stty_erase;
	bool	tab_stty_expand;
	char	future[128];
}	TERMDEF;

IMPORT	BOOL		OpenVUTermlib PROTO((void));
IMPORT	void		CloseVUTermlib PROTO((void));
IMPORT	TERMDEF		*LoadVUTermlib PROTO((char *name));
IMPORT	char		*AliasVUTermlib PROTO((char *term));
IMPORT	TERMDEF		*SaveVUTermlib PROTO((TERMDEF *tdef));
IMPORT	TERMDEF		*FirstVUTermlib PROTO((void));
IMPORT	TERMDEF		*NextVUTermlib PROTO((void));
IMPORT	TERMDEF		*DeleteVUTermlib PROTO((char *name));
IMPORT	int			PutVUTermstr PROTO((char *str, char *out));
IMPORT	int			KeyVUTermlib PROTO((char *key));
IMPORT	void		GetVUCodepage PROTO((int cp));


