/*	Copyright (c) 1993 by Tycho Softworks.  All rights reserved.

	Communication services include file.
*/

typedef	enum
{
	COM_OK=0,
	COM_BAD_DEVICE,
	COM_BUSY,
	COM_NO_POOL
}	COM_STATUS;

typedef	struct	
{
	int	mode_sw_flow;
	int	mode_hw_flow;
	unsigned	mode_baud;
	int	mode_parity;
	int	mode_data;
	int	mode_stop;
}	COM_MODE;

typedef	enum
{
	NO_PARITY,
	ODD_PARITY,
	EVEN_PARITY,
	MARK_PARITY,
	SPACE_PARITY
}	PARITY;


#ifdef	__MSDOS__
#define	_COM_CHR5	0
#define	_COM_CHR6	1

#define	_COM_FOSSIL_ON	4
#define	_COM_FOSSIL_OFF	5
#define	_COM_X00_ON		0x1c
#define	_COM_X00_OFF	0x1d
#define	_COM_19200		_COM_110
#define	_COM_38400		_COM_150

#define	_COM_PS2_INIT	4

#define	_COM_FOSSIL_PURGE	0x0a
#define	_COM_FOSSIL_DTR		0x06
#define	_COM_FOSSIL_FLOW	0x0f

#define	_COM_HW_FLOW		0x02
#define	_COM_SW_FLOW		0x09

typedef	enum
{
	PORT,
	BIOS,
	X00,
	FOSSIL,
	PS2
}	PORT_TYPE;	

extern	PORT_TYPE	port_type;
#endif

extern	int	portid;
extern  int ser_data;           /* Uart data register */
extern  int ser_stat;           /* Uart line-status register */
extern  int ser_ctrl;           /* Uart line-control register */

#ifdef	__ANSI__

COM_STATUS	ComStartup(char	*port, int busy);
void    ComShutdown(void);
int		ComPending(void);
int		ComGetChar(void);
void	ComPutChar(int);
void	ComPutString(char *s);
void	ComMode(int mode, COM_MODE *info);
void	ComFlush(void);
int		ComDropLine(void);
int		ComRead(char *buf,int len, char	*term, int timeout);
int		ComWrite(char *buf,int len, int timeout);
int		ComSync(char *list,int timeout);
COM_STATUS	ComPoolStartup(char *dialer, unsigned baud);
char	*ComLookupAddress(char *symbolic_name);
unsigned	ModemConnect(char *addr,int timeout,char *connect);
void		ModemRelease();

#else

extern	char	*ComLookupAddress();

#endif

#define	ComGetMode(info)	ComMode(0,info)
#define	ComSetMode(info)	ComMode(1,info)

