#ifndef	__UNIXDEV_H__
#define	__UNIXDEV_H__

#ifndef	__PROTOTYPES_H__
#include <prototypes.h>
#endif

#ifndef	__STREAM_H__
#include <sys_stream.h>
#endif

#include <sys/types.h>
#include <sys/socket.h>

#ifdef	LINUX
#define	__DEV_SELECT
#endif

#ifdef	__DEV_SELECT
#include <select.h>
#else
#include <poll.h>
#endif

#define	UNIXDEV_PREFIX	"/dev/"

#ifndef	MAX_CONNECTIONS
#define	MAX_CONNECTIONS	16
#endif

typdef	struct
{
	char	dev_name[33];
	int		dev_cnt;
	int		dev_limit;
	int		dev_event;
	int		dev_events;
	int		dev_connection[MAX_CONNECTIONS];	
#ifdef	__DEV_SELECT
	fd_set	dev_input, dev_output, dev_other;
#else
	struct	pollfd	dev_poll[MAX_CONNECTIONS];
#endif
}	UNIXDEV;

#define	get_connection (dev, id)	(dev->dev_connection[id])
#define	detach_device(dev, id)		(dev->dev_connection[id] = -1)

IMPORT	UNIXDEV	*create_device PROTO((char *devname, int maxdev));
IMPORT	void	destroy_device PROTO((UNIXDEV *dev));
IMPORT	void	attach_device PROTO((UNIXDEV *dev, int fd));
IMPORT	int		accept_device PROTO((UNIXDEV *dev));
IMPORT	int		wait_device PROTO((UNIXDEV *dev, int timeout));
IMPORT	STREAM	*open_device PROTO((char *devname));
IMPORT	void	close_device PROTO((STREAM *dev));

#endif 

